"use strict";
exports.id = 2105;
exports.ids = [2105];
exports.modules = {

/***/ 76066:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({"src":"/_next/static/media/delivery.a125dcaf.png","height":120,"width":116,"blurDataURL":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAA+UlEQVR42mN42sTA9iiLQfn9zhjV/9+rVD9dTFG5VqyvfqdDj48BBF7NSlF/2peZ93azZ+b/b5lZny7EZl7M1yu61qDrAFbwYm621qOZlVkvV5uk/LntlvruqHfK6Xz9nLNVus5gBXfqLDWvFRlkX60xTz1fYZ52qdIk5Wyubt7JOBF7sIKrlbaaNyd4ZF7uckk+k2GYsqVNN6XteFlW77mmEIZzDGwMV2pMtb5c8C/+cMYv92SiYl7RWvOcdS/XJ2+4vzyfYRuDOcO1Gk3um31Khhc7lI1PxarpJy3ScF58dkZ2zLaINIaVDAoMWEEnUGIWgxgDAwMDAP33ZbJ4N5VUAAAAAElFTkSuQmCC","blurWidth":8,"blurHeight":8});

/***/ }),

/***/ 93190:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({"src":"/_next/static/media/order-confirmed.5101de51.png","height":120,"width":116,"blurDataURL":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAA7ElEQVR42k2JQU6DQBhG/3OZuPAQLlzQgzQmXsOVW+LQBdUYjXGlbVNMlDYFjEoNbQ3CUBwYhmjjhE+661u9vEduHJuvPMHd6kOfRBGO5yGMl0AfBR4Onp9Mor7NyBmDBg+aRgPQaNj6vabHtl30GfUmLjv3ZjCnE93zfVi+B8ubaSto3XUZ/SjF4sUCUfiulfiG4BzrJNF5mkKVJSNV1+ZytcRbON+I+hefPEecJBueZSiKwqRKyquylMjSL1TD06YanzVizaFUje0jKfL9SsNQ08surg+B2w6ka3flH4zto12am47T2HvObvsHqAW8FZ8GCKUAAAAASUVORK5CYII=","blurWidth":8,"blurHeight":8});

/***/ }),

/***/ 96701:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({"src":"/_next/static/media/out-for-delivery.5778f777.png","height":120,"width":108,"blurDataURL":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAcAAAAICAYAAAA1BOUGAAAA0UlEQVR42mMAgX+HGHj+b2PQYUAH/3YwCPzba3/636H4//92MlQwMDAw/NjpwsIAAv+XMTj9P1b7///Lk///b2Q4D9P09XA0E8O/HLvV/2Zo/P+/Xu/v33LlXz+z3QIRxsbZnPkfY/D/d5rGr//2DP9O9y3/v27d0W3//zMwM/zy1bzw2UPv/y8ruf9/dBn+f51l///9ybj//475zGd4tHnjvKV97d+fbd137OO+i4cvbl1/bsXCzq/XL17sYQCD1GR5Bhjo+8/MwJAmy8DAwAAAzxdkVnS+Z0QAAAAASUVORK5CYII=","blurWidth":7,"blurHeight":8});

/***/ }),

/***/ 50862:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({"src":"/_next/static/media/shhiped.1280b948.png","height":120,"width":112,"blurDataURL":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAcAAAAICAYAAAA1BOUGAAAAsklEQVR42kWJoQ6CYBhFP4rRqMXsE6AzGdzcNFi0SHBOFKuRROIVdGY7JqaYMDEtROdm5hEgcq8/OMfd7s7OjmA600SNG6MOkTkmo3rhGIw1we7wi9bWx/5ImJZfRvekCRmVEb1VzFtI9tdx4eRbkzKk9pD3ZQKpEeEiYWYP5T98DJevGeF1UyhSeRUfuo1IJ6JOVvKp21W8Np380mIeNNUbRNBwqniWtroJT+YFc+UiIl/EfGJgQcpNYwAAAABJRU5ErkJggg==","blurWidth":7,"blurHeight":8});

/***/ }),

/***/ 44339:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({"src":"/_next/static/media/delivery-truck.f9f5a168.png","height":512,"width":512,"blurDataURL":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAA2UlEQVR42mPABb5VOLG+Z3BhBHP+HWSXA2K3/wfZ7f/tB9JXGcQZYODfQbbc/wfYD/87wPn/337u//8Pcvz/s15o2SsGBtN3DAx8DP/3cZj+P8J86P9Rhv//DzP8+n+S4eevRT7/fp0+///HhI4FEFPWiW77ulL1/6s1hn//rOb//6PN/P/jGXP/vS3K/g9W8J+BIWxfdNrLmqbe3x/E1fd8UJHf01hW/XdrXMJNhiOGAUxgVZ1V3F4ZmdoMUOBeUqvF0NTPC+acifZhYoCCZ5FOzM8CnZlhfAACi2D6U6d5XwAAAABJRU5ErkJggg==","blurWidth":8,"blurHeight":8});

/***/ }),

/***/ 18165:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({"src":"/_next/static/media/route.bcac5a91.png","height":30,"width":30,"blurDataURL":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAApElEQVR42l2MOwoCMRRFn9haikwjmrGz8oOCoBYBwcpPoc0w4x/dQeIq7Nxlki14Aql8cLg397488UZt4QqXYPJMGHw9UYuPu7eqQEvQ8j+EFQsz9ADTlA1AB6NaQjnnMfYm16kcwhOO8JAUflksne028BoKuMFJ4lDuYUdwhhV+zfk2voxlH7NBJ+gifVjCK1jVFMIeVC5esJ3MGTWifJN9RER+dUtfOQExgQQAAAAASUVORK5CYII=","blurWidth":8,"blurHeight":8});

/***/ }),

/***/ 65213:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "UK": () => (/* binding */ CardWrapper),
/* harmony export */   "ef": () => (/* binding */ BodyWrapper),
/* harmony export */   "qo": () => (/* binding */ TimeWrapper),
/* harmony export */   "yj": () => (/* binding */ ChatMessageWrapper),
/* harmony export */   "zU": () => (/* binding */ CustomAvatar)
/* harmony export */ });
/* harmony import */ var _mui_material_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(18442);
/* harmony import */ var _mui_material_styles__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_mui_material_styles__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_material_Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(19);
/* harmony import */ var _mui_material_Box__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material_Box__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(97986);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_system__WEBPACK_IMPORTED_MODULE_3__);




const ChatMessageWrapper = (0,_mui_material_styles__WEBPACK_IMPORTED_MODULE_0__.styled)((_mui_material_Box__WEBPACK_IMPORTED_MODULE_1___default()))(({ theme , authortype , usertype , language_direction  })=>({
        display: "flex",
        flexDirection: authortype === usertype ? "row-reverse" : "row",
        alignItems: "center",
        gap: "10px",
        width: "100%",
        maxWidth: "450px",
        marginLeft: authortype === usertype ? language_direction === "rtl" ? 0 : "auto" : 0,
        marginBottom: "1rem",
        marginRight: authortype === usertype ? language_direction === "rtl" ? "auto" : 0 : 0
    }));
const CustomAvatar = (0,_mui_material_styles__WEBPACK_IMPORTED_MODULE_0__.styled)(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Avatar)(({ theme , authortype , usertype  })=>({
        height: 32,
        marginLeft: authortype === usertype ? 2 : 0,
        marginRight: authortype === usertype ? 0 : 2,
        width: 32
    }));
const BodyWrapper = (0,_mui_material_styles__WEBPACK_IMPORTED_MODULE_0__.styled)((_mui_material_Box__WEBPACK_IMPORTED_MODULE_1___default()))(({ theme , authortype , usertype  })=>({
        flexGrow: 1,
        maxWidth: `500 !important`,
        display: "flex",
        flexDirection: "column",
        alignItems: authortype === usertype ? "flex-end" : "flex-start",
        width: "100%"
    }));
const CardWrapper = (0,_mui_material_styles__WEBPACK_IMPORTED_MODULE_0__.styled)(_mui_system__WEBPACK_IMPORTED_MODULE_3__.Stack)(({ theme , authortype , usertype  })=>({
        backgroundColor: authortype === usertype ? theme.palette.primary.main : (0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.alpha)(theme.palette.primary.main, 0.2),
        color: authortype === usertype ? theme.palette.primary.contrastText : "text.primary",
        padding: "8px 20px",
        borderRadius: authortype === usertype ? "25px 25px 0px 25px" : "25px 25px 25px 0px"
    }));
const TimeWrapper = (0,_mui_material_styles__WEBPACK_IMPORTED_MODULE_0__.styled)((_mui_material_Box__WEBPACK_IMPORTED_MODULE_1___default()))(({ theme , authortype , usertype  })=>({
        display: "flex",
        justifyContent: authortype === usertype ? "flex-end" : "flex-start",
        marginTop: 1,
        paddingTop: 2
    }));


/***/ }),

/***/ 17446:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6022);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var moment_moment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(13332);
/* harmony import */ var moment_moment__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(moment_moment__WEBPACK_IMPORTED_MODULE_2__);



const CustomFormatedDateTime = ({ date  })=>{
    const { configData  } = (0,react_redux__WEBPACK_IMPORTED_MODULE_1__.useSelector)((state)=>state.configData);
    let timeFormat = configData?.timeformat;
    if (timeFormat === "12") {
        return moment_moment__WEBPACK_IMPORTED_MODULE_2___default()(date).format("ll hh:mm a");
    } else {
        return moment_moment__WEBPACK_IMPORTED_MODULE_2___default()(date).format("ll HH:mm");
    }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CustomFormatedDateTime);


/***/ }),

/***/ 90751:
/***/ ((__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) => {

/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6022);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(32245);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_1__);


const CustomFormatedTime = ({ date  })=>{
    const { configData  } = useSelector((state)=>state.configData);
    let timeFormat = configData?.timeformat;
    if (timeFormat === "12") {
        return moment(date).format("hh:mm a");
    } else {
        return moment(date).format("HH:mm");
    }
};
/* unused harmony default export */ var __WEBPACK_DEFAULT_EXPORT__ = ((/* unused pure expression or super */ null && (CustomFormatedTime)));


/***/ }),

/***/ 30700:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Gr": () => (/* binding */ OrderStatusButton),
/* harmony export */   "To": () => (/* binding */ TrackOrderButton),
/* harmony export */   "d$": () => (/* binding */ DateTypography),
/* harmony export */   "vY": () => (/* binding */ InformationGrid)
/* harmony export */ });
/* unused harmony exports OrderIdTypography, OrderAmountTypography, SuccessButton, PendingButton, HeadingBox, OrderStatusBox, OrderStatusGrid */
/* harmony import */ var _mui_material_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(18442);
/* harmony import */ var _mui_material_styles__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_mui_material_styles__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(97986);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_system__WEBPACK_IMPORTED_MODULE_2__);



const OrderIdTypography = (0,_mui_material_styles__WEBPACK_IMPORTED_MODULE_0__.styled)(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography)(({ theme  })=>({
        [theme.breakpoints.up("xs")]: {
            fontSize: "14px"
        },
        [theme.breakpoints.up("md")]: {
            fontSize: "22px"
        }
    }));
const DateTypography = (0,_mui_material_styles__WEBPACK_IMPORTED_MODULE_0__.styled)(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography)(({ theme  })=>({
        color: theme.palette.text.secondary,
        fontSize: "12px",
        [theme.breakpoints.down("md")]: {
            fontSize: "10px"
        }
    }));
const OrderAmountTypography = (0,_mui_material_styles__WEBPACK_IMPORTED_MODULE_0__.styled)(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography)(({ theme  })=>({
        [theme.breakpoints.up("xs")]: {
            fontSize: "12px"
        },
        [theme.breakpoints.up("md")]: {
            fontSize: "16px"
        }
    }));
const SuccessButton = (0,_mui_material_styles__WEBPACK_IMPORTED_MODULE_0__.styled)(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button)(({ theme  })=>({
        background: "rgba(0, 171, 17, 0.1);",
        color: theme.palette.success.main,
        borderRadius: "5px",
        [theme.breakpoints.up("xs")]: {
            width: "59.68px",
            height: "20.56px",
            fontSize: "12px"
        },
        [theme.breakpoints.up("md")]: {
            width: "88px",
            height: "30px",
            fontSize: "14px"
        }
    }));
const PendingButton = (0,_mui_material_styles__WEBPACK_IMPORTED_MODULE_0__.styled)(_mui_system__WEBPACK_IMPORTED_MODULE_2__.Box)(({ theme  })=>({
        textAlign: "center",
        textTransform: "capitalize",
        background: "rgba(0, 95, 149, 0.1)",
        color: theme.palette.info.dark,
        borderRadius: "5px",
        padding: "5px",
        width: "auto",
        [theme.breakpoints.down("md")]: {
            maxWidth: "100px"
        },
        [theme.breakpoints.up("xs")]: {
            fontSize: "12px"
        },
        [theme.breakpoints.up("md")]: {
            fontSize: "16px"
        }
    }));
const TrackOrderButton = (0,_mui_material_styles__WEBPACK_IMPORTED_MODULE_0__.styled)(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button)(({ theme  })=>({
        width: "100%",
        color: theme.palette.primary.main,
        borderRadius: "5px",
        alignItems: "center",
        padding: "6px 12px",
        "&:hover": {
            backgroundColor: theme.palette.primary.dark,
            color: theme.palette.whiteContainer.main
        },
        [theme.breakpoints.down("md")]: {
            padding: "2px 5px",
            fontSize: "12px",
            backgroundColor: theme.palette.primary.main,
            color: theme.palette.whiteContainer.main,
            fontWeight: 500
        }
    }));
const HeadingBox = (0,_mui_material_styles__WEBPACK_IMPORTED_MODULE_0__.styled)(_mui_system__WEBPACK_IMPORTED_MODULE_2__.Box)(()=>({
        padding: "10px 0px 20px 0px"
    }));
const OrderStatusBox = (0,_mui_material_styles__WEBPACK_IMPORTED_MODULE_0__.styled)(_mui_system__WEBPACK_IMPORTED_MODULE_2__.Box)(({ theme  })=>({
        padding: "7px 0px 20px 0px",
        [theme.breakpoints.up("xs")]: {
            textAlign: "center"
        }
    }));
const OrderStatusGrid = (0,_mui_material_styles__WEBPACK_IMPORTED_MODULE_0__.styled)(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Grid)(({ theme  })=>({
        background: theme.palette.neutral[300],
        borderRadius: "14px",
        padding: "20px",
        rowGap: "10px"
    }));
const InformationGrid = (0,_mui_material_styles__WEBPACK_IMPORTED_MODULE_0__.styled)(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Grid)(({ theme  })=>({
        background: theme.palette.primary.custom6,
        borderRadius: "14px",
        padding: "20px",
        [theme.breakpoints.down("md")]: {
            background: theme.palette.neutral[100],
            padding: "12px"
        }
    }));
const OrderStatusButton = (0,_mui_material_styles__WEBPACK_IMPORTED_MODULE_0__.styled)(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button)(({ theme , background , fontcolor  })=>({
        backgroundColor: background,
        color: theme.palette.neutral[100],
        textTransform: "capitalize",
        padding: "6px 10px",
        borderRadius: "8px",
        "&:hover": {
            backgroundColor: (0,_mui_material__WEBPACK_IMPORTED_MODULE_1__.alpha)(background, 0.9)
        },
        [theme.breakpoints.down("md")]: {
            padding: "5px 5px",
            fontSize: "10px"
        }
    }));


/***/ }),

/***/ 62935:
/***/ ((module, __unused_webpack___webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45269);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _CustomImageContainer__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(58861);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(41664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _mui_icons_material_Chat__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(54242);
/* harmony import */ var _mui_icons_material_Chat__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material_Chat__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _api_manage_hooks_react_query_googleApi__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(91326);
/* harmony import */ var _api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(67759);
/* harmony import */ var _landing_page_hero_section_HeroSection_style__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(77591);
/* harmony import */ var _assets_delivery_truck_png__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(44339);
/* harmony import */ var _assets_route_png__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(18165);
/* harmony import */ var _chat_Message_style__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(65213);
/* harmony import */ var _search_CustomRatings__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(27559);
/* harmony import */ var _utils_CustomFunctions__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(81261);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_api_manage_hooks_react_query_googleApi__WEBPACK_IMPORTED_MODULE_8__, _api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_9__, _utils_CustomFunctions__WEBPACK_IMPORTED_MODULE_15__]);
([_api_manage_hooks_react_query_googleApi__WEBPACK_IMPORTED_MODULE_8__, _api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_9__, _utils_CustomFunctions__WEBPACK_IMPORTED_MODULE_15__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
















const DeliverymanInfo = (props)=>{
    const { data , configData , t  } = props;
    const productImage = configData?.base_urls?.delivery_man_image_url;
    const origin = {
        latitude: data?.delivery_man?.lat,
        longitude: data?.delivery_man?.lng
    };
    const destination = {
        latitude: data?.delivery_address?.latitude,
        longitude: data?.delivery_address?.longitude
    };
    const { data: distanceData , refetch: refetchDistance  } = (0,react_query__WEBPACK_IMPORTED_MODULE_7__.useQuery)([
        "get-distance",
        origin,
        destination
    ], ()=>_api_manage_hooks_react_query_googleApi__WEBPACK_IMPORTED_MODULE_8__/* .GoogleApi.distanceApi */ .K.distanceApi(origin, destination), {
        onError: _api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_9__/* .onErrorResponse */ .RJ
    });
    const away = t("away");
    const handleAway = ()=>{
        return (0,_utils_CustomFunctions__WEBPACK_IMPORTED_MODULE_15__/* .handleDistance */ .NY)(distanceData?.data?.rows?.[0]?.elements, origin, destination);
    };
    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__/* .CustomStackFullWidth */ .Xw, {
        alignItems: "center",
        spacing: 1.5,
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__/* .CustomTypographyBold */ .n2, {
                children: t("Trip Route")
            }),
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__/* .CustomStackFullWidth */ .Xw, {
                direction: "row",
                alignItems: "center",
                justifyContent: "space-between",
                spacing: 0.5,
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_landing_page_hero_section_HeroSection_style__WEBPACK_IMPORTED_MODULE_10__/* .CustomTypography */ .ZT, {
                        children: data?.delivery_man?.location
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_CustomImageContainer__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                        src: _assets_delivery_truck_png__WEBPACK_IMPORTED_MODULE_11__/* ["default"].src */ .Z.src,
                        height: "30px",
                        width: "60px"
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_landing_page_hero_section_HeroSection_style__WEBPACK_IMPORTED_MODULE_10__/* .CustomTypography */ .ZT, {
                        children: data?.delivery_address?.address
                    })
                ]
            }),
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__/* .CustomStackFullWidth */ .Xw, {
                alignItems: "center",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_CustomImageContainer__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                        src: _assets_route_png__WEBPACK_IMPORTED_MODULE_12__/* ["default"].src */ .Z.src,
                        height: "30px",
                        width: "30px"
                    }),
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__/* .CustomTypographyGray */ .mI, {
                        sx: {
                            fontSize: "18px"
                        },
                        children: [
                            handleAway().toFixed(2),
                            "km ",
                            t(`${away}`)
                        ]
                    })
                ]
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__/* .CustomStackFullWidth */ .Xw, {
                alignItems: "flex-start",
                justifyContent: "flex-start",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__/* .CustomTypographyBold */ .n2, {
                    variant: "h6",
                    children: t("Delivery man")
                })
            }),
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__/* .CustomStackFullWidth */ .Xw, {
                direction: "row",
                justifyContent: "space-between",
                alignItems: "center",
                children: [
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Stack, {
                        direction: "row",
                        justifyContent: "space-between",
                        alignItems: "center",
                        spacing: 1,
                        children: [
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_chat_Message_style__WEBPACK_IMPORTED_MODULE_13__/* .CustomAvatar */ .zU, {
                                avatarImage: `${productImage}/${data?.delivery_man?.image}`,
                                alt: data?.delivery_man?.f_name.concat(" ", data?.delivery_man?.l_name)
                            }),
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Stack, {
                                alignItems: "flex-start",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__/* .CustomTypographyBold */ .n2, {
                                        children: data?.delivery_man?.f_name.concat(" ", data?.delivery_man?.l_name)
                                    }),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_search_CustomRatings__WEBPACK_IMPORTED_MODULE_14__/* ["default"] */ .Z, {
                                        readOnly: true,
                                        ratingValue: data?.delivery_man?.avg_rating
                                    })
                                ]
                            })
                        ]
                    }),
                    data?.order_status !== "delivered" && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Stack, {
                        direction: "row",
                        spacing: 2,
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Stack, {
                            sx: {
                                cursor: "pointer"
                            },
                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((next_link__WEBPACK_IMPORTED_MODULE_5___default()), {
                                href: {
                                    pathname: "/chatting",
                                    query: {
                                        type: "delivery_man",
                                        id: data?.delivery_man?.id,
                                        routeName: "delivery_man_id",
                                        chatFrom: "true"
                                    }
                                },
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_icons_material_Chat__WEBPACK_IMPORTED_MODULE_6___default()), {
                                    sx: {
                                        height: 25,
                                        width: 25,
                                        color: (theme)=>theme.palette.neutral[500]
                                    }
                                })
                            })
                        })
                    })
                ]
            })
        ]
    });
};
DeliverymanInfo.propTypes = {};
/* unused harmony default export */ var __WEBPACK_DEFAULT_EXPORT__ = ((/* unused pure expression or super */ null && (DeliverymanInfo)));

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 93931:
/***/ ((__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) => {

/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45269);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_3__);




const DeliverymanShimmer = ()=>{
    return /*#__PURE__*/ _jsxs(CustomStackFullWidth, {
        alignItems: "center",
        spacing: 1.5,
        justifyContent: "center",
        children: [
            /*#__PURE__*/ _jsx(Skeleton, {
                variant: "text",
                width: "100px"
            }),
            /*#__PURE__*/ _jsxs(CustomStackFullWidth, {
                direction: "row",
                alignItems: "center",
                justifyContent: "space-between",
                spacing: 0.5,
                children: [
                    /*#__PURE__*/ _jsx(Skeleton, {
                        variant: "text",
                        width: "100px"
                    }),
                    /*#__PURE__*/ _jsx(Skeleton, {
                        variant: "rectangle",
                        width: "50px",
                        height: "50px"
                    }),
                    /*#__PURE__*/ _jsx(Skeleton, {
                        variant: "text",
                        width: "100px"
                    })
                ]
            }),
            /*#__PURE__*/ _jsxs(CustomStackFullWidth, {
                alignItems: "center",
                justifyContent: "center",
                spacing: 0.5,
                children: [
                    /*#__PURE__*/ _jsx(Skeleton, {
                        variant: "rectangle",
                        width: "50px",
                        height: "50px"
                    }),
                    /*#__PURE__*/ _jsx(Skeleton, {
                        variant: "text",
                        width: "100px"
                    })
                ]
            })
        ]
    });
};
/* unused harmony default export */ var __WEBPACK_DEFAULT_EXPORT__ = ((/* unused pure expression or super */ null && (DeliverymanShimmer)));


/***/ }),

/***/ 66696:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(97986);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_system__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var components_Map_location_view_MapComponent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(33244);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _mui_icons_material_GpsFixed__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(15594);
/* harmony import */ var _mui_icons_material_GpsFixed__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material_GpsFixed__WEBPACK_IMPORTED_MODULE_5__);






const TrackOrderMap = ({ trackOrderData , userLocation , getCurrentLocation  })=>{
    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_2__.Stack, {
        paddingInline: {
            xs: "0px",
            md: "25px"
        },
        position: "relative",
        width: "100%",
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_Map_location_view_MapComponent__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                latitude: userLocation.lat,
                longitude: userLocation?.lng,
                deliveryManLat: trackOrderData?.order_status === "picked_up" ? trackOrderData?.delivery_man?.lat : trackOrderData?.module_type === "parcel" ? trackOrderData?.receiver_details?.latitude : trackOrderData?.store?.latitude,
                deliveryManLng: trackOrderData?.order_status === "picked_up" ? trackOrderData?.delivery_man?.lng : trackOrderData?.module_type === "parcel" ? trackOrderData?.receiver_details?.longitude : trackOrderData?.store?.longitude,
                isStore: trackOrderData?.order_status === "picked_up" ? false : true
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_4__.IconButton, {
                onClick: getCurrentLocation,
                sx: {
                    position: "absolute",
                    bottom: "3%",
                    right: "3%",
                    borderRadius: "50%",
                    color: (theme)=>theme.palette.primary.main,
                    backgroundColor: "background.paper"
                },
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_icons_material_GpsFixed__WEBPACK_IMPORTED_MODULE_5___default()), {
                    sx: {
                        fontSize: {
                            xs: "18px",
                            md: "24px"
                        }
                    }
                })
            })
        ]
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TrackOrderMap);


/***/ }),

/***/ 22105:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(580);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _api_manage_hooks_react_query_order_useGetTrackOrderData__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(24073);
/* harmony import */ var _styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(45269);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _my_orders_myorders_style__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(30700);
/* harmony import */ var _date_CustomFormatedDateTime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(17446);
/* harmony import */ var _date_CustomFormatedTime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(90751);
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(57987);
/* harmony import */ var _DeliverymanInfo__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(62935);
/* harmony import */ var _DeliverymanShimmer__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(93931);
/* harmony import */ var _Map_location_view_MapComponent__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(33244);
/* harmony import */ var simplebar_react__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(94172);
/* harmony import */ var simplebar_react__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(simplebar_react__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var simplebar_react_dist_simplebar_min_css__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(48710);
/* harmony import */ var simplebar_react_dist_simplebar_min_css__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(simplebar_react_dist_simplebar_min_css__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var _trackOrder_style__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(93666);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(72805);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(_emotion_react__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var i18next__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(22021);
/* harmony import */ var _my_orders_assets_order_confirmed_png__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(93190);
/* harmony import */ var _my_orders_assets_shhiped_png__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(50862);
/* harmony import */ var _my_orders_assets_out_for_delivery_png__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(96701);
/* harmony import */ var _my_orders_assets_delivery_png__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(76066);
/* harmony import */ var _checkout_CheckOut_style__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(66366);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(47915);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_24__);
/* harmony import */ var _CustomImageContainer__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(58861);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(97986);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_26___default = /*#__PURE__*/__webpack_require__.n(_mui_system__WEBPACK_IMPORTED_MODULE_26__);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(32245);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_27___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_27__);
/* harmony import */ var _mui_icons_material_GpsFixed__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(15594);
/* harmony import */ var _mui_icons_material_GpsFixed__WEBPACK_IMPORTED_MODULE_28___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material_GpsFixed__WEBPACK_IMPORTED_MODULE_28__);
/* harmony import */ var react_geolocated__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(11022);
/* harmony import */ var react_geolocated__WEBPACK_IMPORTED_MODULE_29___default = /*#__PURE__*/__webpack_require__.n(react_geolocated__WEBPACK_IMPORTED_MODULE_29__);
/* harmony import */ var components_track_order_TrackOrderMap__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(66696);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_api_manage_hooks_react_query_order_useGetTrackOrderData__WEBPACK_IMPORTED_MODULE_4__, react_i18next__WEBPACK_IMPORTED_MODULE_10__, _DeliverymanInfo__WEBPACK_IMPORTED_MODULE_11__, i18next__WEBPACK_IMPORTED_MODULE_18__]);
([_api_manage_hooks_react_query_order_useGetTrackOrderData__WEBPACK_IMPORTED_MODULE_4__, react_i18next__WEBPACK_IMPORTED_MODULE_10__, _DeliverymanInfo__WEBPACK_IMPORTED_MODULE_11__, i18next__WEBPACK_IMPORTED_MODULE_18__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);































const CustomStepperLabels = (0,_mui_material__WEBPACK_IMPORTED_MODULE_6__.styled)(_mui_material__WEBPACK_IMPORTED_MODULE_6__.Stepper)(({ theme  })=>({
        "& .MuiStepLabel-label.MuiStepLabel-alternativeLabel": {
            marginTop: "-80px"
        },
        "& .MuiStepLabel-label.Mui-completed": {
            color: theme.palette.primary.main
        }
    }));
const QontoConnector = (0,_mui_material__WEBPACK_IMPORTED_MODULE_6__.styled)(_mui_material__WEBPACK_IMPORTED_MODULE_6__.StepConnector)(({ theme , isMobile  })=>({
        [`&.${_mui_material__WEBPACK_IMPORTED_MODULE_6__.stepConnectorClasses.alternativeLabel}`]: {
            top: 10,
            left: "calc(-50% + 16px)",
            right: "calc(50% + 16px)"
        },
        [`&.${_mui_material__WEBPACK_IMPORTED_MODULE_6__.stepConnectorClasses.active}`]: {
            [`& .${_mui_material__WEBPACK_IMPORTED_MODULE_6__.stepConnectorClasses.line}`]: {
                borderColor: theme.palette.primary.main
            }
        },
        [`&.${_mui_material__WEBPACK_IMPORTED_MODULE_6__.stepConnectorClasses.completed}`]: {
            [`& .${_mui_material__WEBPACK_IMPORTED_MODULE_6__.stepConnectorClasses.line}`]: {
                borderColor: theme.palette.primary.main
            }
        },
        [`& .${_mui_material__WEBPACK_IMPORTED_MODULE_6__.stepConnectorClasses.line}`]: {
            borderColor: theme.palette.neutral[400],
            borderTopWidth: 2,
            borderRadius: 1,
            borderLeftWidth: isMobile === "true" && 3,
            marginTop: isMobile === "true" && "-41px",
            marginBottom: isMobile === "true" && "-41px",
            minHeight: isMobile === "true" && "100px"
        }
    }));
const QontoStepIconRoot = (0,_mui_material__WEBPACK_IMPORTED_MODULE_6__.styled)("div")(({ theme , ownerState  })=>({
        color: theme.palette.primary.main,
        display: "flex",
        height: 22,
        alignItems: "center",
        ...ownerState.active && {
            color: theme.palette.primary.main
        },
        "& .QontoStepIcon-completedIcon": {
            color: theme.palette.neutral[100],
            zIndex: 1,
            fontSize: 0,
            padding: "7px"
        }
    }));
function QontoStepIcon(props) {
    const { active , completed , className  } = props;
    const theme = (0,_emotion_react__WEBPACK_IMPORTED_MODULE_17__.useTheme)();
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(QontoStepIconRoot, {
        ownerState: {
            active
        },
        className: className,
        children: completed ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_checkout_CheckOut_style__WEBPACK_IMPORTED_MODULE_23__/* .StepperCustomBorder */ .q3, {
            background: theme.palette.primary.main,
            padding: "5px",
            border: `3px solid ${theme.palette.neutral[100]}`,
            boxshadow: `0px 4px 10px ${(0,_mui_material__WEBPACK_IMPORTED_MODULE_6__.alpha)(theme.palette.neutral[400], 0.3)}`,
            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_icons_material__WEBPACK_IMPORTED_MODULE_24__.Check, {
                className: "QontoStepIcon-completedIcon"
            })
        }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_checkout_CheckOut_style__WEBPACK_IMPORTED_MODULE_23__/* .StepperCustomBorder */ .q3, {
            background: theme.palette.neutral[400],
            padding: "10px",
            border: `3px solid ${theme.palette.neutral[100]}`,
            boxshadow: `0px 4px 10px ${(0,_mui_material__WEBPACK_IMPORTED_MODULE_6__.alpha)(theme.palette.neutral[400], 0.3)}`,
            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "QontoStepIcon-circle"
            })
        })
    });
}
const TrackOrder = ({ configData , trackOrderData  })=>{
    const [userLocation, setUserLocation] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)({});
    const { t  } = (0,react_i18next__WEBPACK_IMPORTED_MODULE_10__.useTranslation)();
    const [actStep, setActStep] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(1);
    const theme = (0,_emotion_react__WEBPACK_IMPORTED_MODULE_17__.useTheme)();
    const isSmall = (0,_mui_material__WEBPACK_IMPORTED_MODULE_6__.useMediaQuery)(theme.breakpoints.down("md"));
    let currentLatLng = undefined;
    if (false) {}
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        setUserLocation({
            lat: trackOrderData?.delivery_address?.latitude,
            lng: trackOrderData?.delivery_address?.longitude
        });
    }, []);
    const steps = [
        {
            label: "Order Confirmed",
            time: trackOrderData?.confirmed,
            img: _my_orders_assets_order_confirmed_png__WEBPACK_IMPORTED_MODULE_19__/* ["default"].src */ .Z.src
        },
        {
            label: `Preparing ${trackOrderData?.module?.module_type === "food" ? "foods" : "items"}`,
            time: trackOrderData?.processing,
            img: _my_orders_assets_shhiped_png__WEBPACK_IMPORTED_MODULE_20__/* ["default"].src */ .Z.src
        },
        {
            label: ` ${trackOrderData?.module?.module_type === "food" ? "foods" : "items"} is on the way`,
            time: trackOrderData?.picked_up,
            img: _my_orders_assets_out_for_delivery_png__WEBPACK_IMPORTED_MODULE_21__/* ["default"].src */ .Z.src
        },
        {
            label: "Delivered",
            time: trackOrderData?.delivered,
            img: _my_orders_assets_delivery_png__WEBPACK_IMPORTED_MODULE_22__/* ["default"].src */ .Z.src
        }
    ];
    const handleStepper = ()=>{
        if (trackOrderData?.order_status === "panding") {
            setActStep(1);
        } else if (trackOrderData?.order_status === "confirmed") {
            setActStep(2);
        } else if (trackOrderData?.order_status === "processing" || trackOrderData?.order_status === "handover") {
            setActStep(3);
        } else if (trackOrderData?.order_status === "picked_up") {
            setActStep(4);
        } else if (trackOrderData?.order_status === "delivered") {
            setActStep(5);
        }
    };
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        handleStepper();
    }, [
        actStep,
        trackOrderData
    ]);
    const { coords , isGeolocationAvailable , isGeolocationEnabled , getPosition  } = (0,react_geolocated__WEBPACK_IMPORTED_MODULE_29__.useGeolocated)({
        positionOptions: {
            enableHighAccuracy: false
        },
        userDecisionTimeout: 5000,
        isGeolocationEnabled: true
    });
    const getCurrentLocation = ()=>{
        setUserLocation({
            lat: coords.latitude,
            lng: coords.longitude
        });
    };
    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_5__/* .CustomStackFullWidth */ .Xw, {
        mt: {
            xs: "20px",
            md: "70px"
        },
        minHeight: "30vh",
        alignItems: isSmall ? "center" : "initial",
        spacing: 4,
        children: [
            isSmall ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_6__.Stepper, {
                activeStep: actStep,
                orientation: "vertical",
                connector: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(QontoConnector, {
                    isMobile: "true"
                }),
                children: steps.map((labels, index)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_6__.Step, {
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_6__.StepLabel, {
                            StepIconComponent: QontoStepIcon,
                            children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_26__.Stack, {
                                justifyContent: "center",
                                alignItems: "center",
                                gap: {
                                    xs: "5px",
                                    md: "10px"
                                },
                                marginBottom: "25px",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_CustomImageContainer__WEBPACK_IMPORTED_MODULE_25__/* ["default"] */ .Z, {
                                        src: labels.img,
                                        width: "29px",
                                        height: "29px",
                                        alt: labels.label
                                    }),
                                    t(labels?.label),
                                    labels?.time && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_6__.Typography, {
                                        mt: "10px",
                                        variant: "body2",
                                        textAlign: "center",
                                        children: moment__WEBPACK_IMPORTED_MODULE_27___default()(labels?.time).format("ddd, Do MMM")
                                    })
                                ]
                            })
                        })
                    }, labels.label))
            }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(CustomStepperLabels, {
                activeStep: actStep,
                alternativeLabel: true,
                connector: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(QontoConnector, {}),
                children: steps.map((labels, index)=>/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_6__.Step, {
                        children: [
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_6__.StepLabel, {
                                StepIconComponent: QontoStepIcon,
                                children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_26__.Stack, {
                                    justifyContent: "center",
                                    alignItems: "center",
                                    gap: {
                                        xs: "5px",
                                        md: "10px"
                                    },
                                    children: [
                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_CustomImageContainer__WEBPACK_IMPORTED_MODULE_25__/* ["default"] */ .Z, {
                                            src: labels.img,
                                            width: "29px",
                                            height: "29px",
                                            alt: labels.label
                                        }),
                                        t(labels?.label)
                                    ]
                                })
                            }),
                            labels?.time && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_6__.Typography, {
                                mt: "10px",
                                variant: "body2",
                                textAlign: "center",
                                children: moment__WEBPACK_IMPORTED_MODULE_27___default()(labels?.time).format("ddd, Do MMM")
                            })
                        ]
                    }, labels))
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_track_order_TrackOrderMap__WEBPACK_IMPORTED_MODULE_30__/* ["default"] */ .Z, {
                getCurrentLocation: getCurrentLocation,
                trackOrderData: trackOrderData,
                userLocation: userLocation
            })
        ]
    });
};
TrackOrder.propTypes = {};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TrackOrder);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;