"use strict";
exports.id = 8518;
exports.ids = [8518];
exports.modules = {

/***/ 59599:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_1__);
// utils/useScrollToTop.js


const useScrollToTop = ()=>{
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_1__.useRouter)();
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(()=>{
        const handleRouteChange = ()=>{
            window.scrollTo({
                top: 0,
                behavior: "smooth"
            });
        };
        router.events.on("routeChangeComplete", handleRouteChange);
        // Cleanup the event listener on unmount
        return ()=>{
            router.events.off("routeChangeComplete", handleRouteChange);
        };
    }, [
        router
    ]);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useScrollToTop);


/***/ }),

/***/ 16428:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ useGetZoneList)
/* harmony export */ });
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var api_manage_MainApi__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61176);
/* harmony import */ var api_manage_ApiRoutes__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(60274);
/* harmony import */ var api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67759);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([api_manage_MainApi__WEBPACK_IMPORTED_MODULE_1__, api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_2__]);
([api_manage_MainApi__WEBPACK_IMPORTED_MODULE_1__, api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);




const getZoneList = async ()=>{
    const { data  } = await api_manage_MainApi__WEBPACK_IMPORTED_MODULE_1__/* ["default"].get */ .Z.get(`${api_manage_ApiRoutes__WEBPACK_IMPORTED_MODULE_3__/* .zone_list */ .bS}`);
    return data;
};
function useGetZoneList() {
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQuery)([
        "zone-list-data"
    ], ()=>getZoneList(), {
        enabled: false,
        onError: api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_2__/* .onSingleErrorResponse */ .f$
    });
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;