import React from "react";
import { useTheme } from "@mui/material/styles";
import { Box } from "@mui/system";

const FiveHundred = (props) => {
  const theme = useTheme();
  return (
    <>
      <Box {...props}>
        <div>
          <svg
            width="428"
            viewBox="0 0 428 361"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
          >
            <g clipPath="url(#clip0_166_56397)">
              <path
                d="M468.128 314.122H-31.8718V314.372H468.128V314.122Z"
                fill="#EBEBEB"
              />
              <path
                d="M418.029 330.218H396.35V330.468H418.029V330.218Z"
                fill="#EBEBEB"
              />
              <path
                d="M312.795 325.029H278.686V325.279H312.795V325.029Z"
                fill="#EBEBEB"
              />
              <path
                d="M409.239 320.932H364.714V321.182H409.239V320.932Z"
                fill="#EBEBEB"
              />
              <path
                d="M141.142 325.974H130.005V326.224H141.142V325.974Z"
                fill="#EBEBEB"
              />
              <path
                d="M121.102 325.974H82.7129V326.224H121.102V325.974Z"
                fill="#EBEBEB"
              />
              <path
                d="M62.1302 321.751H34.4348V322.001H62.1302V321.751Z"
                fill="#EBEBEB"
              />
              <path
                d="M205.142 269.524H12.0432C10.5299 269.522 9.079 268.92 8.00891 267.85C6.93882 266.78 6.3369 265.329 6.33521 263.816V-7.61637C6.337 -9.12964 6.93897 -10.5804 8.00905 -11.6504C9.07913 -12.7204 10.5299 -13.3223 12.0432 -13.324H205.142C206.655 -13.3221 208.106 -12.7201 209.176 -11.6501C210.245 -10.5802 210.847 -9.12949 210.849 -7.61637V263.815C210.847 265.329 210.246 266.779 209.176 267.85C208.106 268.92 206.655 269.522 205.142 269.524ZM12.0432 -13.0738C10.5962 -13.0722 9.20897 -12.4968 8.18575 -11.4737C7.16253 -10.4505 6.58693 -9.06334 6.58521 -7.61637V263.815C6.58677 265.263 7.1623 266.65 8.18554 267.673C9.20877 268.696 10.5961 269.272 12.0432 269.273H205.142C206.589 269.272 207.976 268.696 208.999 267.673C210.022 266.65 210.597 265.262 210.599 263.815V-7.61637C210.597 -9.06323 210.022 -10.4504 208.999 -11.4735C207.976 -12.4967 206.589 -13.0722 205.142 -13.074L12.0432 -13.0738Z"
                fill="#EBEBEB"
              />
              <path
                d="M421.439 269.524H228.34C226.827 269.522 225.376 268.92 224.306 267.85C223.236 266.78 222.635 265.329 222.633 263.816V-7.61637C222.635 -9.12949 223.237 -10.5802 224.306 -11.6501C225.376 -12.7201 226.827 -13.3221 228.34 -13.324H421.439C422.952 -13.3223 424.403 -12.7205 425.473 -11.6504C426.543 -10.5804 427.145 -9.12966 427.147 -7.61637V263.815C427.145 265.329 426.543 266.78 425.473 267.85C424.403 268.92 422.952 269.522 421.439 269.524V269.524ZM228.34 -13.0738C226.893 -13.072 225.506 -12.4965 224.483 -11.4733C223.46 -10.4502 222.885 -9.06303 222.883 -7.61618V263.815C222.885 265.262 223.46 266.65 224.483 267.673C225.506 268.696 226.893 269.272 228.34 269.273H421.439C422.886 269.272 424.273 268.696 425.296 267.673C426.32 266.65 426.895 265.263 426.897 263.815V-7.61637C426.895 -9.0634 426.319 -10.4507 425.296 -11.4738C424.273 -12.497 422.886 -13.0724 421.439 -13.074L228.34 -13.0738Z"
                fill="#EBEBEB"
              />
              <path
                d="M184.201 132.602L184.651 119.461L176.583 116.825C176.244 112.373 175.524 107.958 174.432 103.629L181.27 98.5865L176.625 86.2437L168.167 86.9251C166.151 82.9461 163.796 79.1486 161.127 75.5751L165.508 68.2622L156.5 58.6516L148.938 62.5237C145.543 59.6233 141.917 57.0033 138.098 54.6894L139.323 46.2955L127.325 40.8503L121.828 47.2923C117.581 45.9196 113.227 44.8997 108.812 44.2429L106.767 36.0149L93.5918 35.5635L90.9899 43.6322C86.5397 43.9853 82.1263 44.7048 77.7945 45.7836L72.7165 38.9789L60.3742 43.5901L61.0564 52.0494C57.0834 54.0884 53.2869 56.4546 49.7064 59.1234L42.4282 54.7437L32.7823 63.7153L36.6536 71.3109C33.746 74.6933 31.1361 78.3207 28.8531 82.1525L20.4611 80.8937L14.9822 92.8895L21.4584 98.3878C20.0728 102.632 19.0524 106.987 18.4084 111.406L10.1446 113.482L9.69458 126.623L17.7968 129.262C18.1333 133.713 18.8531 138.128 19.9482 142.456L13.1108 147.498L17.7558 159.842L26.2142 159.159C28.2296 163.138 30.585 166.936 33.2542 170.509L28.8722 177.822L37.8813 187.434L45.4422 183.561C48.8319 186.469 52.4577 189.09 56.2822 191.397L55.0222 199.788L67.0201 205.234L72.552 198.792C76.7998 200.165 81.1536 201.186 85.5692 201.842L87.6128 210.07L100.788 210.522L103.391 202.453C107.841 202.1 112.254 201.38 116.586 200.302L121.629 207.105L133.971 202.494L133.324 194.038C137.292 191.99 141.088 189.624 144.674 186.962L151.953 191.344L161.598 182.37L157.728 174.774C160.636 171.391 163.245 167.764 165.528 163.932L173.92 165.192L179.399 153.195L172.922 147.697C174.311 143.454 175.331 139.099 175.971 134.68L184.201 132.602ZM95.4044 175.173C85.0927 174.823 75.1164 171.422 66.7374 165.402C58.3584 159.381 51.9532 151.011 48.3319 141.35C44.7107 131.689 44.036 121.17 46.3934 111.126C48.7507 101.081 54.0341 91.9608 61.5753 84.9191C69.1164 77.8775 78.5766 73.2305 88.7591 71.566C98.9416 69.9015 109.389 71.2943 118.78 75.5682C128.171 79.842 136.083 86.805 141.516 95.5763C146.949 104.348 149.659 114.533 149.303 124.845C148.828 138.666 142.884 151.732 132.776 161.17C122.668 170.609 109.225 175.645 95.4044 175.173V175.173Z"
                fill="#EBEBEB"
              />
              <path
                d="M409.086 89.1468L412.4 86.0522L411.075 83.4422C412.078 82.2738 412.979 81.0218 413.768 79.6998L416.665 80.1378L418.542 75.9954L416.314 74.0991C416.792 72.6374 417.144 71.137 417.365 69.6147L420.216 68.8999L420.363 64.3599L417.575 63.4599C417.454 61.9247 417.209 60.4019 416.842 58.9064L419.188 57.1583L417.59 52.9049L414.678 53.1354C413.978 51.765 413.165 50.4547 412.249 49.2179L413.756 46.713L410.654 43.3901L408.051 44.7236C406.88 43.7245 405.628 42.8238 404.309 42.0305L404.73 39.133L400.596 37.2478L398.7 39.4769C397.234 39.0053 395.731 38.6565 394.207 38.4342L393.5 35.5914L388.96 35.427L388.052 38.2231C386.518 38.3389 384.997 38.587 383.506 38.9646L381.767 36.6114L377.506 38.2005L377.744 41.1205C376.371 41.8177 375.061 42.6309 373.826 43.5513L371.305 42.0425L367.991 45.137L369.323 47.7561C368.32 48.9238 367.419 50.1757 366.63 51.4981L363.733 51.0604L361.856 55.2031L364.085 57.0991C363.606 58.5608 363.255 60.0612 363.034 61.5835L360.182 62.2981L360.035 66.8389L362.824 67.7381C362.941 69.2737 363.186 70.797 363.556 72.292L361.203 74.031L362.801 78.2843L365.72 78.0626C366.421 79.4331 367.234 80.7434 368.151 81.9803L366.643 84.485L369.745 87.8079L372.348 86.475C373.519 87.474 374.77 88.3747 376.09 89.1678L375.66 92.0566L379.794 93.9418L381.698 91.7218C383.165 92.1902 384.668 92.5388 386.191 92.7641L386.898 95.6075L391.438 95.7713L392.346 92.9754C393.88 92.8596 395.401 92.6115 396.892 92.2339L398.631 94.5875L402.893 92.998L402.654 90.078C404.027 89.3822 405.338 88.5692 406.572 87.648L409.086 89.1468ZM385.469 70.0158C384.595 69.0804 384.018 67.9069 383.811 66.6436C383.604 65.3803 383.777 64.084 384.307 62.9187C384.837 61.7533 385.7 60.7714 386.788 60.0969C387.876 59.4225 389.14 59.0859 390.419 59.1297C391.699 59.1735 392.936 59.5958 393.976 60.3431C395.015 61.0904 395.81 62.1292 396.258 63.328C396.707 64.5269 396.791 65.8319 396.498 67.0781C396.205 68.3243 395.549 69.4556 394.613 70.329C393.359 71.4999 391.691 72.1247 389.976 72.066C388.262 72.0072 386.64 71.2698 385.469 70.0158V70.0158Z"
                fill="#EBEBEB"
              />
              <path
                d="M288.117 224.06L277.776 216.918C277.773 216.911 277.773 216.901 277.77 216.894C276.753 213.171 275.36 209.562 273.611 206.122L276.261 195.724L261.261 179.66L250.702 181.593C247.392 179.615 243.889 177.979 240.248 176.71C240.239 176.708 240.23 176.706 240.222 176.702L233.802 165.892L211.838 165.14L204.696 175.481L204.656 175.491C200.938 176.507 197.332 177.899 193.896 179.645L183.503 176.996L167.439 191.996L169.368 202.533L169.362 202.542C167.374 205.861 165.737 209.378 164.477 213.036L153.669 219.454L152.917 241.419L163.267 248.567C164.265 252.309 165.655 255.935 167.414 259.385L167.416 259.389L164.774 269.755L179.774 285.818L190.268 283.898C193.608 285.882 197.141 287.522 200.813 288.791L200.823 288.793L207.232 299.588L229.196 300.34L236.333 290.006C240.082 288.992 243.718 287.599 247.184 285.848L247.187 285.846L257.533 288.482L273.597 273.484L271.667 262.944C273.656 259.624 275.293 256.107 276.552 252.448L276.553 252.446L287.365 246.026L288.117 224.06ZM219.665 257.45C214.78 257.283 210.054 255.67 206.085 252.817C202.116 249.964 199.083 245.998 197.368 241.421C195.653 236.843 195.334 231.86 196.451 227.101C197.569 222.343 200.072 218.022 203.645 214.686C207.217 211.35 211.699 209.149 216.523 208.36C221.347 207.571 226.296 208.23 230.746 210.254C235.195 212.279 238.944 215.577 241.519 219.731C244.094 223.886 245.379 228.711 245.211 233.597C244.984 240.146 242.166 246.338 237.376 250.811C232.586 255.284 226.215 257.672 219.665 257.45V257.45Z"
                fill="#EBEBEB"
              />
              <path
                d="M311.677 161.678C311.653 161.678 311.629 161.678 311.604 161.677L294.287 161.084C293.934 161.072 293.589 160.971 293.284 160.791C292.979 160.61 292.725 160.356 292.544 160.052L287.882 152.199C285.363 151.281 282.927 150.151 280.599 148.821L273.092 150.194C272.744 150.259 272.385 150.235 272.049 150.124C271.712 150.013 271.41 149.818 271.169 149.559L259.343 136.896C259.102 136.637 258.929 136.321 258.841 135.978C258.753 135.635 258.753 135.276 258.84 134.933L260.728 127.523C259.56 125.121 258.603 122.621 257.869 120.053L250.338 114.852C250.047 114.65 249.811 114.379 249.651 114.063C249.492 113.747 249.415 113.395 249.428 113.041L250.021 95.7241C250.033 95.3703 250.134 95.0252 250.314 94.7206C250.495 94.416 250.749 94.1616 251.053 93.9809L258.919 89.31C259.831 86.8013 260.959 84.3763 262.289 82.062L260.909 74.5288C260.846 74.1807 260.871 73.8221 260.982 73.4861C261.093 73.1502 261.287 72.8475 261.545 72.6059L274.21 60.7788C274.469 60.5371 274.784 60.3644 275.127 60.2765C275.47 60.1886 275.83 60.1883 276.173 60.2758L283.608 62.1713C286.005 61.0043 288.497 60.0438 291.057 59.3002L296.254 51.7749C296.45 51.479 296.721 51.2394 297.038 51.0799C297.355 50.9203 297.709 50.8462 298.064 50.8649L315.381 51.4587C315.734 51.4707 316.079 51.5715 316.384 51.7519C316.689 51.9323 316.943 52.1864 317.124 52.4909L321.796 60.3571C324.296 61.2745 326.714 62.4026 329.023 63.7292L336.576 62.3454C336.925 62.2818 337.283 62.3066 337.619 62.4177C337.955 62.5288 338.258 62.7225 338.5 62.9811L350.326 75.6471C350.567 75.906 350.74 76.2214 350.828 76.5644C350.916 76.9073 350.916 77.2669 350.829 77.61L348.933 85.0475C350.1 87.4435 351.061 89.9346 351.805 92.4938L359.33 97.6901C359.621 97.8912 359.857 98.1624 360.016 98.4787C360.176 98.795 360.253 99.1462 360.24 99.5001L359.647 116.818C359.635 117.172 359.534 117.517 359.354 117.822C359.173 118.127 358.919 118.381 358.615 118.562L350.746 123.234C349.835 125.741 348.708 128.165 347.38 130.478L348.758 138.014C348.822 138.362 348.797 138.72 348.686 139.056C348.575 139.392 348.381 139.695 348.122 139.937L335.458 151.761C335.2 152.003 334.885 152.176 334.542 152.264C334.199 152.352 333.839 152.352 333.496 152.264L326.094 150.378C323.684 151.545 321.179 152.505 318.606 153.248L313.414 160.767C313.22 161.048 312.96 161.277 312.658 161.436C312.355 161.595 312.018 161.678 311.677 161.678V161.678ZM295.586 156.902L310.595 157.417L315.566 150.219C315.85 149.807 316.272 149.51 316.755 149.38C319.572 148.617 322.304 147.569 324.909 146.254L324.923 146.247C325.375 146.022 325.893 145.968 326.382 146.094L333.42 147.887L344.396 137.638L343.083 130.464C342.991 129.958 343.086 129.435 343.351 128.994C344.834 126.515 346.058 123.89 347.001 121.16C347.161 120.667 347.496 120.25 347.942 119.987L355.465 115.519L355.979 100.509L348.776 95.5347C348.4 95.2748 348.118 94.8995 347.973 94.4654C347.955 94.4117 347.938 94.3541 347.924 94.2964C347.161 91.5131 346.118 88.8144 344.81 86.2418C344.578 85.7853 344.52 85.2603 344.646 84.7642L346.451 77.6861L336.201 66.7076L329.012 68.024C328.509 68.1163 327.989 68.0226 327.55 67.7603C325.065 66.2758 322.436 65.0475 319.704 64.0943C319.55 64.0416 319.402 63.9729 319.263 63.8892C318.971 63.7099 318.728 63.4626 318.554 63.1685L314.081 55.6392L299.072 55.1246L294.098 62.3287C293.802 62.7563 293.36 63.0598 292.854 63.1812C290.072 63.9443 287.373 64.987 284.801 66.2935C284.344 66.5252 283.819 66.5831 283.324 66.4566L276.248 64.6529L265.271 74.9039L266.584 82.0767C266.667 82.5268 266.601 82.9916 266.396 83.4009C266.367 83.4586 266.335 83.5153 266.301 83.5709C264.815 86.0575 263.59 88.6913 262.646 91.4302C262.483 91.9006 262.158 92.298 261.73 92.5523L254.202 97.0237L253.688 112.033L260.898 117.012C261.309 117.296 261.606 117.716 261.737 118.198C262.487 121.005 263.53 123.726 264.847 126.316C264.921 126.46 264.979 126.612 265.018 126.77C265.103 127.109 265.102 127.464 265.016 127.803L263.218 134.857L273.468 145.832L280.606 144.527C281.106 144.436 281.622 144.528 282.06 144.787C284.559 146.27 287.202 147.498 289.948 148.452C290.44 148.608 290.858 148.94 291.122 149.385L295.586 156.902ZM304.856 137.938C304.486 137.938 304.117 137.931 303.745 137.918C295.426 137.621 287.561 134.051 281.862 127.984C276.162 121.917 273.089 113.845 273.312 105.524C273.536 97.2025 277.036 89.3062 283.053 83.5534C289.069 77.8006 297.114 74.6571 305.437 74.8069C313.76 74.9568 321.687 78.3879 327.493 84.3535C333.298 90.3192 336.512 98.3364 336.436 106.66C336.359 114.984 332.998 122.941 327.083 128.799C321.169 134.656 313.18 137.941 304.856 137.938ZM304.818 78.8437C297.579 78.8427 290.633 81.7012 285.492 86.7968C280.351 91.8925 277.43 98.8128 277.366 106.051C277.303 113.29 280.101 120.26 285.152 125.446C290.203 130.631 297.098 133.611 304.335 133.738C311.573 133.864 318.568 131.126 323.796 126.121C329.025 121.115 332.065 114.246 332.254 107.01C332.443 99.7734 329.766 92.7553 324.806 87.4833C319.845 82.2112 313.003 79.112 305.769 78.8603C305.451 78.8497 305.134 78.8437 304.818 78.8437Z"
                fill="#EBEBEB"
              />
              <path
                d="M351.567 37.0469L344.394 35.1199L342.467 27.9469L345.276 25.1389L348.239 31.2749L354.376 34.2379L351.567 37.0469Z"
                fill="#E0E0E0"
              />
              <path
                d="M352.013 32.2452C352.327 31.935 352.576 31.5658 352.747 31.1589C352.917 30.752 353.006 30.3154 353.007 29.8741C353.008 29.4329 352.922 28.9958 352.754 28.5879C352.586 28.18 352.339 27.8094 352.027 27.4974C351.715 27.1854 351.344 26.9381 350.936 26.7699C350.528 26.6016 350.091 26.5156 349.65 26.5169C349.209 26.5182 348.772 26.6067 348.365 26.7773C347.958 26.948 347.589 27.1973 347.279 27.5112L350.846 22.158L355.632 24.5772L356.681 29.6058L352.013 32.2452Z"
                fill="#E0E0E0"
              />
              <path
                d="M344.71 25.7046L349.967 20.4478L357.14 22.374L359.067 29.5475L353.81 34.8044L346.636 32.8777L344.71 25.7046ZM354.255 30.0025C354.724 29.5353 355.044 28.9395 355.175 28.2904C355.306 27.6413 355.241 26.9681 354.989 26.3559C354.736 25.7438 354.309 25.22 353.759 24.8511C353.209 24.4821 352.562 24.2844 351.9 24.283C351.238 24.2816 350.591 24.4766 350.039 24.8432C349.488 25.2099 349.058 25.7318 348.803 26.3429C348.549 26.954 348.481 27.6269 348.609 28.2766C348.736 28.9262 349.054 29.5233 349.521 29.9925C350.149 30.6186 350.999 30.971 351.886 30.9728C352.773 30.9747 353.625 30.6259 354.255 30.0025V30.0025Z"
                fill="#F0F0F0"
              />
              <path
                d="M58.3491 228.432L62.199 227.398L63.2321 223.549L61.725 222.042L60.1351 225.334L56.842 226.925L58.3491 228.432Z"
                fill="#E0E0E0"
              />
              <path
                d="M58.1101 225.855C57.9387 225.689 57.802 225.491 57.7081 225.272C57.6141 225.053 57.5647 224.817 57.5627 224.579C57.5607 224.34 57.6062 224.104 57.6965 223.883C57.7868 223.663 57.9202 223.462 58.0888 223.294C58.2573 223.125 58.4578 222.992 58.6784 222.902C58.8991 222.811 59.1355 222.766 59.3739 222.768C59.6123 222.77 59.8479 222.819 60.067 222.913C60.2861 223.007 60.4843 223.144 60.6501 223.315L58.7356 220.442L56.1683 221.74L55.6055 224.439L58.1101 225.855Z"
                fill="#E0E0E0"
              />
              <path
                d="M62.0289 222.345L59.2083 219.524L55.3591 220.558L54.3252 224.408L57.1461 227.229L60.9961 226.195L62.0289 222.345ZM56.9067 224.652C56.6549 224.401 56.4831 224.081 56.4131 223.733C56.343 223.385 56.3778 223.023 56.5131 222.695C56.6483 222.366 56.878 222.085 57.173 221.887C57.468 221.689 57.8151 221.583 58.1704 221.582C58.5257 221.582 58.8732 221.686 59.1691 221.883C59.4649 222.08 59.6957 222.36 59.8323 222.688C59.9689 223.016 60.0052 223.377 59.9366 223.726C59.8679 224.074 59.6974 224.395 59.4467 224.646C59.1097 224.982 58.6535 225.171 58.1778 225.172C57.702 225.173 57.2451 224.986 56.9067 224.652Z"
                fill="#F0F0F0"
              />
              <path
                d="M44.4906 17.3861L47.6854 20.581C48.0874 20.9807 48.6311 21.205 49.1979 21.205C49.7647 21.205 50.3085 20.9807 50.7104 20.581V20.581C51.11 20.1791 51.3343 19.6354 51.3343 19.0686C51.3343 18.5018 51.11 17.9581 50.7104 17.5561L47.5155 14.3612C47.1136 13.9616 46.5699 13.7373 46.0031 13.7373C45.4363 13.7373 44.8926 13.9616 44.4906 14.3612V14.3612C44.091 14.7632 43.8667 15.3069 43.8667 15.8737C43.8667 16.4405 44.091 16.9842 44.4906 17.3861V17.3861Z"
                fill="#F0F0F0"
              />
              <path
                d="M42.2401 9.42891C43.075 9.18737 43.9623 9.19532 44.7928 9.45179C45.6232 9.70826 46.3605 10.202 46.9138 10.8723C47.4671 11.5426 47.8123 12.3601 47.9068 13.2241C48.0013 14.0881 47.8411 14.9608 47.4457 15.7349C47.0504 16.5089 46.4373 17.1504 45.682 17.5804C44.9266 18.0103 44.062 18.2099 43.1946 18.1546C42.3272 18.0993 41.4949 17.7914 40.8003 17.269C40.1057 16.7466 39.579 16.0324 39.2853 15.2144C38.9112 14.0553 39.0122 12.7952 39.5662 11.7106C40.1201 10.6259 41.0818 9.80534 42.2401 9.42891V9.42891Z"
                fill="#E0E0E0"
              />
              <path
                d="M38.7579 14.6761L39.2209 15.9653L48.728 12.5505L48.2649 11.2613L38.7579 14.6761Z"
                fill="#F0F0F0"
              />
              <path
                d="M218.128 359.285C325.211 359.285 412.018 354.215 412.018 347.962C412.018 341.708 325.211 336.638 218.128 336.638C111.046 336.638 24.2393 341.708 24.2393 347.962C24.2393 354.215 111.046 359.285 218.128 359.285Z"
                fill="#F5F5F5"
              />
              <path
                d="M54.8436 52.37C53.8426 47.9667 54.2899 44.259 56.1854 41.2469C58.0809 38.2362 61.2186 36.2329 65.5985 35.2369C70.0882 34.2165 73.8215 34.6354 76.7985 36.4937C79.7755 38.3521 81.7576 41.4523 82.7448 45.7945C83.4556 48.4472 83.5145 51.2323 82.9166 53.9126C82.3349 56.1382 81.1068 58.1415 79.3873 59.6695C77.345 61.3903 74.8944 62.5569 72.2711 63.0572C69.6966 63.7377 67.0017 63.8282 64.3873 63.3218C62.1161 62.7729 60.0624 61.5538 58.4928 59.8228C56.6284 57.7119 55.3677 55.1373 54.8436 52.37V52.37ZM63.1878 50.5126C63.807 53.2362 64.7579 55.0777 66.0404 56.037C66.7017 56.4763 67.445 56.7774 68.2255 56.9223C69.0061 57.0672 69.8079 57.053 70.5828 56.8805C71.3578 56.7079 72.0898 56.3806 72.7352 55.9181C73.3805 55.4557 73.9257 54.8677 74.3382 54.1893C75.0545 52.8007 75.0696 50.5975 74.3836 47.5799C73.8065 45.0409 72.8726 43.3017 71.5819 42.3622C70.9289 41.8959 70.18 41.5813 69.3899 41.4414C68.5998 41.3015 67.7884 41.3398 67.015 41.5536C66.2427 41.6994 65.5136 42.0186 64.8826 42.4872C64.2516 42.9558 63.7352 43.5615 63.3724 44.2586C62.6243 45.6806 62.5629 47.7652 63.188 50.5126H63.1878Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M86.721 49.071C86.3669 47.7092 86.3035 46.2882 86.5349 44.9003C86.7662 43.5124 87.2872 42.1887 88.0638 41.0154C88.9382 39.769 90.0502 38.7076 91.3361 37.8923C92.6219 37.0769 94.0562 36.5237 95.5565 36.2644C99.4698 35.3748 102.684 35.8374 105.199 37.6521C107.312 39.2945 108.748 41.6558 109.234 44.2872C109.72 46.9187 109.222 49.637 107.835 51.9255C106.278 54.2988 103.739 55.8855 100.218 56.6855C97.5052 57.4384 94.6132 57.2045 92.0565 56.0255C90.6905 55.357 89.498 54.3812 88.5723 53.1746C87.6466 51.968 87.0129 50.5635 86.721 49.071V49.071ZM94.2249 47.3464C94.4277 48.7434 95.1128 50.0255 96.1615 50.9705C96.5742 51.2868 97.0514 51.5086 97.5592 51.6205C98.067 51.7323 98.5932 51.7314 99.1006 51.6178C99.6081 51.5042 100.084 51.2807 100.496 50.963C100.908 50.6453 101.245 50.2412 101.483 49.7791C102.011 48.4398 102.061 46.9593 101.624 45.5876C101.422 44.2194 100.746 42.9654 99.7152 42.0437C99.3172 41.7226 98.851 41.4969 98.3524 41.3838C97.8537 41.2707 97.3357 41.2733 96.8382 41.3914C96.3187 41.4989 95.8307 41.7238 95.4115 42.049C94.9923 42.3741 94.6531 42.7909 94.4198 43.2673C93.8781 44.562 93.8091 46.006 94.2249 47.3464V47.3464Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M116.713 60.2899L110.58 33.3137L117.591 31.719L118.247 34.6077C118.742 33.4559 119.458 32.4124 120.355 31.5364C121.341 30.6994 122.519 30.1193 123.783 29.8479C124.953 29.5275 126.185 29.508 127.364 29.7912C128.543 30.0744 129.632 30.6512 130.528 31.4679C132.508 33.3122 133.85 35.739 134.358 38.3966C135.097 41.6476 134.882 44.3059 133.713 46.3713C133.164 47.3711 132.403 48.239 131.483 48.9143C130.564 49.5897 129.508 50.0562 128.39 50.2813C127.312 50.5405 126.194 50.584 125.1 50.4092C124.048 50.2281 123.045 49.8304 122.154 49.2413L124.275 58.5704L116.713 60.2899ZM120.322 41.4325C120.503 42.6816 121.127 43.8241 122.079 44.6525C122.461 44.9442 122.904 45.1461 123.375 45.2433C123.846 45.3405 124.333 45.3305 124.8 45.214C125.224 45.1208 125.62 44.93 125.958 44.6568C126.296 44.3835 126.565 44.0353 126.745 43.6398C127.187 42.3964 127.206 41.0415 126.798 39.7863C126.617 38.5305 126.013 37.374 125.085 36.5089C124.743 36.2221 124.34 36.0183 123.907 35.9136C123.473 35.8089 123.021 35.8061 122.587 35.9054C122.128 36.0031 121.697 36.2038 121.326 36.4924C120.956 36.781 120.657 37.15 120.45 37.5714C119.962 38.8048 119.916 40.1694 120.322 41.4325V41.4325Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M137.563 42.0222L144.838 39.6322C145.225 40.3363 145.828 40.8982 146.557 41.2357C147.311 41.495 148.127 41.5188 148.895 41.304C149.735 41.1667 150.506 40.7533 151.085 40.1292C151.253 39.9537 151.375 39.7395 151.44 39.5055C151.505 39.2716 151.511 39.0252 151.457 38.7884C151.394 38.5206 151.253 38.2775 151.052 38.0896C150.851 37.9016 150.599 37.7771 150.327 37.7318C149.2 37.5971 148.062 37.5837 146.932 37.6918C145.033 37.8407 143.124 37.8319 141.226 37.6655C140.114 37.5033 139.072 37.0254 138.223 36.2885C137.331 35.5423 136.713 34.519 136.469 33.3813C136.167 32.1813 136.297 30.9135 136.835 29.7993C137.425 28.6397 138.333 27.6719 139.452 27.0093C141.046 26.1048 142.777 25.4664 144.576 25.1193C146.298 24.656 148.077 24.4405 149.86 24.4793C150.979 24.5595 152.062 24.9111 153.014 25.5037C154.033 26.1908 154.897 27.0816 155.554 28.12L148.61 30.4344C148.35 29.9111 147.913 29.4964 147.377 29.2635C146.648 29.0008 145.858 28.9644 145.108 29.159C144.447 29.2538 143.835 29.5588 143.361 30.029C143.212 30.1918 143.104 30.3881 143.046 30.6014C142.988 30.8147 142.983 31.0387 143.03 31.2546C143.083 31.4883 143.205 31.7006 143.38 31.864C143.555 32.0274 143.776 32.1342 144.012 32.1706C145.127 32.3037 146.256 32.2813 147.364 32.1042C149.294 31.8236 151.252 31.7947 153.189 32.0183C154.406 32.1923 155.546 32.7196 156.466 33.5349C157.303 34.2891 157.885 35.2855 158.13 36.3855C158.383 37.5613 158.288 38.7852 157.857 39.9079C157.328 41.2428 156.407 42.3859 155.215 43.1863C153.461 44.3283 151.499 45.1128 149.441 45.4949C145.871 46.3064 143.213 46.375 141.466 45.7009C139.731 45.0376 138.328 43.7154 137.563 42.0222V42.0222Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M161.977 17.2898L170.185 17.2437L170.221 23.547L168.707 36.2176L163.631 36.246L162.012 23.593L161.977 17.2898ZM162.378 38.1779L170.039 38.1347L170.077 44.9087L162.416 44.9519L162.378 38.1779Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M401.309 142.268C403.019 137.701 404.155 132.94 404.689 128.093C405.102 123.4 404.792 118.671 403.771 114.072C402.529 108.69 400.197 103.62 396.919 99.1752C393.392 94.1885 387.934 89.2481 380.545 84.354C365.164 74.1706 350.928 70.8165 337.838 74.2916C324.745 77.7656 311.222 90.0772 297.268 111.226C291.981 119.094 287.511 127.48 283.928 136.255C280.709 144.338 279.071 151.305 279.015 157.156C278.764 164.967 280.609 172.702 284.358 179.559C288.081 186.312 294.561 192.748 303.799 198.865C320.278 209.774 334.976 212.781 347.894 207.884C360.811 202.987 373.93 190.445 387.252 170.257C393.054 161.531 397.774 152.133 401.309 142.268V142.268Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M316.422 193.615C314.298 192.484 312.094 191.164 309.872 189.692C302.174 184.597 296.831 179.401 293.992 174.249C291.169 169.086 289.794 163.256 290.013 157.375L290.015 157.261C290.057 152.802 291.448 147.103 294.148 140.325C297.458 132.248 301.58 124.529 306.449 117.285C321.844 93.9563 333.55 86.8099 340.659 84.9233C348.949 82.7233 357.918 84.2866 368.081 89.7011C370.164 90.8105 372.314 92.0977 374.471 93.5262C380.683 97.6375 385.213 101.675 387.937 105.526C390.341 108.752 392.065 112.431 393.007 116.343C393.792 119.844 394.039 123.445 393.74 127.021C393.291 130.957 392.358 134.823 390.962 138.53C387.717 147.575 383.388 156.193 378.07 164.197C366.109 182.323 354.644 193.561 343.994 197.597C336.093 200.593 327.074 199.291 316.422 193.616L316.422 193.615Z"
                fill="#EEF6FE"
              />
              <path
                d="M89.2292 138.229C89.1682 138.239 89.1058 138.237 89.0453 138.224C84.3222 137.229 81.3901 135.982 79.6802 134.189C78.6305 134.567 77.4865 134.596 76.419 134.271C75.171 133.895 74.0667 133.149 73.2519 132.131C72.9581 132.443 72.5904 132.677 72.1827 132.81C71.7749 132.943 71.3403 132.971 70.9188 132.892C69.6449 132.621 68.4892 131.955 67.6167 130.988C67.2274 131.383 66.7073 131.623 66.1539 131.662C63.1807 131.902 58.2513 126.711 56.9496 120.533C56.9224 120.404 56.9478 120.268 57.0204 120.157C57.0929 120.046 57.2065 119.969 57.3363 119.941C57.4661 119.914 57.6014 119.94 57.7124 120.012C57.8234 120.085 57.9011 120.198 57.9283 120.328C59.1633 126.191 63.8101 130.849 66.0733 130.665C66.2399 130.655 66.4028 130.612 66.5529 130.539C66.7029 130.466 66.8371 130.364 66.9477 130.239C65.9432 128.962 65.2026 127.497 64.7689 125.931C64.3353 124.365 64.2171 122.728 64.4214 121.115C64.7862 118.011 65.3462 116.729 66.282 116.797C68.0513 116.943 68.8825 123.436 68.678 127.843C68.6658 128.631 68.502 129.408 68.1956 130.133C68.9382 131.013 69.942 131.632 71.0609 131.902C71.3576 131.964 71.6658 131.939 71.9488 131.831C72.2318 131.723 72.4778 131.535 72.6572 131.291C71.5694 129.507 70.9837 126.929 71.4939 123.437C72.1658 118.84 72.7039 118.631 73.0259 118.506C73.1376 118.462 73.259 118.449 73.3773 118.469C73.4956 118.489 73.6063 118.541 73.6974 118.619C74.7774 119.499 74.7967 126.466 74.1962 130.011C74.1284 130.436 74.0062 130.85 73.8328 131.243C74.5333 132.229 75.5401 132.956 76.6965 133.31C77.4481 133.537 78.2471 133.558 79.0092 133.369C78.8892 133.196 78.7786 133.02 78.6758 132.839C77.5476 130.848 77.5303 128.339 78.6237 125.169C79.3494 123.067 80.0514 122.027 80.8329 121.898H80.8339C81.0423 121.87 81.2545 121.901 81.4457 121.989C81.637 122.076 81.7994 122.216 81.9139 122.393C83.0339 123.841 83.2665 129.183 81.99 132.061C81.6945 132.725 81.2196 133.293 80.6188 133.702C82.2251 135.224 84.986 136.347 89.2516 137.246C89.3656 137.271 89.4675 137.334 89.5398 137.425C89.6121 137.517 89.6502 137.63 89.6475 137.747C89.6449 137.863 89.6016 137.975 89.5252 138.063C89.4488 138.151 89.3441 138.21 89.2291 138.229L89.2292 138.229ZM80.9946 122.886C80.9916 122.886 80.4371 122.981 79.5694 125.496C78.5747 128.378 78.567 130.619 79.5457 132.346C79.6665 132.559 79.8016 132.764 79.95 132.959C80.4465 132.646 80.8385 132.192 81.076 131.656C82.1127 129.317 82.066 124.869 81.275 123.257C81.1132 122.928 80.9956 122.886 80.9946 122.886ZM73.237 119.884C72.8832 121.094 72.6312 122.331 72.4835 123.583C72.0603 125.777 72.2953 128.047 73.1589 130.107C73.1782 130.019 73.1955 129.931 73.2101 129.844C73.7222 126.545 73.7313 123.186 73.237 119.884V119.884ZM66.2295 117.836C66.0882 118.016 65.7095 118.716 65.4141 121.232C65.0523 124.069 65.784 126.937 67.4606 129.254C67.5895 128.778 67.6627 128.289 67.6789 127.797C67.9116 122.784 66.8972 118.447 66.2295 117.836V117.836Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M135.197 183.834C133.622 184.107 132.002 183.956 130.504 183.396C130.443 183.372 130.387 183.337 130.339 183.291C130.291 183.246 130.253 183.192 130.227 183.132C130.2 183.072 130.185 183.007 130.184 182.941C130.182 182.876 130.193 182.81 130.217 182.749C130.241 182.688 130.276 182.632 130.322 182.584C130.367 182.537 130.421 182.498 130.481 182.472C130.541 182.445 130.606 182.431 130.672 182.429C130.737 182.427 130.803 182.439 130.864 182.462C134.722 183.955 139.037 181.769 139.728 180.11C139.781 180.005 139.811 179.889 139.817 179.771C139.824 179.653 139.806 179.535 139.765 179.425C137.979 179.82 136.112 179.601 134.465 178.805C131.697 177.645 131.427 177.21 131.382 176.833C131.369 176.724 131.386 176.614 131.43 176.513C131.474 176.413 131.545 176.326 131.634 176.262C132.535 175.603 137.321 176.928 139.376 177.845C139.625 177.953 139.859 178.093 140.073 178.26C140.777 177.975 141.371 177.471 141.767 176.823C141.988 176.457 142.124 176.046 142.165 175.621C142.101 175.641 142.037 175.66 141.972 175.677C140.42 176.094 138.726 175.675 136.786 174.392C135.452 173.51 134.882 172.845 134.936 172.236C134.954 172.065 135.021 171.903 135.128 171.768C135.234 171.634 135.377 171.532 135.54 171.476C136.85 170.913 140.454 171.799 142.078 173.085C142.435 173.367 142.718 173.733 142.902 174.149C144.091 173.334 145.231 171.754 146.476 169.238C146.535 169.119 146.638 169.028 146.764 168.986C146.826 168.965 146.892 168.956 146.957 168.96C147.023 168.965 147.087 168.982 147.146 169.011C147.205 169.04 147.257 169.081 147.3 169.13C147.344 169.179 147.377 169.237 147.398 169.299C147.419 169.361 147.428 169.427 147.423 169.493C147.419 169.558 147.402 169.622 147.372 169.681C145.933 172.591 144.62 174.321 143.157 175.178C143.204 175.933 143.019 176.684 142.628 177.332C142.17 178.089 141.501 178.695 140.703 179.076C140.788 179.304 140.828 179.547 140.819 179.79C140.81 180.034 140.753 180.273 140.651 180.494C140.038 181.969 137.822 183.405 135.197 183.834ZM133.203 177.132C133.575 177.323 134.103 177.569 134.852 177.883C136.031 178.423 137.323 178.672 138.618 178.608C136.875 177.912 135.058 177.417 133.203 177.131V177.132ZM135.963 172.376C136.332 172.863 136.801 173.266 137.337 173.558C139.026 174.674 140.458 175.06 141.711 174.712C141.815 174.684 141.918 174.652 142.02 174.613C141.9 174.321 141.706 174.064 141.458 173.868C139.821 172.573 136.611 172.107 135.963 172.376L135.963 172.376Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M259.061 73.2084C257.855 68.4835 256.066 63.927 253.734 59.6439C251.391 55.5567 248.435 51.8533 244.968 48.6628C240.874 44.9559 236.063 42.1281 230.832 40.354C225.089 38.2771 217.786 37.3418 208.926 37.5481C190.484 37.9811 176.885 43.3638 168.129 53.696C159.37 64.0289 155.308 81.8603 155.943 107.19C156.1 116.667 157.225 126.104 159.299 135.352C161.276 143.825 163.914 150.478 167.211 155.312C171.469 161.865 177.403 167.159 184.398 170.643C191.312 174.058 200.308 175.636 211.385 175.376C231.142 174.912 244.922 168.98 252.724 157.579C260.526 146.18 264.125 128.389 263.52 104.209C263.295 93.7332 261.798 83.3233 259.061 73.2084V73.2084Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M218.743 163.855C216.354 164.14 213.791 164.316 211.127 164.379C201.897 164.596 194.544 163.386 189.269 160.78C184.002 158.156 179.543 154.158 176.362 149.207L176.298 149.112C173.784 145.429 171.669 139.958 170.011 132.852C168.112 124.333 167.083 115.642 166.94 106.915C166.241 78.9737 171.764 66.4193 176.52 60.8085C182.065 54.266 190.319 50.4232 201.754 49.0586C204.096 48.779 206.596 48.6066 209.183 48.5459C216.63 48.3702 222.655 49.095 227.091 50.6986C230.907 51.9717 234.425 54.0057 237.433 56.6775C240.078 59.1021 242.339 61.9159 244.137 65.0219C246.017 68.5082 247.461 72.2134 248.434 76.0534C250.939 85.3305 252.312 94.8768 252.522 104.484C253.065 126.194 250.078 141.967 243.645 151.366C238.874 158.34 230.728 162.425 218.744 163.855L218.743 163.855Z"
                fill="#EEF6FE"
              />
              <path
                d="M225.461 78.463L224.978 74.7038L222.561 74.3287C222.257 73.0779 221.847 71.8554 221.336 70.6746L223.047 68.9226L221.152 65.6272L218.777 66.2139C218.019 65.1755 217.173 64.2047 216.247 63.3121L217.154 61.0282L214.145 58.7127L212.174 60.1654C211.073 59.498 209.92 58.921 208.726 58.4402L208.685 55.9954L205.019 55.0037L203.754 57.0918C202.482 56.8985 201.196 56.8105 199.91 56.8289L198.946 54.5833L195.177 55.0668L194.811 57.4831C193.562 57.7901 192.34 58.1998 191.157 58.708L189.397 57.008L186.1 58.8932L186.687 61.2679C185.651 62.0326 184.681 62.8822 183.787 63.8079L181.513 62.8999L179.186 65.8999L180.64 67.8809C179.97 68.9781 179.396 70.1313 178.924 71.3274L176.478 71.3592L175.477 75.0262L177.575 76.2895C177.378 77.5613 177.29 78.8476 177.312 80.1345L175.058 81.1089L175.54 84.8681L177.967 85.2425C178.27 86.4933 178.68 87.7157 179.192 88.8961L177.481 90.6481L179.376 93.944L181.751 93.3568C182.509 94.3951 183.355 95.366 184.281 96.2586L183.374 98.5424L186.383 100.858L188.354 99.4053C189.454 100.075 190.607 100.652 191.802 101.131L191.833 103.577L195.499 104.568L196.774 102.479C198.046 102.672 199.332 102.76 200.619 102.742L201.582 104.988L205.351 104.504L205.717 102.088C206.966 101.78 208.188 101.371 209.371 100.863L211.121 102.564L214.418 100.679L213.841 98.3032C214.875 97.5363 215.845 96.6868 216.741 95.7632L219.015 96.6716L221.342 93.6708L219.889 91.6898C220.559 90.5925 221.133 89.4394 221.604 88.2433L224.05 88.2121L225.051 84.5446L222.953 83.2812C223.151 82.0096 223.239 80.7233 223.216 79.4367L225.461 78.463ZM202.178 94.6983C199.228 95.0777 196.232 94.5738 193.569 93.2504C190.906 91.9269 188.695 89.8433 187.216 87.2631C185.737 84.6829 185.056 81.722 185.26 78.755C185.464 75.7879 186.544 72.9481 188.362 70.5945C190.18 68.241 192.655 66.4796 195.475 65.5331C198.294 64.5866 201.331 64.4975 204.201 65.2771C207.071 66.0567 209.645 67.6699 211.598 69.9128C213.551 72.1557 214.795 74.9274 215.173 77.8773C215.68 81.8311 214.596 85.8244 212.159 88.9788C209.722 92.1333 206.132 94.1906 202.178 94.6983V94.6983Z"
                fill="white"
              />
              <path
                opacity="0.3"
                d="M252.254 144.588L252.114 142.023L250.498 141.653C250.354 140.796 250.139 139.952 249.856 139.13L251.094 138.027L249.994 135.704L248.356 135.985C247.9 135.245 247.381 134.546 246.803 133.897L247.519 132.402L245.613 130.689L244.204 131.565C243.498 131.06 242.751 130.615 241.97 130.237L242.075 128.572L239.654 127.716L238.685 129.078C237.84 128.877 236.98 128.751 236.113 128.701L235.57 127.132L233.004 127.26L232.633 128.876C231.776 129.025 230.933 129.244 230.111 129.53L229.008 128.28L226.686 129.391L226.967 131.03C226.23 131.49 225.532 132.01 224.879 132.583L223.382 131.855L221.669 133.761L222.546 135.17C222.044 135.878 221.6 136.625 221.217 137.404L219.565 137.309L218.709 139.73L220.058 140.689C219.863 141.539 219.737 142.403 219.682 143.273L218.111 143.804L218.252 146.368L219.869 146.751C220.008 147.605 220.222 148.446 220.51 149.263L219.26 150.366L220.371 152.688L222.011 152.418C222.469 153.153 222.988 153.848 223.563 154.495L222.836 155.992L224.743 157.716L226.162 156.826C226.867 157.332 227.615 157.776 228.396 158.155L228.291 159.819L230.712 160.676L231.682 159.325C232.527 159.517 233.387 159.639 234.252 159.691L234.795 161.26L237.361 161.132L237.732 159.516C238.589 159.366 239.432 159.148 240.254 158.862L241.357 160.112L243.667 159.002L243.398 157.362C244.135 156.901 244.833 156.382 245.486 155.809L246.971 156.538L248.696 154.63L247.808 153.224C248.314 152.515 248.762 151.768 249.148 150.988L250.799 151.083L251.656 148.662L250.307 147.703C250.497 146.857 250.619 145.998 250.673 145.133L252.254 144.588ZM239.388 145.684C239.095 146.517 238.562 147.244 237.855 147.774C237.149 148.303 236.302 148.611 235.42 148.659C234.539 148.706 233.663 148.491 232.904 148.041C232.145 147.591 231.536 146.926 231.155 146.13C230.774 145.333 230.638 144.442 230.763 143.568C230.889 142.695 231.271 141.878 231.861 141.221C232.451 140.565 233.222 140.098 234.077 139.88C234.933 139.662 235.833 139.702 236.666 139.996C237.779 140.392 238.69 141.213 239.2 142.279C239.711 143.345 239.778 144.569 239.388 145.684Z"
                fill="#AFC5F8"
              />
              <path
                d="M259.271 99.6538L255.997 98.1025L255.995 98.0957C255.532 97.084 254.968 96.122 254.311 95.2246L254.582 92.1436L249.569 88.2703L246.655 89.3103C245.621 88.9014 244.549 88.5987 243.454 88.4069L243.446 88.4057L241.118 85.6289L234.834 86.435L233.283 89.7087L233.272 89.7133C232.261 90.1751 231.3 90.7385 230.404 91.3948L227.324 91.124L223.451 96.1375L224.489 99.0457L224.488 99.0485C224.076 100.085 223.774 101.162 223.586 102.261L220.809 104.588L221.616 110.872L224.892 112.424C225.35 113.443 225.914 114.409 226.574 115.309L226.575 115.31L226.305 118.382L231.318 122.255L234.214 121.221C235.256 121.63 236.338 121.933 237.441 122.123H237.444L239.769 124.896L246.052 124.09L247.602 120.819C248.622 120.356 249.591 119.791 250.496 119.132L250.497 119.131L253.562 119.4L257.435 114.387L256.397 111.479C256.808 110.442 257.111 109.365 257.299 108.266V108.266L260.077 105.937L259.271 99.6538ZM241.349 112.332C239.951 112.511 238.532 112.272 237.271 111.645C236.009 111.018 234.962 110.03 234.261 108.808C233.561 107.585 233.239 106.182 233.335 104.777C233.432 103.371 233.944 102.026 234.805 100.911C235.666 99.7959 236.839 98.9614 238.175 98.5129C239.51 98.0644 240.949 98.022 242.309 98.3912C243.668 98.7603 244.888 99.5244 245.814 100.587C246.739 101.649 247.329 102.962 247.508 104.359C247.748 106.233 247.234 108.126 246.079 109.621C244.924 111.116 243.223 112.091 241.349 112.332V112.332Z"
                fill="white"
              />
              <path
                d="M272.597 46.2837L272.909 44.9595L272.911 44.958C273.246 44.7086 273.555 44.4256 273.833 44.1136L274.986 43.9704L276.013 41.8245L275.401 40.8364C275.47 40.4247 275.497 40.0071 275.481 39.59V39.5871L276.318 38.5134L275.527 36.2696L274.202 35.9579L274.2 35.9542C273.951 35.6194 273.668 35.3109 273.357 35.0335L273.213 33.8813L271.068 32.8541L270.081 33.4641H270.08C269.667 33.3946 269.249 33.3684 268.83 33.3858L267.757 32.5496L265.513 33.3407L265.201 34.666C264.863 34.9143 264.553 35.1975 264.274 35.511V35.511L263.125 35.6538L262.098 37.7997L262.706 38.7816C262.637 39.1966 262.612 39.6174 262.629 40.0377V40.0387L261.793 41.1107L262.584 43.3544L263.908 43.666C264.158 44.0039 264.442 44.3155 264.755 44.596V44.596L264.898 45.7428L267.043 46.7702L268.03 46.1597C268.443 46.2292 268.862 46.2554 269.28 46.2379V46.2379L270.354 47.0742L272.597 46.2837ZM266.53 40.7015C266.354 40.2024 266.33 39.6625 266.461 39.1498C266.592 38.6371 266.872 38.1748 267.266 37.8214C267.66 37.4679 268.15 37.2391 268.673 37.1639C269.197 37.0887 269.731 37.1705 270.209 37.399C270.686 37.6275 271.085 37.9923 271.354 38.4475C271.624 38.9026 271.753 39.4275 271.725 39.9559C271.696 40.4842 271.512 40.9923 271.195 41.4158C270.878 41.8393 270.442 42.1592 269.943 42.3352C269.274 42.5708 268.538 42.531 267.898 42.2246C267.258 41.9183 266.766 41.3703 266.53 40.7013V40.7015Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M244.451 44.1565L243.594 43.6434C244.891 41.3471 246.631 39.331 248.713 37.7117L249.313 38.5117C247.338 40.0564 245.686 41.9744 244.451 44.1565V44.1565Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M251.414 37.2567L250.876 36.4123C254.262 34.2332 258.143 32.9443 262.159 32.6653L262.228 33.6633C258.377 33.9253 254.656 35.1618 251.414 37.2567V37.2567Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M250.665 44.3885L249.759 43.9665C251.617 40.3706 254.711 37.5667 258.472 36.0706L258.822 37.0069C255.303 38.4051 252.407 41.0262 250.665 44.3885Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M200.682 150.062C200.616 150.073 200.548 150.07 200.483 150.054C200.418 150.038 200.357 150.01 200.303 149.97L197.886 148.175C196.82 148.248 195.749 148.224 194.687 148.103L191.694 150.052C191.624 150.098 191.544 150.126 191.46 150.133C191.376 150.139 191.293 150.124 191.216 150.09L185.228 147.39C185.151 147.355 185.085 147.302 185.034 147.235C184.984 147.168 184.951 147.09 184.939 147.007L184.418 143.481C183.622 142.764 182.894 141.975 182.243 141.124L179.299 140.502C179.217 140.485 179.141 140.447 179.077 140.393C179.014 140.339 178.965 140.269 178.935 140.191L176.609 134.048C176.58 133.969 176.57 133.884 176.582 133.801C176.594 133.718 176.626 133.639 176.676 133.572L178.471 131.155C178.399 130.088 178.422 129.016 178.54 127.953L176.593 124.964C176.547 124.893 176.52 124.813 176.513 124.729C176.507 124.646 176.522 124.562 176.556 124.485L179.255 118.496C179.286 118.418 179.339 118.349 179.406 118.298C179.474 118.247 179.554 118.216 179.638 118.207L183.161 117.687C183.88 116.892 184.67 116.165 185.521 115.514L186.143 112.568C186.161 112.486 186.198 112.41 186.253 112.346C186.307 112.283 186.377 112.234 186.455 112.204L192.598 109.878C192.677 109.849 192.761 109.839 192.844 109.851C192.927 109.862 193.006 109.894 193.074 109.944L195.488 111.737C196.557 111.664 197.63 111.688 198.694 111.806L201.683 109.861C201.753 109.815 201.834 109.788 201.917 109.782C202.001 109.775 202.085 109.79 202.161 109.824L208.149 112.523C208.226 112.558 208.292 112.611 208.343 112.678C208.393 112.745 208.426 112.824 208.438 112.907L208.96 116.434C209.755 117.15 210.482 117.939 211.132 118.79L214.078 119.412C214.16 119.429 214.236 119.467 214.3 119.521C214.363 119.576 214.412 119.645 214.442 119.724L216.768 125.867C216.797 125.945 216.807 126.03 216.795 126.113C216.784 126.196 216.751 126.275 216.701 126.342L214.905 128.76C214.977 129.826 214.953 130.895 214.835 131.957L216.784 134.95C216.83 135.021 216.857 135.101 216.864 135.185C216.87 135.269 216.856 135.353 216.821 135.429L214.122 141.417C214.086 141.492 214.033 141.558 213.966 141.608C213.899 141.659 213.822 141.692 213.739 141.706L210.214 142.227C209.496 143.02 208.707 143.745 207.857 144.394L207.234 147.346C207.217 147.428 207.179 147.504 207.125 147.568C207.07 147.632 207 147.681 206.922 147.71L200.779 150.037C200.748 150.048 200.715 150.057 200.682 150.062V150.062ZM194.486 147.092C194.533 147.084 194.581 147.084 194.628 147.09C195.745 147.228 196.873 147.253 197.995 147.164C198.116 147.154 198.236 147.189 198.333 147.262L200.68 149.005L206.312 146.872L206.917 144.004C206.942 143.886 207.01 143.78 207.107 143.707C208.009 143.033 208.84 142.27 209.587 141.427C209.624 141.381 209.669 141.342 209.721 141.314C209.773 141.286 209.83 141.269 209.888 141.264L213.322 140.757L215.796 135.267L213.897 132.351C213.833 132.252 213.806 132.134 213.821 132.017C213.957 130.9 213.982 129.773 213.895 128.651C213.885 128.53 213.919 128.41 213.991 128.313L215.735 125.965L213.603 120.333L210.741 119.729C210.62 119.704 210.512 119.634 210.439 119.533C209.767 118.633 209.004 117.805 208.161 117.062C208.072 116.984 208.013 116.877 207.996 116.76L207.489 113.323L201.999 110.848L199.09 112.742C198.991 112.805 198.874 112.833 198.757 112.82C197.636 112.684 196.504 112.659 195.378 112.747C195.258 112.757 195.138 112.723 195.041 112.651L192.697 110.91L187.065 113.042L186.461 115.904C186.436 116.022 186.368 116.128 186.271 116.201C185.368 116.876 184.537 117.641 183.79 118.485C183.714 118.577 183.606 118.636 183.488 118.65L180.054 119.156L177.58 124.647L179.477 127.558C179.517 127.62 179.543 127.69 179.553 127.763C179.563 127.836 179.557 127.91 179.535 127.98C179.414 129.071 179.396 130.171 179.481 131.265C179.491 131.386 179.457 131.506 179.384 131.603L177.642 133.949L179.773 139.581L182.633 140.184C182.761 140.211 182.872 140.286 182.945 140.394C183.615 141.289 184.375 142.112 185.214 142.851C185.304 142.93 185.363 143.038 185.381 143.156L185.888 146.59L191.378 149.066L194.293 147.167C194.352 147.129 194.417 147.103 194.486 147.092ZM198.818 143.107C196.442 143.492 194.006 143.226 191.769 142.338C189.532 141.45 187.577 139.973 186.113 138.062C184.648 136.152 183.728 133.881 183.451 131.49C183.174 129.099 183.55 126.678 184.538 124.484V124.484C185.484 122.381 186.96 120.56 188.82 119.198C190.681 117.836 192.863 116.98 195.153 116.714C197.443 116.448 199.763 116.78 201.887 117.679C204.01 118.578 205.864 120.013 207.267 121.842C208.67 123.672 209.574 125.835 209.891 128.118C210.208 130.402 209.927 132.729 209.076 134.872C208.224 137.015 206.832 138.9 205.033 140.343C203.235 141.787 201.094 142.739 198.817 143.107L198.818 143.107ZM185.45 124.895C184.449 127.118 184.13 129.587 184.533 131.991C184.936 134.395 186.042 136.626 187.712 138.402C189.383 140.177 191.542 141.417 193.917 141.965C196.293 142.514 198.777 142.345 201.057 141.482C203.336 140.618 205.308 139.098 206.724 137.113C208.14 135.129 208.935 132.769 209.01 130.333C209.085 127.896 208.435 125.492 207.144 123.425C205.852 121.358 203.977 119.719 201.755 118.718C200.28 118.041 198.686 117.663 197.065 117.608C195.443 117.552 193.827 117.82 192.31 118.395C190.793 118.969 189.405 119.84 188.227 120.956C187.05 122.072 186.106 123.411 185.45 124.895V124.895Z"
                fill="white"
              />
              <path
                d="M112.389 238.965C105.431 243.772 97.8942 247.641 89.7799 250.572C81.6949 253.341 74.0364 254.689 66.8042 254.617L63.7057 230.565C69.4284 230.695 75.3279 229.858 81.4041 228.054C87.5757 226.184 93.2351 223.471 98.3825 219.914C104.197 215.897 107.982 211.592 109.738 206.999C111.494 202.407 110.955 198.061 108.124 193.962C106.346 191.389 104.098 189.562 101.38 188.482C98.6628 187.402 95.2261 187.524 91.0701 188.846C87.0094 190.102 81.9288 192.838 75.8283 197.053L50.2346 214.735L16.4608 154.844L77.5139 112.663L90.3559 131.251L37.5957 167.702L42.2961 148.824L66.48 191.471L47.1595 189.189L68.3208 174.568C78.2342 167.719 87.1484 163.603 95.0635 162.218C103.008 160.672 109.976 161.28 115.967 164.04C121.958 166.801 126.996 171.137 131.079 177.047C135.162 182.957 137.471 189.458 138.007 196.552C138.476 203.55 136.7 210.762 132.677 218.189C128.684 225.454 121.921 232.379 112.389 238.965Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M190.58 236.565C191.969 214.162 189.414 173.438 231.525 178.829C276.66 184.607 263.747 237.384 263.747 237.384L190.58 236.565Z"
                fill="#EEF6FE"
              />
              <path
                d="M219.642 223.099C229.79 223.099 238.017 214.872 238.017 204.724C238.017 194.575 229.79 186.348 219.642 186.348C209.494 186.348 201.267 194.575 201.267 204.724C201.267 214.872 209.494 223.099 219.642 223.099Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M222.055 186.377C213.352 184.891 204.045 191.307 203.128 197.807L237.635 200.98C236.419 193.57 228.961 187.557 222.055 186.377Z"
                fill="#EEF6FE"
              />
              <path
                d="M233.704 204.266C233.458 209.07 230.839 212.841 227.856 212.688C224.873 212.534 222.655 208.516 222.902 203.712C223.148 198.908 225.766 195.138 228.749 195.291C231.732 195.444 233.951 199.462 233.704 204.266Z"
                fill="#EEF6FE"
              />
              <path
                d="M219.642 224.099C215.81 224.099 212.064 222.962 208.878 220.833C205.691 218.704 203.208 215.678 201.742 212.138C200.275 208.598 199.892 204.702 200.639 200.944C201.387 197.185 203.232 193.733 205.942 191.023C208.651 188.314 212.104 186.469 215.862 185.721C219.62 184.973 223.516 185.357 227.056 186.823C230.597 188.29 233.623 190.773 235.752 193.959C237.881 197.146 239.017 200.892 239.017 204.724C239.011 209.86 236.968 214.785 233.336 218.417C229.703 222.05 224.779 224.093 219.642 224.099V224.099ZM219.642 187.349C216.205 187.349 212.846 188.368 209.989 190.277C207.132 192.186 204.905 194.9 203.589 198.075C202.274 201.249 201.93 204.743 202.601 208.113C203.271 211.484 204.926 214.58 207.356 217.01C209.786 219.44 212.882 221.094 216.252 221.765C219.623 222.435 223.116 222.091 226.291 220.776C229.466 219.461 232.179 217.234 234.089 214.377C235.998 211.519 237.017 208.16 237.017 204.724C237.012 200.117 235.179 195.701 231.922 192.443C228.665 189.186 224.248 187.354 219.642 187.349V187.349Z"
                fill={theme.palette.primary.main}
              />
              <path
                opacity="0.3"
                d="M258.614 236.001C258.574 236.001 258.535 235.996 258.496 235.987C258.367 235.956 258.256 235.875 258.186 235.762C258.117 235.649 258.096 235.513 258.127 235.384C258.159 235.249 261.346 221.689 258.037 207.98C258.019 207.916 258.015 207.848 258.023 207.782C258.032 207.716 258.055 207.652 258.089 207.594C258.123 207.537 258.168 207.486 258.222 207.447C258.276 207.407 258.337 207.378 258.402 207.363C258.467 207.347 258.534 207.344 258.6 207.355C258.666 207.366 258.73 207.39 258.786 207.426C258.843 207.462 258.892 207.509 258.93 207.564C258.968 207.619 258.995 207.681 259.008 207.746C262.376 221.696 259.132 235.48 259.098 235.618C259.072 235.727 259.01 235.824 258.922 235.893C258.834 235.963 258.726 236.001 258.614 236.001V236.001Z"
                fill={theme.palette.primary.main}
              />
              <path
                opacity="0.3"
                d="M255.826 200.482C255.731 200.482 255.637 200.455 255.556 200.403C255.475 200.351 255.411 200.278 255.371 200.19C254.124 197.446 252.53 194.873 250.63 192.533C250.546 192.431 250.506 192.299 250.519 192.167C250.533 192.035 250.598 191.914 250.7 191.83C250.803 191.746 250.935 191.706 251.067 191.719C251.199 191.733 251.32 191.798 251.404 191.9C253.359 194.306 254.998 196.952 256.28 199.774C256.315 199.851 256.33 199.934 256.324 200.018C256.318 200.101 256.291 200.182 256.246 200.252C256.201 200.323 256.139 200.381 256.066 200.421C255.992 200.461 255.91 200.482 255.826 200.482V200.482Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M96.863 341.642C96.7385 341.642 96.6149 341.641 96.4909 341.637C95.17 341.594 93.92 341.029 93.0139 340.067C92.1079 339.105 91.6197 337.823 91.6559 336.502C91.6922 335.181 92.25 333.928 93.2075 333.017C94.1649 332.106 95.4441 331.611 96.7653 331.641C96.7966 331.642 96.8288 331.642 96.861 331.642C99.7502 331.642 106.7 328.132 121.239 305.212C121.625 304.603 122.138 304.085 122.743 303.694C123.348 303.302 124.03 303.046 124.743 302.942C125.456 302.838 126.183 302.89 126.874 303.094C127.566 303.298 128.205 303.648 128.748 304.122C140.165 313.94 152.62 322.483 165.891 329.598C167.059 330.207 167.939 331.252 168.341 332.505C168.742 333.759 168.634 335.12 168.038 336.294C167.442 337.468 166.408 338.36 165.159 338.776C163.91 339.191 162.547 339.098 161.366 338.515C149.037 331.958 137.382 324.206 126.568 315.369C114.383 333.689 105.34 341.642 96.863 341.642Z"
                fill="#EEF6FE"
              />
              <path
                d="M127.798 303.224C127.655 303.224 127.512 303.214 127.37 303.194C126.98 303.138 126.605 303.006 126.266 302.805C125.927 302.604 125.631 302.339 125.394 302.024C125.158 301.708 124.986 301.35 124.888 300.968C124.791 300.586 124.769 300.189 124.825 299.799C125.536 294.822 124.655 276.173 118.35 261.673C118.072 261.033 118.025 260.315 118.219 259.644C118.413 258.973 118.834 258.391 119.412 257.997C133.11 248.662 162.288 247.546 163.524 247.503C164.314 247.483 165.081 247.776 165.657 248.318C166.233 248.86 166.571 249.607 166.599 250.398C166.626 251.188 166.341 251.957 165.804 252.538C165.267 253.119 164.523 253.464 163.733 253.499C163.463 253.509 137.953 254.488 124.845 261.701C130.429 276.14 131.695 294.138 130.764 300.649C130.662 301.363 130.306 302.016 129.761 302.489C129.216 302.962 128.52 303.223 127.798 303.224Z"
                fill="#EEF6FE"
              />
              <path
                d="M132.838 299.339C130.843 294.633 121.851 295.168 116.57 299.201C113.749 301.357 109.929 307.842 109.528 310.193C109.407 310.755 109.425 311.339 109.581 311.893C109.737 312.447 110.025 312.955 110.422 313.373C110.818 313.79 111.31 314.105 111.855 314.289C112.401 314.473 112.983 314.522 113.551 314.431C116.999 314.132 121.732 309.122 121.732 309.122C118.583 312.21 122.646 314.389 128.709 309.923C132.073 307.446 135.073 304.609 132.838 299.339Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M304.834 237.885C304.787 237.885 304.741 237.878 304.696 237.865C304.568 237.829 304.461 237.743 304.397 237.627C304.332 237.511 304.317 237.374 304.353 237.247C305.685 232.607 307.14 229.773 309.053 228.196C308.753 227.122 308.807 225.979 309.206 224.938C309.671 223.72 310.495 222.672 311.568 221.933C311.278 221.617 311.072 221.233 310.969 220.817C310.866 220.401 310.869 219.965 310.978 219.551C311.34 218.3 312.087 217.195 313.114 216.395C312.749 215.977 312.547 215.441 312.547 214.887C312.522 211.904 318.055 207.361 324.31 206.508C324.375 206.498 324.442 206.501 324.506 206.517C324.57 206.533 324.63 206.562 324.682 206.602C324.735 206.642 324.779 206.692 324.812 206.749C324.844 206.807 324.865 206.87 324.873 206.936C324.89 207.067 324.855 207.2 324.775 207.306C324.695 207.411 324.576 207.48 324.444 207.498C318.507 208.309 313.528 212.608 313.547 214.878C313.546 215.215 313.676 215.539 313.909 215.781C315.256 214.871 316.77 214.237 318.363 213.917C319.957 213.597 321.598 213.598 323.191 213.918C326.261 214.505 327.509 215.154 327.364 216.085C327.092 217.838 320.555 218.2 316.174 217.679C315.39 217.61 314.626 217.391 313.924 217.033C312.994 217.711 312.304 218.667 311.955 219.763C311.872 220.055 311.874 220.364 311.962 220.654C312.05 220.944 312.219 221.203 312.45 221.399C314.307 220.442 316.919 220.042 320.366 220.805C324.903 221.805 325.073 222.358 325.174 222.687C325.21 222.802 325.214 222.924 325.186 223.041C325.157 223.157 325.098 223.264 325.013 223.349C324.057 224.362 317.107 223.882 313.615 223.026C313.197 222.928 312.792 222.776 312.413 222.575C311.378 223.202 310.581 224.155 310.145 225.283C309.862 226.016 309.784 226.812 309.919 227.586C310.099 227.478 310.283 227.381 310.471 227.291C312.54 226.309 315.043 226.473 318.125 227.792C320.17 228.668 321.156 229.442 321.228 230.231C321.242 230.441 321.196 230.651 321.095 230.835C320.994 231.02 320.842 231.172 320.658 231.273C319.133 232.286 313.788 232.133 311.01 230.653C310.369 230.31 309.836 229.796 309.472 229.167C307.837 230.66 306.518 233.333 305.315 237.522C305.285 237.627 305.222 237.719 305.135 237.784C305.048 237.85 304.943 237.885 304.834 237.885V237.885ZM310.26 228.554C310.536 229.072 310.96 229.495 311.479 229.771C313.736 230.972 318.175 231.246 319.841 230.574C320.181 230.437 320.232 230.322 320.232 230.321C320.232 230.318 320.177 229.759 317.731 228.712C314.928 227.513 312.693 227.345 310.9 228.194C310.679 228.3 310.465 228.42 310.26 228.554V228.554ZM313.594 221.985C313.68 222.011 313.766 222.034 313.852 222.055C317.106 222.806 320.455 223.056 323.785 222.799C322.604 222.359 321.388 222.018 320.15 221.781C317.992 221.202 315.711 221.273 313.594 221.985V221.985ZM314.855 216.363C315.32 216.526 315.802 216.635 316.292 216.687C321.275 217.277 325.674 216.579 326.332 215.958C326.162 215.804 325.491 215.376 323.003 214.901C320.2 214.336 317.287 214.86 314.855 216.364V216.363Z"
                fill="#EEF6FE"
              />
              <path
                d="M174.656 339.972C175.314 339.761 175.094 339.125 174.359 339.125H160.819C135.039 336.395 117.026 340.054 128.376 340.916C139.726 341.779 127.576 341.598 119.288 344.734C110.999 347.87 180.942 348.66 187.303 344.734C193.17 341.113 165.52 342.899 174.656 339.972Z"
                fill="#EEF6FE"
              />
              <path
                d="M271.597 343.962L153.795 340.057L148.906 225.835L288.017 228.946L271.597 343.962Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M190.58 341.776C190.454 341.776 190.334 341.729 190.241 341.644C190.149 341.559 190.092 341.442 190.082 341.317L180.638 226.597C180.627 226.464 180.669 226.333 180.755 226.232C180.841 226.131 180.963 226.068 181.096 226.057C181.228 226.046 181.359 226.088 181.46 226.174C181.561 226.26 181.624 226.382 181.635 226.515L191.079 341.235C191.089 341.367 191.047 341.499 190.961 341.6C190.876 341.701 190.753 341.764 190.621 341.774C190.607 341.775 190.593 341.776 190.58 341.776Z"
                fill="#EEF6FE"
              />
              <path
                d="M271.597 343.962L303.259 339.142L313.232 232.932L288.017 228.946L271.597 343.962Z"
                fill={theme.palette.primary.main}
              />
              <path
                opacity="0.2"
                d="M271.597 343.962L303.259 339.142L313.232 232.932L288.017 228.946L271.597 343.962Z"
                fill="black"
              />
              <path
                d="M163.863 318.04L160.958 250.178C160.886 248.501 161.16 246.827 161.761 245.26C162.362 243.693 163.278 242.266 164.452 241.067C165.627 239.868 167.035 238.923 168.59 238.29C170.144 237.657 171.812 237.35 173.49 237.388L261.549 239.357C263.283 239.396 264.989 239.802 266.555 240.548C268.121 241.295 269.51 242.365 270.632 243.688C271.754 245.011 272.583 246.557 273.063 248.223C273.544 249.89 273.666 251.64 273.42 253.357L263.657 321.748C263.23 324.741 261.712 327.471 259.396 329.414C257.079 331.357 254.127 332.377 251.105 332.276L175.714 329.777C172.623 329.675 169.684 328.409 167.487 326.232C165.289 324.056 163.995 321.13 163.863 318.04V318.04Z"
                fill="#EEF6FE"
              />
              <path
                d="M173.375 258.212L186.999 258.645L186.888 262.158L178.359 261.887L178.275 264.501L186.187 264.753L186.08 268.109L178.169 267.857L178.065 271.1L186.841 271.38L186.723 275.105L172.852 274.664L173.375 258.212Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M189.528 275.195L190.052 258.742L198.525 259.012C199.74 259.007 200.95 259.182 202.114 259.531C202.924 259.818 203.615 260.368 204.075 261.093C204.422 261.627 204.656 262.227 204.761 262.855C204.867 263.484 204.842 264.127 204.688 264.745C204.535 265.363 204.256 265.944 203.868 266.449C203.481 266.955 202.994 267.376 202.438 267.686C201.87 267.976 201.261 268.177 200.632 268.28C201.095 268.433 201.534 268.651 201.936 268.928C202.231 269.194 202.495 269.493 202.721 269.819C202.981 270.145 203.209 270.495 203.401 270.864L205.711 275.71L199.967 275.527L197.41 270.413C197.208 269.925 196.909 269.483 196.53 269.116C196.172 268.85 195.741 268.703 195.296 268.694L194.847 268.68L194.635 275.357L189.528 275.195ZM194.946 265.571L197.089 265.639C197.545 265.619 197.998 265.558 198.443 265.458C198.775 265.405 199.075 265.231 199.285 264.968C199.531 264.651 199.656 264.256 199.634 263.855C199.613 263.454 199.448 263.074 199.169 262.785C198.611 262.422 197.949 262.251 197.285 262.298L195.052 262.227L194.946 265.571Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M207.405 275.764L207.929 259.312L216.402 259.582C217.618 259.576 218.827 259.751 219.992 260.1C220.802 260.387 221.492 260.937 221.953 261.662C222.3 262.196 222.533 262.796 222.639 263.424C222.744 264.053 222.72 264.696 222.566 265.314C222.412 265.933 222.133 266.513 221.746 267.019C221.359 267.524 220.872 267.945 220.315 268.255C219.747 268.546 219.138 268.746 218.509 268.849C218.973 269.002 219.412 269.22 219.813 269.498C220.109 269.763 220.372 270.062 220.599 270.389C220.858 270.714 221.086 271.064 221.279 271.433L223.589 276.279L217.844 276.096L215.287 270.982C215.086 270.494 214.786 270.052 214.407 269.685C214.05 269.419 213.618 269.272 213.173 269.263L212.724 269.249L212.512 275.927L207.405 275.764ZM212.823 266.14L214.966 266.209C215.422 266.188 215.875 266.128 216.32 266.027C216.652 265.975 216.952 265.8 217.161 265.537C217.408 265.22 217.532 264.825 217.511 264.424C217.49 264.023 217.325 263.643 217.046 263.354C216.488 262.991 215.826 262.82 215.162 262.867L212.929 262.796L212.823 266.14Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M224.444 268.083C224.368 266.934 224.546 265.784 224.967 264.713C225.388 263.642 226.041 262.677 226.88 261.889C227.718 261.1 228.72 260.507 229.815 260.152C230.909 259.797 232.069 259.689 233.211 259.835C234.362 259.797 235.509 259.99 236.584 260.404C237.659 260.817 238.641 261.442 239.47 262.241C240.214 263.091 240.777 264.083 241.125 265.157C241.474 266.232 241.6 267.365 241.495 268.49C241.506 270.124 241.121 271.737 240.374 273.19C239.705 274.384 238.697 275.352 237.477 275.974C236.043 276.657 234.457 276.961 232.871 276.855C231.287 276.859 229.722 276.506 228.293 275.822C227.068 275.164 226.069 274.154 225.425 272.922C224.669 271.426 224.33 269.755 224.444 268.083V268.083ZM229.527 268.267C229.374 269.528 229.661 270.802 230.339 271.876C230.654 272.229 231.036 272.514 231.464 272.715C231.892 272.915 232.355 273.028 232.828 273.045C233.3 273.062 233.77 272.984 234.212 272.814C234.653 272.645 235.055 272.388 235.394 272.06C236.145 270.941 236.503 269.605 236.414 268.261C236.554 267.057 236.26 265.843 235.585 264.837C235.279 264.47 234.895 264.176 234.461 263.977C234.027 263.777 233.554 263.677 233.077 263.684C232.61 263.652 232.143 263.726 231.709 263.901C231.275 264.076 230.887 264.347 230.573 264.694C229.823 265.728 229.453 266.991 229.527 268.267Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M244.035 276.929L244.559 260.477L253.032 260.747C254.247 260.741 255.457 260.916 256.621 261.266C257.431 261.552 258.122 262.102 258.582 262.827C258.929 263.362 259.163 263.961 259.268 264.59C259.374 265.218 259.349 265.861 259.195 266.479C259.042 267.098 258.763 267.678 258.375 268.184C257.988 268.69 257.501 269.111 256.945 269.42C256.377 269.711 255.768 269.911 255.138 270.014C255.602 270.167 256.041 270.385 256.443 270.663C256.738 270.929 257.001 271.228 257.228 271.554C257.488 271.879 257.716 272.229 257.908 272.599L260.218 277.444L254.474 277.262L251.916 272.147C251.715 271.659 251.416 271.217 251.036 270.85C250.679 270.584 250.248 270.437 249.803 270.429L249.354 270.414L249.142 277.092L244.035 276.929ZM249.453 267.306L251.596 267.374C252.052 267.354 252.505 267.293 252.95 267.192C253.282 267.14 253.582 266.965 253.791 266.702C254.038 266.385 254.162 265.99 254.141 265.589C254.12 265.188 253.954 264.808 253.675 264.52C253.117 264.156 252.456 263.985 251.792 264.033L249.559 263.961L249.453 267.306Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M252.127 304.882C251.945 304.882 251.764 304.844 251.597 304.771C251.43 304.697 251.28 304.59 251.157 304.455L242.597 295.086L233.36 303.526C233.233 303.642 233.084 303.732 232.922 303.791C232.76 303.85 232.588 303.876 232.415 303.869C232.243 303.861 232.074 303.819 231.918 303.746C231.762 303.673 231.622 303.57 231.505 303.443L222.945 294.074L213.708 302.514C213.451 302.749 213.111 302.872 212.764 302.856C212.416 302.841 212.088 302.688 211.853 302.431L203.293 293.062L194.056 301.502C193.929 301.618 193.78 301.708 193.618 301.767C193.456 301.826 193.284 301.852 193.112 301.844C192.939 301.837 192.77 301.795 192.614 301.722C192.458 301.649 192.318 301.546 192.202 301.419L183.642 292.05L174.405 300.489C174.278 300.608 174.129 300.701 173.966 300.763C173.803 300.824 173.63 300.852 173.456 300.846C173.282 300.839 173.111 300.798 172.953 300.725C172.795 300.652 172.653 300.548 172.536 300.419C172.418 300.291 172.327 300.14 172.269 299.976C172.21 299.812 172.185 299.638 172.194 299.465C172.203 299.291 172.247 299.12 172.323 298.964C172.398 298.807 172.504 298.667 172.635 298.551L182.84 289.226C182.967 289.11 183.116 289.019 183.278 288.96C183.44 288.902 183.612 288.875 183.785 288.883C183.957 288.891 184.126 288.932 184.282 289.005C184.438 289.079 184.579 289.182 184.695 289.309L193.255 298.678L202.492 290.238C202.619 290.122 202.768 290.032 202.93 289.973C203.092 289.914 203.264 289.888 203.437 289.896C203.609 289.903 203.778 289.945 203.934 290.018C204.09 290.091 204.23 290.194 204.347 290.321L212.907 299.691L222.143 291.251C222.271 291.135 222.419 291.044 222.582 290.986C222.744 290.927 222.916 290.9 223.088 290.908C223.26 290.916 223.429 290.957 223.585 291.03C223.741 291.104 223.882 291.207 223.998 291.334L232.559 300.703L241.795 292.264C241.922 292.147 242.071 292.057 242.233 291.998C242.395 291.939 242.568 291.912 242.74 291.92C242.912 291.928 243.081 291.97 243.237 292.043C243.394 292.116 243.534 292.219 243.65 292.347L253.096 302.685C253.268 302.873 253.381 303.106 253.422 303.358C253.463 303.609 253.431 303.867 253.328 304.099C253.225 304.332 253.057 304.53 252.844 304.669C252.631 304.809 252.382 304.883 252.127 304.883L252.127 304.882Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M93.8781 346.39L87.6201 343.405L82.0371 316.239L85.0671 312.902L93.8781 346.39Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M93.8781 346.39L102.183 341.539L95.0641 319.155L85.0671 312.902L93.8781 346.39Z"
                fill={theme.palette.primary.main}
              />
              <path
                opacity="0.2"
                d="M93.8781 346.39L102.183 341.539L95.0641 319.155L85.0671 312.902L93.8781 346.39Z"
                fill="black"
              />
              <path
                d="M230.077 351.329C229.841 351.329 229.611 351.325 229.386 351.319C228.065 351.276 226.815 350.712 225.909 349.749C225.003 348.787 224.515 347.506 224.551 346.185C224.587 344.863 225.145 343.61 226.103 342.699C227.06 341.788 228.339 341.294 229.66 341.323C237.363 341.575 253.666 336.842 262.979 327.802C263.555 327.244 264.257 326.832 265.025 326.601C280.813 321.863 286.69 331.435 286.932 331.845L278.324 336.935C278.358 337 278.396 337.061 278.44 337.118C278.344 336.986 276.108 334.079 268.988 335.878C257.301 346.546 239.361 351.329 230.077 351.329Z"
                fill="#EEF6FE"
              />
              <path
                d="M229.523 357.976L211.31 356.828L209.873 323.252L234.35 324.167L229.523 357.976Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M229.523 357.976L233.78 353.739L236.419 332.802L234.35 324.167L229.523 357.976Z"
                fill={theme.palette.primary.main}
              />
              <path
                opacity="0.2"
                d="M229.523 357.976L233.78 353.739L236.419 332.802L234.35 324.167L229.523 357.976Z"
                fill="black"
              />
              <path
                d="M335.038 345.261C334.383 345.261 333.746 345.046 333.225 344.649C322.831 336.749 308.78 322.724 303.388 309.192C303.31 308.995 303.252 308.789 303.217 308.579C300.588 292.946 298.076 260.038 297.97 258.644C297.935 258.249 297.979 257.85 298.1 257.472C298.22 257.093 298.414 256.743 298.671 256.44C298.928 256.137 299.243 255.888 299.596 255.708C299.95 255.527 300.336 255.419 300.732 255.389C301.128 255.359 301.526 255.408 301.903 255.533C302.28 255.658 302.628 255.857 302.928 256.117C303.228 256.378 303.472 256.696 303.648 257.052C303.824 257.408 303.928 257.795 303.953 258.191C303.979 258.527 306.515 291.758 309.081 307.265C314.458 320.421 329.038 333.931 336.856 339.872C337.356 340.252 337.725 340.78 337.909 341.38C338.093 341.981 338.085 342.624 337.884 343.22C337.683 343.815 337.3 344.332 336.79 344.698C336.279 345.065 335.667 345.261 335.038 345.261V345.261Z"
                fill="#EEF6FE"
              />
              <path
                d="M348.906 346.776C346.587 346.776 343.957 345.725 341.092 343.651C340.447 343.185 340.014 342.481 339.888 341.696C339.762 340.91 339.953 340.107 340.42 339.462C340.886 338.817 341.59 338.384 342.375 338.258C343.161 338.132 343.964 338.324 344.609 338.79C347.086 340.583 348.439 340.776 348.906 340.776C349.702 340.776 350.465 341.092 351.027 341.655C351.59 342.218 351.906 342.981 351.906 343.776C351.906 344.572 351.59 345.335 351.027 345.898C350.465 346.46 349.702 346.776 348.906 346.776V346.776Z"
                fill="#EEF6FE"
              />
              <path
                d="M341.932 343.566C345.142 334.031 358.302 335.915 362.834 337.331C366.711 338.461 370.43 340.074 373.904 342.134C376.359 343.738 376.398 346.419 373.125 347.95C369.089 349.838 358.964 348.163 358.964 348.163C364.205 350.457 358.954 354.135 349.759 350.523C346.765 349.347 340.799 347.059 341.932 343.566Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M309.99 262.76C308.799 270.861 302.09 276.836 296.632 276.034C291.175 275.231 290.948 267.996 292.139 259.894C293.33 251.792 295.488 245.892 300.946 246.695C306.403 247.497 311.181 254.658 309.99 262.76Z"
                fill="#EEF6FE"
              />
              <path
                d="M178.003 230.418C178.456 230.418 178.823 230.051 178.823 229.599C178.823 229.146 178.456 228.779 178.003 228.779C177.551 228.779 177.184 229.146 177.184 229.599C177.184 230.051 177.551 230.418 178.003 230.418Z"
                fill="#EEF6FE"
              />
              <path
                d="M186.337 235.501C186.336 235.663 186.288 235.822 186.198 235.957C186.108 236.091 185.98 236.196 185.83 236.258C185.68 236.32 185.516 236.336 185.357 236.305C185.198 236.273 185.052 236.195 184.937 236.08C184.823 235.966 184.745 235.819 184.713 235.661C184.682 235.502 184.698 235.337 184.76 235.187C184.822 235.037 184.927 234.909 185.062 234.819C185.197 234.729 185.355 234.681 185.517 234.681C185.625 234.681 185.731 234.703 185.831 234.744C185.93 234.785 186.021 234.845 186.097 234.922C186.173 234.998 186.233 235.088 186.274 235.188C186.315 235.287 186.337 235.394 186.337 235.501V235.501Z"
                fill="#EEF6FE"
              />
              <path
                d="M187.253 332.406C187.253 332.568 187.205 332.727 187.115 332.862C187.025 332.996 186.897 333.101 186.747 333.163C186.597 333.225 186.432 333.241 186.274 333.21C186.115 333.178 185.969 333.1 185.854 332.985C185.74 332.871 185.662 332.725 185.63 332.566C185.598 332.407 185.615 332.242 185.677 332.092C185.739 331.942 185.844 331.814 185.979 331.724C186.113 331.634 186.272 331.586 186.434 331.586C186.542 331.586 186.648 331.608 186.748 331.649C186.847 331.69 186.937 331.751 187.013 331.827C187.09 331.903 187.15 331.993 187.191 332.093C187.232 332.192 187.253 332.299 187.253 332.406V332.406Z"
                fill="#EEF6FE"
              />
              <path
                d="M194.767 338.309C194.767 338.471 194.719 338.63 194.629 338.764C194.539 338.899 194.411 339.004 194.261 339.066C194.112 339.128 193.947 339.145 193.788 339.113C193.629 339.081 193.483 339.003 193.368 338.889C193.254 338.774 193.176 338.628 193.144 338.469C193.112 338.311 193.128 338.146 193.19 337.996C193.252 337.846 193.357 337.718 193.492 337.628C193.627 337.538 193.785 337.49 193.947 337.49C194.055 337.49 194.161 337.511 194.261 337.552C194.36 337.593 194.451 337.653 194.527 337.73C194.603 337.806 194.663 337.896 194.705 337.995C194.746 338.095 194.767 338.201 194.767 338.309V338.309Z"
                fill="#EEF6FE"
              />
              <path
                d="M50.638 348.143C49.1983 348.074 47.7923 347.684 46.5232 347C45.2542 346.317 44.1543 345.358 43.3045 344.193C43.2647 344.14 43.2361 344.078 43.2204 344.013C43.2047 343.948 43.2023 343.88 43.2133 343.814C43.2243 343.748 43.2484 343.685 43.2843 343.628C43.3202 343.572 43.3671 343.523 43.4222 343.485C43.4774 343.447 43.5396 343.42 43.6052 343.406C43.6708 343.393 43.7385 343.393 43.8042 343.406C43.8699 343.419 43.9323 343.445 43.9877 343.483C44.0432 343.52 44.0904 343.569 44.1267 343.625C45.9929 346.319 50.1057 347.756 51.9319 346.905C52.1094 346.826 52.2685 346.71 52.3992 346.566C51.4893 346.165 50.6918 345.547 50.077 344.766C49.4622 343.984 49.0488 343.064 48.8733 342.085C48.6467 340.817 48.4666 339.105 49.5125 338.868C50.9465 338.546 52.823 342.015 53.5447 344.643C53.6728 345.079 53.7169 345.534 53.6747 345.986C54.2547 346.153 54.8624 346.201 55.4613 346.127C55.7297 346.105 55.9905 346.028 56.2272 345.899C56.4639 345.771 56.6712 345.595 56.8358 345.382C56.178 344.885 55.6326 344.256 55.2354 343.534C54.8382 342.812 54.5982 342.014 54.5311 341.192C54.1434 338.458 54.4339 337.981 54.7372 337.748C54.834 337.674 54.9492 337.627 55.0704 337.613C55.1916 337.6 55.3143 337.619 55.4252 337.67C56.4945 338.125 57.7904 342.004 58.0379 344.199C58.0646 344.429 58.0655 344.662 58.0404 344.892C58.4705 345.06 58.9274 345.149 59.389 345.154C60.2364 345.183 61.0739 344.965 61.799 344.525C61.6581 344.437 61.5238 344.338 61.3971 344.23C60.3595 343.344 59.9411 341.927 60.1171 339.899C60.2528 338.332 60.6097 337.476 61.2401 337.206C61.4431 337.126 61.665 337.105 61.8791 337.148C62.0932 337.19 62.2906 337.294 62.4476 337.445C63.122 338.19 63.6258 339.073 63.9239 340.033C64.2219 340.993 64.307 342.006 64.1732 343.002C64.091 343.417 63.9196 343.81 63.6708 344.153C65.5057 344.47 68.0878 343.954 70.3143 343.404C70.4424 343.374 70.5772 343.396 70.6895 343.464C70.8017 343.533 70.8824 343.643 70.9139 343.771C70.9455 343.899 70.9255 344.034 70.8582 344.147C70.7909 344.26 70.6817 344.342 70.5543 344.375C67.8443 345.045 64.9273 345.59 62.8668 344.992C61.8623 345.757 60.6315 346.166 59.3687 346.154C58.8087 346.147 58.2542 346.043 57.7296 345.847C57.4958 346.206 57.1828 346.508 56.8147 346.728C56.4466 346.948 56.033 347.081 55.6055 347.117C54.8544 347.21 54.0921 347.145 53.3677 346.926C53.1271 347.316 52.7739 347.625 52.3546 347.811C51.8129 348.044 51.2274 348.157 50.638 348.143V348.143ZM49.7732 339.865C49.6416 340.544 49.6705 341.244 49.8577 341.909C49.9997 342.709 50.3316 343.464 50.8257 344.109C51.3198 344.754 51.9615 345.272 52.697 345.617C52.6863 345.378 52.6473 345.14 52.5808 344.909C51.796 342.051 50.3028 340.081 49.7735 339.865H49.7732ZM55.3445 338.993C55.3524 339.683 55.4116 340.371 55.5217 341.052C55.6285 342.272 56.1669 343.415 57.0403 344.275C56.7911 342.428 56.2171 340.64 55.3448 338.994L55.3445 338.993ZM61.6355 338.125H61.6336C61.6311 338.126 61.2581 338.315 61.1136 339.985C60.9676 341.668 61.2736 342.808 62.0476 343.47C62.2289 343.623 62.4305 343.75 62.6468 343.848C62.9196 343.563 63.1077 343.207 63.1902 342.82C63.3671 341.245 62.9397 339.662 61.9944 338.39C61.793 338.167 61.6636 338.125 61.6358 338.125H61.6355Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M197.002 355.702L199.711 351.001L197.002 346.302H194.1L195.739 351.002L194.1 355.702H197.002Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M194.291 353.452C193.968 353.455 193.648 353.394 193.349 353.272C193.05 353.151 192.778 352.971 192.548 352.744C192.319 352.516 192.137 352.246 192.012 351.948C191.888 351.65 191.824 351.33 191.824 351.007C191.824 350.684 191.888 350.364 192.012 350.066C192.137 349.768 192.319 349.497 192.548 349.27C192.778 349.043 193.05 348.863 193.349 348.742C193.648 348.62 193.968 348.559 194.291 348.562L189.684 347.64L188.461 351.361L190.517 354.5L194.291 353.452Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M194.685 346.302H189.255L186.545 351.002L189.255 355.702H194.685L197.395 351.002L194.685 346.302ZM191.975 353.452C191.491 353.453 191.018 353.31 190.616 353.043C190.213 352.775 189.899 352.393 189.713 351.947C189.527 351.501 189.477 351.009 189.571 350.535C189.664 350.06 189.896 349.624 190.237 349.281C190.579 348.939 191.014 348.705 191.488 348.61C191.962 348.514 192.454 348.562 192.901 348.746C193.348 348.93 193.731 349.243 194 349.644C194.27 350.046 194.414 350.518 194.415 351.002C194.414 351.65 194.157 352.271 193.7 352.729C193.242 353.188 192.622 353.448 191.975 353.452L191.975 353.452Z"
                fill="#CEDCFA"
              />
              <path
                d="M386.018 345.989L384.005 342.498L386.018 339.008H388.172L386.955 342.498L388.172 345.989H386.018Z"
                fill="#CEDCFA"
              />
              <path
                d="M388.03 344.318C388.27 344.32 388.507 344.274 388.729 344.183C388.951 344.093 389.153 343.96 389.323 343.791C389.493 343.622 389.628 343.421 389.72 343.2C389.812 342.979 389.86 342.742 389.86 342.502C389.86 342.262 389.812 342.025 389.72 341.804C389.628 341.583 389.493 341.382 389.323 341.213C389.153 341.044 388.951 340.911 388.729 340.82C388.507 340.73 388.27 340.684 388.03 340.686L391.452 340.001L392.36 342.765L390.833 345.096L388.03 344.318Z"
                fill="#CEDCFA"
              />
              <path
                d="M387.738 339.008H391.771L393.783 342.498L391.771 345.988H387.738L385.726 342.498L387.738 339.008ZM389.751 344.318C390.11 344.319 390.461 344.213 390.76 344.014C391.059 343.815 391.293 343.532 391.431 343.2C391.569 342.869 391.606 342.504 391.536 342.151C391.467 341.799 391.295 341.475 391.041 341.221C390.788 340.966 390.465 340.793 390.113 340.722C389.761 340.651 389.395 340.686 389.063 340.823C388.731 340.959 388.447 341.192 388.247 341.49C388.047 341.788 387.939 342.139 387.939 342.498C387.939 342.979 388.13 343.44 388.47 343.781C388.809 344.122 389.27 344.315 389.751 344.318L389.751 344.318Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M311.076 350.622H315.594C316.161 350.62 316.704 350.394 317.105 349.994C317.505 349.593 317.731 349.05 317.733 348.483V348.483C317.731 347.916 317.505 347.373 317.105 346.972C316.704 346.572 316.161 346.346 315.594 346.344H311.076C310.509 346.346 309.966 346.572 309.565 346.972C309.164 347.373 308.938 347.916 308.937 348.483V348.483C308.938 349.05 309.164 349.593 309.565 349.994C309.966 350.394 310.509 350.62 311.076 350.622V350.622Z"
                fill={theme.palette.primary.main}
              />
              <path
                d="M303.858 346.587C304.277 345.826 304.91 345.204 305.679 344.798C306.448 344.392 307.318 344.22 308.183 344.302C309.048 344.385 309.871 344.719 310.548 345.263C311.226 345.807 311.73 346.538 311.998 347.365C312.266 348.191 312.286 349.079 312.056 349.917C311.825 350.755 311.355 351.507 310.703 352.082C310.05 352.656 309.244 353.027 308.384 353.148C307.523 353.27 306.646 353.137 305.859 352.767C304.775 352.212 303.956 351.249 303.581 350.091C303.205 348.932 303.305 347.672 303.858 346.587V346.587Z"
                fill="#CEDCFA"
              />
              <path
                d="M305.106 352.759L306.345 353.344L310.653 344.206L309.414 343.622L305.106 352.759Z"
                fill={theme.palette.primary.main}
              />
            </g>
            <defs>
              <clipPath id="clip0_166_56397">
                <rect width="428" height="361" fill="white" />
              </clipPath>
            </defs>
          </svg>
        </div>
      </Box>
    </>
  );
};

FiveHundred.propTypes = {};

export default FiveHundred;
