import React from "react";
import { useTheme } from "@mui/material";

const SolutionSvg = (props) => {
  const theme = useTheme();
  return (
    <svg
      width="100%"
      height="100%"
      viewBox="0 0 440 400"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M171.95 83.69C169.373 83.7622 166.921 84.8181 165.099 86.641C163.276 88.4638 162.22 90.9152 162.148 93.492C162.092 95.6803 162.757 97.8262 164.04 99.5995L164.131 99.7352L171.249 109.409C171.39 109.61 171.579 109.774 171.799 109.885C172.019 109.996 172.262 110.052 172.508 110.048C172.755 110.043 172.996 109.979 173.211 109.859C173.427 109.74 173.61 109.57 173.744 109.364L180.176 99.803C181.455 98.0268 182.17 95.9065 182.227 93.7182C182.224 92.381 181.955 91.0577 181.434 89.826C180.914 88.5942 180.152 87.4787 179.195 86.5448C178.238 85.6109 177.104 84.8773 175.86 84.3871C174.616 83.8969 173.287 83.6599 171.95 83.69ZM172.184 99.6824C171.052 99.6824 169.945 99.3467 169.004 98.7179C168.063 98.0891 167.329 97.1953 166.896 96.1496C166.463 95.1039 166.35 93.9532 166.571 92.8431C166.791 91.7329 167.336 90.7132 168.137 89.9129C168.937 89.1125 169.957 88.5674 171.067 88.3466C172.177 88.1258 173.328 88.2391 174.374 88.6723C175.419 89.1054 176.313 89.839 176.942 90.7801C177.571 91.7212 177.906 92.8277 177.906 93.9595C177.907 94.7113 177.76 95.456 177.473 96.1507C177.186 96.8455 176.764 97.4768 176.232 98.0084C175.701 98.54 175.07 98.9615 174.375 99.2488C173.68 99.536 172.935 99.6834 172.184 99.6824Z"
        fill="#E0E0E0"
      />
      <path
        d="M324.244 63.324C324.832 59.079 318.838 55.588 314.337 55.2261C312.188 55.0527 309.956 55.3769 307.92 54.6681C303.517 53.1601 301.752 47.4373 297.454 45.6201C294.235 44.2629 290.533 45.4693 287.419 47.0376C284.305 48.606 281.221 50.5814 277.737 50.8076C274.721 50.9961 271.419 49.8727 268.772 51.3581C266.797 52.4589 265.756 54.736 263.939 56.0781C262.122 57.4202 259.837 57.669 257.628 57.7897C255.419 57.9103 253.104 57.9329 251.114 58.8528C249.123 59.7727 247.442 61.8688 247.856 64.0705L324.244 63.324Z"
        fill="#EBEBEB"
      />
      <path
        d="M192.52 40.7348C192.829 38.4728 189.64 36.618 187.242 36.4219C186.096 36.3315 184.912 36.5049 183.826 36.1279C181.482 35.306 180.547 32.2825 178.254 31.3098C176.543 30.5935 174.575 31.2344 172.916 32.0638C171.257 32.8932 169.614 33.9488 167.759 34.0695C166.153 34.1675 164.396 33.5718 162.986 34.356C161.938 34.9441 161.387 36.158 160.415 36.8743C159.407 37.4941 158.242 37.8084 157.059 37.7791C155.878 37.7545 154.702 37.9488 153.591 38.3522C153.042 38.5662 152.576 38.9519 152.264 39.4519C151.951 39.9518 151.809 40.5393 151.857 41.1269L192.52 40.7348Z"
        fill="#F5F5F5"
      />
      <path
        d="M121.477 81.0358C121.937 77.6956 117.225 74.951 113.688 74.6645C112 74.5288 110.243 74.7852 108.644 74.2272C105.183 73.0208 103.796 68.542 100.418 67.117C97.8922 66.0614 94.9817 67.0039 92.5312 68.2329C90.0807 69.4619 87.6529 71.0227 84.9158 71.1961C82.5332 71.3469 79.9545 70.4421 77.8659 71.6259C76.3127 72.493 75.4984 74.2875 74.0959 75.3356C72.6935 76.3836 70.8462 76.6174 69.1045 76.6852C67.3627 76.7531 65.5757 76.7983 63.9923 77.5222C62.4089 78.246 61.1045 79.9199 61.4287 81.6239L121.477 81.0358Z"
        fill="#F5F5F5"
      />
      <path
        d="M387.948 73.9263C387.948 73.9263 387.511 73.8132 386.734 73.6549C385.637 73.436 384.51 73.4054 383.402 73.5644C381.764 73.7972 380.221 74.4724 378.938 75.5173C377.374 76.8003 376.27 78.5577 375.794 80.5238V80.5841L375.605 81.3381L375.319 80.6369C374.552 78.7682 373.238 77.1753 371.549 76.0677C370.171 75.1644 368.585 74.6273 366.942 74.5069C365.412 74.426 363.88 74.6201 362.418 75.0799C362.771 74.8544 363.158 74.6865 363.564 74.5823C364.66 74.2376 365.809 74.092 366.957 74.1525C368.674 74.2279 370.342 74.7475 371.798 75.6605C373.584 76.8005 374.975 78.4649 375.779 80.4258H375.304V80.3655C375.794 78.2816 376.971 76.4228 378.644 75.0875C379.996 74.0061 381.628 73.3314 383.349 73.1422C384.495 73.0046 385.658 73.0891 386.772 73.391C387.192 73.5004 387.59 73.6815 387.948 73.9263Z"
        fill="#E0E0E0"
      />
      <path
        d="M58.2031 138.778L85.1963 285.318L141.347 295.497L191.654 263.128L245.459 276.12L301.255 240.32L273.938 101.305L218.383 128.999L170.459 118.594L118.282 146.22L58.2031 138.778Z"
        fill="white"
      />
      <path
        d="M141.429 295.896L84.8789 285.642L84.8337 285.386L57.75 138.356L118.213 145.85L170.413 118.216L218.337 128.644L274.216 100.746L274.306 101.229L301.677 240.5L301.458 240.636L245.526 276.519L245.375 276.481L191.721 263.527L141.429 295.896ZM85.5198 284.994L141.271 295.105L191.585 262.72L191.736 262.758L245.39 275.712L300.832 240.138L273.688 101.862L218.435 129.398H218.307L170.511 119.016L118.349 146.635H118.251L58.685 139.2L85.5198 284.994Z"
        fill="#E0E0E0"
      />
      <path
        d="M64 143.452L89.4927 282.43L140.968 290.219L191.132 256.914L243.806 269.453L295.998 237.914L271.418 107.117L219.271 133.756L170.412 125.296L117.059 151.332L93.1949 147.788L64 143.452Z"
        fill="#EBEBEB"
      />
      <path
        d="M102.537 148.528L102.687 200.788L282.562 246.963L273.604 252.874L103.856 208.758L102.386 284.384L91.4453 282.725L93.1946 147.789L102.537 148.528Z"
        fill="#FAFAFA"
      />
      <path
        d="M66.8125 155.887L93.8283 161.956L92.8934 170.544L67.7776 164.037L66.8125 155.887Z"
        fill="#FAFAFA"
      />
      <path
        d="M73.2891 194.1L92.6442 189.832L92.5161 199.664L74.6915 203.66L73.2891 194.1Z"
        fill="#FAFAFA"
      />
      <path
        d="M80.4219 232.961L92.0712 233.979L92.0033 239.604L81.3418 239.257L80.4219 232.961Z"
        fill="#FAFAFA"
      />
      <path
        d="M102.387 284.384L117.301 286.638L120.747 256.554L144.166 258.937L146.405 286.608L156.313 280.033L156.109 222.337L103.857 208.758L102.387 284.384Z"
        fill="#E0E0E0"
      />
      <path
        d="M162.088 223.888L161.802 254.885L161.598 276.517L156.312 280.031L155.77 220.035L162.088 223.888Z"
        fill="#FAFAFA"
      />
      <path
        d="M186.307 260.112L161.802 254.887L161.734 262.148L178.601 265.232L186.307 260.112Z"
        fill="#FAFAFA"
      />
      <path
        d="M130.127 144.954L126.176 206.819L135.058 209.096L140.064 140.105L130.127 144.954Z"
        fill="#FAFAFA"
      />
      <path
        d="M156.797 214.677L158.305 137.437L163.651 139.571L163.236 166.443L218.798 182.533L232.001 129.158L242.165 123.473L225.901 184.192L213.309 231.551C213.309 231.551 205.973 229.847 206.229 228.641C206.485 227.434 216.272 192.275 216.272 192.275L162.376 174.797L161.404 219.208L156.797 214.677Z"
        fill="#FAFAFA"
      />
      <path
        d="M220.75 191.617L258.088 202.535L275.438 128.5L272.158 112.184L252.878 192.688L222.183 183.263L220.75 191.617Z"
        fill="#FAFAFA"
      />
      <path
        d="M200 259.585L206.22 228.641L213.61 230.405L207.042 261.711L200 259.585Z"
        fill="#FAFAFA"
      />
      <path
        d="M276.917 183.383L261.656 258.67L275.16 250.157L288.453 200.265L286.538 187.221L276.917 183.383Z"
        fill="#E0E0E0"
      />
      <path
        opacity="0.1"
        d="M117.059 151.332L140.968 290.219L89.4927 282.43L64 143.453L117.059 151.332Z"
        fill="black"
      />
      <path
        d="M151.281 134.631L156.552 136.735L286.76 188.754L282.945 168.478L170.41 125.297L151.281 134.631Z"
        fill="#E0E0E0"
      />
      <path
        opacity="0.1"
        d="M170.414 125.297L191.134 256.915L243.808 269.454L219.273 133.757L170.414 125.297Z"
        fill="black"
      />
      <path
        d="M374.687 340.617H302.68L306.736 336.613H377.062L374.687 340.617Z"
        fill="#E0E0E0"
      />
      <path
        d="M381.108 369.29C381.108 369.395 307.97 369.486 217.784 369.486C127.598 369.486 54.4453 369.395 54.4453 369.29C54.4453 369.184 127.583 369.094 217.784 369.094C307.985 369.094 381.108 369.169 381.108 369.29Z"
        fill="#263238"
      />
      <path
        d="M146.289 104.085C146.289 104.138 145.43 103.791 143.831 103.437C141.573 102.942 139.245 102.85 136.955 103.165C133.554 103.615 130.346 105.001 127.688 107.169C124.429 109.82 122.13 113.468 121.143 117.552C121.143 117.589 121.143 117.627 121.143 117.665L120.955 118.419L120.668 117.71C119.062 113.845 116.319 110.558 112.804 108.285C109.942 106.423 106.651 105.325 103.243 105.096C100.948 104.932 98.6403 105.144 96.4123 105.722C94.8364 106.136 93.9995 106.476 93.9844 106.476C94.1705 106.361 94.3675 106.265 94.5725 106.189C95.1592 105.917 95.7638 105.685 96.3821 105.495C98.6243 104.851 100.96 104.596 103.289 104.741C106.774 104.928 110.152 106.017 113.091 107.901C116.697 110.219 119.505 113.587 121.136 117.552L120.661 117.597V117.476C121.67 113.286 124.037 109.548 127.394 106.845C130.129 104.649 133.426 103.267 136.91 102.856C139.238 102.567 141.6 102.71 143.877 103.279C144.493 103.43 145.097 103.624 145.686 103.859C145.895 103.913 146.097 103.989 146.289 104.085Z"
        fill="#263238"
      />
      <path
        d="M220.476 77.3285C220.476 77.3285 219.994 77.1928 219.111 77.0043C217.87 76.7549 216.595 76.7192 215.341 76.8987C213.491 77.153 211.748 77.9151 210.305 79.1004C208.534 80.5474 207.284 82.5331 206.746 84.7554V84.8157L206.557 85.5697L206.271 84.861C205.405 82.7524 203.92 80.9566 202.011 79.7112C200.452 78.6901 198.659 78.0829 196.801 77.9468C195.535 77.8442 194.262 77.9486 193.031 78.2559C192.164 78.4671 191.696 78.6556 191.681 78.6179C191.666 78.5802 191.787 78.5425 192.005 78.4369C192.32 78.2902 192.645 78.1667 192.978 78.0674C194.519 77.5961 196.144 77.464 197.741 77.68C199.338 77.8961 200.869 78.4552 202.229 79.3191C204.237 80.6043 205.8 82.4759 206.708 84.68H206.233V84.6122C206.8 82.2804 208.126 80.2034 210.003 78.7083C211.523 77.4982 213.351 76.7381 215.281 76.5142C216.571 76.3657 217.878 76.4578 219.134 76.7856C219.474 76.8735 219.807 76.9869 220.129 77.1249C220.371 77.2531 220.484 77.3059 220.476 77.3285Z"
        fill="#263238"
      />
      <path
        d="M170.093 50.9141C170.093 50.9141 169.626 51.4569 168.774 52.4221C167.578 53.7821 166.499 55.2399 165.546 56.7802C162.381 61.8669 160.721 67.7464 160.759 73.7376C160.755 73.808 160.755 73.8784 160.759 73.9488H160.261C159.774 70.732 158.725 67.6259 157.162 64.7726C155.025 60.8528 152.008 57.4821 148.348 54.9253C147.788 54.5761 147.247 54.1986 146.727 53.7943C146.888 53.8521 147.042 53.928 147.187 54.0205C147.481 54.1864 147.941 54.4051 148.461 54.7745C149.986 55.7504 151.404 56.8853 152.691 58.16C157.013 62.3936 159.844 67.9156 160.759 73.896H160.261V73.6849C160.217 67.6027 161.952 61.6404 165.252 56.5314C166.238 54.9916 167.372 53.5522 168.638 52.2336C169.075 51.751 169.46 51.4268 169.701 51.193C169.825 51.0905 169.956 50.9973 170.093 50.9141Z"
        fill="#263238"
      />
      <path
        d="M399.197 300.223H196.688V304.913H399.197V300.223Z"
        fill="#E0E0E0"
      />
      <path
        d="M198.73 305.005C198.73 305.005 198.73 304.923 198.73 304.742C198.73 304.561 198.73 304.274 198.73 303.912C198.73 303.158 198.73 302.035 198.73 300.512V300.444H198.791C210.734 300.353 250.116 300.293 296.811 300.293L369.285 300.353L391.242 300.421L397.213 300.466L391.242 300.512L369.285 300.579L296.811 300.647C250.153 300.647 210.772 300.579 198.828 300.489L198.889 300.429C198.889 301.937 198.889 303.075 198.889 303.829C198.889 304.191 198.889 304.463 198.889 304.659C198.889 304.855 198.73 305.005 198.73 305.005Z"
        fill="#263238"
      />
      <path
        d="M222.844 300.555C223.135 302.023 223.135 303.535 222.844 305.003C222.552 303.535 222.552 302.023 222.844 300.555Z"
        fill="#263238"
      />
      <path
        d="M249.398 300.555C249.69 302.023 249.69 303.535 249.398 305.003C249.107 303.535 249.107 302.023 249.398 300.555Z"
        fill="#263238"
      />
      <path
        d="M275.953 300.555C276.245 302.023 276.245 303.535 275.953 305.003C275.661 303.535 275.661 302.023 275.953 300.555Z"
        fill="#263238"
      />
      <path
        d="M302.512 300.555C302.803 302.023 302.803 303.535 302.512 305.003C302.22 303.535 302.22 302.023 302.512 300.555Z"
        fill="#263238"
      />
      <path
        d="M329.066 300.555C329.358 302.023 329.358 303.535 329.066 305.003C328.775 303.535 328.775 302.023 329.066 300.555Z"
        fill="#263238"
      />
      <path
        d="M355.625 300.555C355.916 302.023 355.916 303.535 355.625 305.003C355.333 303.535 355.333 302.023 355.625 300.555Z"
        fill="#263238"
      />
      <path
        d="M382.148 300.555C382.44 302.023 382.44 303.535 382.148 305.003C381.857 303.535 381.857 302.023 382.148 300.555Z"
        fill="#263238"
      />
      <path
        d="M286.037 73.0664H232.375V299.998H286.037V73.0664Z"
        fill="#687981"
      />
      <path
        d="M258.622 84.3906H242.312V115.817H258.622V84.3906Z"
        fill="white"
      />
      <path
        d="M250.953 115.825C250.832 115.825 250.734 108.783 250.734 100.104C250.734 91.4254 250.832 84.3906 250.953 84.3906C251.074 84.3906 251.164 91.4254 251.164 100.104C251.164 108.783 251.051 115.825 250.953 115.825Z"
        fill="#263238"
      />
      <path
        d="M258.622 95.3084C255.91 95.5268 253.19 95.5998 250.471 95.5271C247.749 95.5998 245.026 95.5268 242.312 95.3084C245.026 95.09 247.749 95.017 250.471 95.0897C253.19 95.017 255.91 95.09 258.622 95.3084Z"
        fill="#263238"
      />
      <path
        d="M258.71 106.551C255.974 106.769 253.228 106.842 250.484 106.769C247.743 106.842 244.999 106.769 242.266 106.551C244.999 106.332 247.743 106.259 250.484 106.332C253.228 106.259 255.974 106.332 258.71 106.551Z"
        fill="#263238"
      />
      <path d="M258.688 125.863H242.379V157.29H258.688V125.863Z" fill="white" />
      <path
        d="M250.992 157.294C250.871 157.294 250.773 150.259 250.773 141.581C250.773 132.902 250.871 125.867 250.992 125.867C251.113 125.867 251.211 132.902 251.211 141.581C251.211 150.259 251.113 157.294 250.992 157.294Z"
        fill="#263238"
      />
      <path
        d="M258.688 136.781C255.974 136.999 253.251 137.072 250.53 137C247.811 137.072 245.09 136.999 242.379 136.781C245.09 136.563 247.811 136.49 250.53 136.562C253.251 136.49 255.974 136.563 258.688 136.781Z"
        fill="#263238"
      />
      <path
        d="M258.773 148.023C256.039 148.242 253.296 148.315 250.554 148.242C247.81 148.315 245.064 148.242 242.328 148.023C245.064 147.805 247.81 147.732 250.554 147.805C253.296 147.732 256.039 147.805 258.773 148.023Z"
        fill="#263238"
      />
      <path
        d="M258.688 166.969H242.379V198.395H258.688V166.969Z"
        fill="white"
      />
      <path
        d="M250.992 198.395C250.871 198.395 250.773 191.361 250.773 182.682C250.773 174.004 250.871 166.969 250.992 166.969C251.113 166.969 251.211 174.004 251.211 182.682C251.211 191.361 251.113 198.395 250.992 198.395Z"
        fill="#263238"
      />
      <path
        d="M258.688 177.887C255.974 178.105 253.251 178.178 250.53 178.105C247.811 178.178 245.09 178.105 242.379 177.887C245.09 177.668 247.811 177.595 250.53 177.668C253.251 177.595 255.974 177.668 258.688 177.887Z"
        fill="#263238"
      />
      <path
        d="M258.773 189.129C256.039 189.347 253.296 189.42 250.554 189.347C247.81 189.42 245.064 189.347 242.328 189.129C245.064 188.91 247.81 188.837 250.554 188.91C253.296 188.837 256.039 188.91 258.773 189.129Z"
        fill="#263238"
      />
      <path
        d="M258.688 209.262H242.379V240.688H258.688V209.262Z"
        fill="white"
      />
      <path
        d="M250.992 240.696C250.871 240.696 250.773 233.661 250.773 224.983C250.773 216.304 250.871 209.262 250.992 209.262C251.113 209.262 251.211 216.297 251.211 224.983C251.211 233.669 251.113 240.696 250.992 240.696Z"
        fill="#263238"
      />
      <path
        d="M258.688 220.178C255.974 220.396 253.251 220.469 250.53 220.396C247.811 220.469 245.09 220.396 242.379 220.178C245.09 219.969 247.811 219.898 250.53 219.967C253.251 219.899 255.974 219.969 258.688 220.178Z"
        fill="#263238"
      />
      <path
        d="M258.773 231.422C256.039 231.64 253.296 231.713 250.554 231.64C247.81 231.713 245.064 231.64 242.328 231.422C245.064 231.203 247.81 231.13 250.554 231.203C253.296 231.13 256.039 231.203 258.773 231.422Z"
        fill="#263238"
      />
      <path
        d="M308.86 73.0664H269.758V299.998H308.86V73.0664Z"
        fill="#687981"
      />
      <g opacity="0.3">
        <path
          d="M308.86 73.0664H269.758V299.998H308.86V73.0664Z"
          fill="black"
        />
      </g>
      <path
        d="M297.164 84.3906H280.855V115.817H297.164V84.3906Z"
        fill="white"
      />
      <path
        d="M289.476 115.825C289.356 115.825 289.258 108.783 289.258 100.104C289.258 91.4254 289.356 84.3906 289.476 84.3906C289.597 84.3906 289.695 91.4254 289.695 100.104C289.695 108.783 289.597 115.825 289.476 115.825Z"
        fill="#263238"
      />
      <path
        d="M297.164 95.3084C294.453 95.5268 291.733 95.5998 289.014 95.5271C286.292 95.5998 283.569 95.5268 280.855 95.3084C283.569 95.09 286.292 95.017 289.014 95.0897C291.733 95.017 294.453 95.09 297.164 95.3084Z"
        fill="#263238"
      />
      <path
        d="M297.257 106.551C294.521 106.769 291.775 106.842 289.031 106.769C286.29 106.842 283.546 106.769 280.812 106.551C283.546 106.332 286.29 106.259 289.031 106.332C291.775 106.259 294.521 106.332 297.257 106.551Z"
        fill="#263238"
      />
      <path
        d="M297.231 127.047H280.922V158.474H297.231V127.047Z"
        fill="white"
      />
      <path
        d="M289.535 158.481C289.414 158.481 289.316 151.439 289.316 142.76C289.316 134.082 289.414 127.047 289.535 127.047C289.656 127.047 289.754 134.082 289.754 142.76C289.754 151.439 289.656 158.481 289.535 158.481Z"
        fill="#263238"
      />
      <path
        d="M297.231 137.965C294.517 138.183 291.794 138.256 289.073 138.183C286.354 138.256 283.633 138.183 280.922 137.965C283.633 137.746 286.354 137.673 289.073 137.746C291.794 137.673 294.517 137.746 297.231 137.965Z"
        fill="#263238"
      />
      <path
        d="M297.316 149.207C294.582 149.425 291.839 149.498 289.097 149.426C286.353 149.498 283.607 149.425 280.871 149.207C283.607 148.988 286.353 148.915 289.097 148.988C291.839 148.916 294.582 148.989 297.316 149.207Z"
        fill="#263238"
      />
      <path
        d="M297.231 166.969H280.922V198.395H297.231V166.969Z"
        fill="white"
      />
      <path
        d="M289.535 198.395C289.414 198.395 289.316 191.361 289.316 182.682C289.316 174.004 289.414 166.969 289.535 166.969C289.656 166.969 289.754 174.004 289.754 182.682C289.754 191.361 289.656 198.395 289.535 198.395Z"
        fill="#263238"
      />
      <path
        d="M297.231 177.887C294.517 178.105 291.794 178.178 289.073 178.105C286.354 178.178 283.633 178.105 280.922 177.887C283.633 177.668 286.354 177.595 289.073 177.668C291.794 177.595 294.517 177.668 297.231 177.887Z"
        fill="#263238"
      />
      <path
        d="M297.316 189.129C294.582 189.347 291.839 189.42 289.097 189.347C286.353 189.42 283.607 189.347 280.871 189.129C283.607 188.91 286.353 188.837 289.097 188.91C291.839 188.837 294.582 188.91 297.316 189.129Z"
        fill="#263238"
      />
      <path
        d="M297.895 209.949H281.586V241.376H297.895V209.949Z"
        fill="white"
      />
      <path
        d="M290.199 241.376C290.079 241.376 289.988 234.341 289.988 225.663C289.988 216.984 290.079 209.949 290.199 209.949C290.32 209.949 290.418 216.984 290.418 225.663C290.418 234.341 290.32 241.376 290.199 241.376Z"
        fill="#263238"
      />
      <path
        d="M297.895 220.867C295.184 221.085 292.463 221.158 289.744 221.086C287.023 221.158 284.3 221.085 281.586 220.867C284.3 220.649 287.023 220.576 289.744 220.648C292.463 220.576 295.184 220.649 297.895 220.867Z"
        fill="#263238"
      />
      <path
        d="M297.98 232.109C295.246 232.327 292.503 232.4 289.762 232.328C287.02 232.4 284.277 232.327 281.543 232.109C284.277 231.891 287.02 231.818 289.762 231.89C292.503 231.818 295.246 231.891 297.98 232.109Z"
        fill="#263238"
      />
      <path
        d="M258.688 252.555H242.379V283.981H258.688V252.555Z"
        fill="white"
      />
      <path
        d="M250.992 283.969C250.871 283.969 250.773 276.927 250.773 268.249C250.773 259.57 250.871 252.535 250.992 252.535C251.113 252.535 251.211 259.57 251.211 268.249C251.211 276.927 251.113 283.969 250.992 283.969Z"
        fill="#263238"
      />
      <path
        d="M258.688 263.472C255.974 263.691 253.251 263.764 250.53 263.691C247.811 263.764 245.09 263.691 242.379 263.472C245.09 263.254 247.811 263.181 250.53 263.254C253.251 263.181 255.974 263.254 258.688 263.472Z"
        fill="#263238"
      />
      <path
        d="M258.773 274.715C256.039 274.933 253.296 275.006 250.554 274.933C247.81 275.006 245.064 274.933 242.328 274.715C245.064 274.496 247.81 274.423 250.554 274.496C253.296 274.423 256.039 274.496 258.773 274.715Z"
        fill="#263238"
      />
      <path
        d="M297.231 253.906H280.922V285.333H297.231V253.906Z"
        fill="white"
      />
      <path
        d="M289.535 285.333C289.414 285.333 289.316 278.298 289.316 269.62C289.316 260.941 289.414 253.906 289.535 253.906C289.656 253.906 289.754 260.941 289.754 269.62C289.754 278.298 289.656 285.333 289.535 285.333Z"
        fill="#263238"
      />
      <path
        d="M297.231 264.824C294.517 265.042 291.794 265.115 289.073 265.043C286.354 265.115 283.633 265.042 280.922 264.824C283.633 264.606 286.354 264.533 289.073 264.605C291.794 264.533 294.517 264.606 297.231 264.824Z"
        fill="#263238"
      />
      <path
        d="M297.316 276.066C294.582 276.285 291.839 276.358 289.097 276.285C286.353 276.358 283.607 276.285 280.871 276.066C283.607 275.848 286.353 275.775 289.097 275.848C291.839 275.775 294.582 275.848 297.316 276.066Z"
        fill="#263238"
      />
      <path
        d="M335.566 198.977H354.582V171.493H335.566V198.977Z"
        fill={theme.palette.primary.main}
      />
      <g opacity="0.3">
        <path
          d="M335.566 198.977H354.582V171.493H335.566V198.977Z"
          fill="black"
        />
      </g>
      <path
        d="M318.461 198.977H337.477V171.493H318.461V198.977Z"
        fill={theme.palette.primary.main}
      />
      <path
        d="M322.998 193.426C322.998 193.426 322.998 193.336 322.998 193.147C322.998 192.959 322.998 192.649 322.998 192.303C322.998 191.549 322.998 190.44 322.998 189.075C322.998 186.278 322.96 182.35 322.93 177.765V177.652H331.631L331.767 177.796V182.176C331.767 183.601 331.767 184.974 331.767 186.301C331.767 188.94 331.767 191.353 331.767 193.441V193.547H331.631L325.29 193.494H323.578H323.141C323.043 193.494 322.998 193.494 322.998 193.494H323.163H323.623H325.358L331.631 193.441L331.525 193.539C331.525 191.451 331.525 189.015 331.525 186.399C331.525 185.072 331.525 183.699 331.525 182.274V177.894C331.405 177.765 331.691 178.052 331.661 178.022H322.998L323.126 177.894C323.126 182.418 323.081 186.338 323.065 189.121C323.065 190.493 323.065 191.594 323.028 192.37C323.028 192.732 323.028 193.026 323.028 193.245C323.022 193.306 323.012 193.366 322.998 193.426Z"
        fill="#263238"
      />
      <path
        d="M324.723 186.447C324.723 186.447 324.934 186.447 325.04 186.665C325.071 186.74 325.083 186.821 325.075 186.901C325.067 186.981 325.039 187.058 324.995 187.125C324.928 187.205 324.838 187.262 324.738 187.289C324.637 187.317 324.531 187.313 324.433 187.279C324.335 187.245 324.249 187.181 324.188 187.097C324.127 187.013 324.093 186.912 324.09 186.808C324.098 186.727 324.126 186.65 324.171 186.581C324.215 186.513 324.275 186.457 324.346 186.416C324.587 186.288 324.753 186.416 324.723 186.416C324.693 186.416 324.58 186.416 324.452 186.545C324.413 186.571 324.382 186.609 324.364 186.653C324.345 186.696 324.34 186.744 324.348 186.791C324.356 186.838 324.377 186.881 324.408 186.916C324.44 186.952 324.481 186.977 324.527 186.989C324.761 187.08 324.889 186.869 324.851 186.688C324.814 186.507 324.716 186.484 324.723 186.447Z"
        fill="#263238"
      />
      <path
        d="M299.081 300.172H377.941V193.88H299.081V300.172Z"
        fill={theme.palette.primary.main}
      />
      <path
        d="M346.363 300.171L388.663 300.223V193.887H346.363V300.171Z"
        fill={theme.palette.primary.main}
      />
      <g opacity="0.3">
        <path
          d="M346.363 300.171L388.663 300.223V193.887H346.363V300.171Z"
          fill="black"
        />
      </g>
      <path
        d="M304.873 265.977H319.297V251.553H304.873V265.977Z"
        fill="#EBEBEB"
      />
      <path
        d="M311.53 267.424C311.455 267.424 311.395 263.692 311.395 259.13C311.395 254.568 311.455 250.836 311.53 250.836C311.606 250.836 311.666 254.561 311.666 259.13C311.666 263.699 311.606 267.424 311.53 267.424Z"
        fill="#687981"
      />
      <path
        d="M302.164 256.386C302.164 256.31 306.356 256.25 311.529 256.25C316.701 256.25 320.901 256.31 320.901 256.386C320.901 256.461 316.709 256.521 311.529 256.521C306.349 256.521 302.164 256.461 302.164 256.386Z"
        fill="#687981"
      />
      <path
        d="M325.447 265.977H339.871V251.553H325.447V265.977Z"
        fill="#EBEBEB"
      />
      <path
        d="M332.104 267.424C332.029 267.424 331.961 263.692 331.961 259.13C331.961 254.568 332.029 250.836 332.104 250.836C332.18 250.836 332.24 254.561 332.24 259.13C332.24 263.699 332.18 267.424 332.104 267.424Z"
        fill="#687981"
      />
      <path
        d="M322.734 256.386C322.734 256.31 326.927 256.25 332.099 256.25C337.271 256.25 341.471 256.31 341.471 256.386C341.471 256.461 337.279 256.521 332.099 256.521C326.919 256.521 322.734 256.461 322.734 256.386Z"
        fill="#687981"
      />
      <path
        d="M304.873 243.191H319.297V228.767H304.873V243.191Z"
        fill="#EBEBEB"
      />
      <path
        d="M311.53 244.639C311.455 244.639 311.395 240.906 311.395 236.345C311.395 231.783 311.455 228.051 311.53 228.051C311.606 228.051 311.666 231.776 311.666 236.345C311.666 240.914 311.606 244.639 311.53 244.639Z"
        fill="#687981"
      />
      <path
        d="M302.164 233.601C302.164 233.525 306.356 233.465 311.529 233.465C316.701 233.465 320.901 233.525 320.901 233.601C320.901 233.676 316.709 233.736 311.529 233.736C306.349 233.736 302.164 233.676 302.164 233.601Z"
        fill="#687981"
      />
      <path
        d="M325.447 243.191H339.871V228.767H325.447V243.191Z"
        fill="#EBEBEB"
      />
      <path
        d="M332.104 244.639C332.029 244.639 331.961 240.906 331.961 236.345C331.961 231.783 332.029 228.051 332.104 228.051C332.18 228.051 332.24 231.776 332.24 236.345C332.24 240.914 332.18 244.639 332.104 244.639Z"
        fill="#687981"
      />
      <path
        d="M322.734 233.601C322.734 233.525 326.927 233.465 332.099 233.465C337.271 233.465 341.471 233.525 341.471 233.601C341.471 233.676 337.279 233.736 332.099 233.736C326.919 233.736 322.734 233.676 322.734 233.601Z"
        fill="#687981"
      />
      <path
        d="M304.873 220.344H319.297V205.92H304.873V220.344Z"
        fill="#EBEBEB"
      />
      <path
        d="M311.53 221.799C311.455 221.799 311.395 218.067 311.395 213.505C311.395 208.943 311.455 205.211 311.53 205.211C311.606 205.211 311.666 208.936 311.666 213.505C311.666 218.074 311.606 221.799 311.53 221.799Z"
        fill="#687981"
      />
      <path
        d="M302.164 210.761C302.164 210.685 306.356 210.625 311.529 210.625C316.701 210.625 320.901 210.685 320.901 210.761C320.901 210.836 316.709 210.896 311.529 210.896C306.349 210.896 302.164 210.829 302.164 210.761Z"
        fill="#687981"
      />
      <path
        d="M325.447 220.344H339.871V205.92H325.447V220.344Z"
        fill="#EBEBEB"
      />
      <path
        d="M332.104 221.799C332.029 221.799 331.961 218.067 331.961 213.505C331.961 208.943 332.029 205.211 332.104 205.211C332.18 205.211 332.24 208.936 332.24 213.505C332.24 218.074 332.18 221.799 332.104 221.799Z"
        fill="#687981"
      />
      <path
        d="M322.734 210.761C322.734 210.685 326.927 210.625 332.099 210.625C337.271 210.625 341.471 210.685 341.471 210.761C341.471 210.836 337.279 210.896 332.099 210.896C326.919 210.896 322.734 210.829 322.734 210.761Z"
        fill="#687981"
      />
      <g opacity="0.7">
        <path
          d="M360.849 220.348H375.273V205.924H360.849V220.348Z"
          fill="white"
        />
      </g>
      <path
        d="M368.065 221.799C367.99 221.799 367.93 218.067 367.93 213.505C367.93 208.943 367.99 205.211 368.065 205.211C368.141 205.211 368.201 208.936 368.201 213.505C368.201 218.074 368.141 221.799 368.065 221.799Z"
        fill="#263238"
      />
      <path
        d="M358.141 210.761C358.141 210.685 362.34 210.625 367.513 210.625C372.685 210.625 376.878 210.685 376.878 210.761C376.878 210.836 372.685 210.896 367.513 210.896C362.34 210.896 358.141 210.829 358.141 210.761Z"
        fill="#263238"
      />
      <g opacity="0.7">
        <path
          d="M360.849 243.41H375.273V228.986H360.849V243.41Z"
          fill="white"
        />
      </g>
      <path
        d="M368.065 244.865C367.99 244.865 367.93 241.133 367.93 236.571C367.93 232.01 367.99 228.277 368.065 228.277C368.141 228.277 368.201 232.002 368.201 236.571C368.201 241.141 368.141 244.865 368.065 244.865Z"
        fill="#263238"
      />
      <path
        d="M358.141 233.827C358.141 233.752 362.34 233.691 367.513 233.691C372.685 233.691 376.878 233.752 376.878 233.827C376.878 233.903 372.685 233.963 367.513 233.963C362.34 233.963 358.141 233.903 358.141 233.827Z"
        fill="#263238"
      />
      <g opacity="0.7">
        <path
          d="M360.849 266.484H375.273V252.06H360.849V266.484Z"
          fill="white"
        />
      </g>
      <path
        d="M368.065 267.924C367.99 267.924 367.93 264.199 367.93 259.63C367.93 255.061 367.99 251.336 368.065 251.336C368.141 251.336 368.201 255.068 368.201 259.63C368.201 264.192 368.141 267.924 368.065 267.924Z"
        fill="#263238"
      />
      <path
        d="M358.141 256.894C358.141 256.818 362.34 256.758 367.513 256.758C372.685 256.758 376.878 256.818 376.878 256.894C376.878 256.969 372.685 257.029 367.513 257.029C362.34 257.029 358.141 256.969 358.141 256.894Z"
        fill="#263238"
      />
      <path
        d="M315.411 299.696C315.411 299.696 315.411 299.651 315.411 299.568C315.411 299.485 315.411 299.342 315.411 299.184C315.411 298.827 315.411 298.337 315.411 297.713C315.411 296.409 315.411 294.547 315.373 292.224C315.373 287.527 315.373 280.982 315.32 273.48V273.352H330.4V273.48C330.4 281.02 330.4 287.647 330.355 292.39C330.355 294.735 330.355 296.62 330.355 297.932C330.355 298.573 330.355 299.063 330.355 299.44C330.355 299.598 330.355 299.726 330.355 299.824C330.355 299.923 330.355 299.953 330.355 299.953C330.352 299.91 330.352 299.867 330.355 299.824C330.355 299.726 330.355 299.598 330.355 299.44C330.355 299.078 330.355 298.588 330.355 297.932C330.355 296.62 330.355 294.735 330.355 292.39C330.355 287.647 330.355 281.042 330.31 273.48L330.438 273.615H315.66L315.795 273.48C315.795 281.02 315.758 287.527 315.743 292.224C315.743 294.547 315.743 296.409 315.705 297.713C315.705 298.342 315.705 298.832 315.705 299.184C315.705 299.342 315.705 299.47 315.705 299.568C315.705 299.666 315.411 299.696 315.411 299.696Z"
        fill="#263238"
      />
      <path
        d="M323.299 287.098H328.336V275.041H323.299V287.098Z"
        fill="#E0E0E0"
      />
      <path
        d="M328.352 287.111H323.285V275.047H328.352V287.111ZM323.308 287.111H328.322V275.047H323.338L323.308 287.111Z"
        fill="#263238"
      />
      <path
        d="M317.276 287.098H322.312V275.041H317.276V287.098Z"
        fill="#E0E0E0"
      />
      <path
        d="M322.325 287.111H317.258V275.047H322.325V287.111ZM317.28 287.111H322.295V275.047H317.303L317.28 287.111Z"
        fill="#263238"
      />
      <path
        d="M317.169 288.347C317.169 288.385 316.92 288.385 316.807 288.671C316.774 288.747 316.756 288.83 316.756 288.913C316.756 288.996 316.774 289.078 316.807 289.154C316.855 289.237 316.927 289.304 317.012 289.347C317.098 289.39 317.195 289.407 317.29 289.395C317.383 289.369 317.466 289.317 317.53 289.245C317.594 289.172 317.637 289.083 317.652 288.988C317.666 288.907 317.658 288.824 317.628 288.747C317.599 288.67 317.55 288.602 317.486 288.551C317.245 288.355 317.018 288.4 317.011 288.362C317.003 288.324 317.245 288.181 317.599 288.4C317.703 288.464 317.786 288.556 317.84 288.665C317.893 288.775 317.914 288.897 317.901 289.018C317.901 289.182 317.843 289.341 317.737 289.467C317.631 289.592 317.483 289.676 317.321 289.703C317.16 289.73 316.993 289.699 316.852 289.615C316.711 289.531 316.604 289.4 316.551 289.244C316.505 289.134 316.485 289.014 316.494 288.895C316.504 288.776 316.541 288.66 316.604 288.558C316.642 288.489 316.694 288.429 316.758 288.382C316.822 288.335 316.895 288.302 316.973 288.287C317.116 288.302 317.169 288.325 317.169 288.347Z"
        fill="#263238"
      />
      <path
        d="M301.667 273.48C301.663 273.425 301.663 273.37 301.667 273.315C301.667 273.171 301.667 273.005 301.667 272.809C301.667 272.312 301.667 271.671 301.667 270.887H301.704H310.119L310.172 270.94V273.563H310.119H304.087H302.33H304.102H310.134L310.081 273.616V271.045C310.187 271.158 310.081 271.045 310.134 271.105H301.719V271.068C301.719 271.822 301.719 272.478 301.719 272.968C301.719 273.164 301.719 273.337 301.719 273.48C301.719 273.624 301.667 273.48 301.667 273.48Z"
        fill="#263238"
      />
      <path
        d="M334.405 268.132C334.402 268.074 334.402 268.016 334.405 267.958C334.405 267.815 334.405 267.649 334.405 267.453C334.405 266.963 334.405 266.322 334.405 265.538V265.5H334.442H342.857C342.857 265.5 342.804 265.44 342.91 265.553V268.192H342.857H336.825H335.068H336.833H342.865L342.812 268.253V265.666L342.865 265.719H334.45C334.45 266.473 334.45 267.129 334.45 267.612C334.45 267.815 334.45 267.981 334.45 268.124C334.45 268.268 334.405 268.132 334.405 268.132Z"
        fill="#263238"
      />
      <path
        d="M339.652 247.023C339.652 247.023 339.652 246.971 339.652 246.858V246.352C339.652 245.862 339.652 245.221 339.652 244.43H348.067L348.127 244.482V247.106H348.075H342.043H340.286H342.05H348.082L348.029 247.159C348.029 246.752 348.029 246.322 348.029 245.892V244.588C348.142 244.701 348.029 244.588 348.082 244.648H339.667L339.705 244.611C339.705 245.365 339.705 246.028 339.705 246.511V247.023C339.688 247.024 339.67 247.024 339.652 247.023Z"
        fill="#263238"
      />
      <path
        d="M309.395 224.328V224.155C309.395 224.011 309.395 223.846 309.395 223.65C309.395 223.159 309.395 222.519 309.395 221.734H317.817L317.869 221.787V224.404H317.817H311.785H310.028H311.792H317.824L317.771 224.464C317.771 224.049 317.771 223.627 317.771 223.19V221.878L317.832 221.93H309.41H309.447C309.447 222.684 309.447 223.34 309.447 223.823V224.336C309.402 224.26 309.395 224.328 309.395 224.328Z"
        fill="#263238"
      />
      <path
        d="M333.35 200.094C333.347 200.039 333.347 199.983 333.35 199.928C333.35 199.785 333.35 199.619 333.35 199.423C333.35 198.92 333.35 198.279 333.35 197.5H341.765L341.818 197.553V200.177H341.765H335.733H333.976H335.74H341.772L341.72 200.229V197.658C341.825 197.771 341.72 197.658 341.772 197.719H333.358V197.681C333.358 198.435 333.358 199.098 333.358 199.581C333.358 199.777 333.358 199.95 333.358 200.094C333.358 200.237 333.35 200.094 333.35 200.094Z"
        fill="#263238"
      />
      <path
        d="M304.299 226.832C304.296 226.776 304.296 226.721 304.299 226.666V226.16C304.299 225.67 304.299 225.029 304.299 224.245V224.208H304.337H312.752C312.752 224.208 312.699 224.155 312.812 224.268V225.572C312.812 226.01 312.812 226.432 312.812 226.839V226.892H312.759H306.727H304.978H306.742H312.774L312.722 226.945V224.373L312.774 224.426H304.36H304.397C304.397 225.18 304.397 225.836 304.397 226.319C304.397 226.522 304.397 226.688 304.397 226.832C304.365 226.833 304.332 226.833 304.299 226.832Z"
        fill="#263238"
      />
      <path
        d="M343.266 249.563C343.266 249.563 343.266 249.51 343.266 249.397C343.266 249.284 343.266 249.088 343.266 248.891C343.266 248.394 343.266 247.753 343.266 246.969H351.68L351.741 247.022V248.326C351.741 248.756 351.741 249.178 351.741 249.593V249.645H351.688H345.656H343.907H345.671H351.703L351.65 249.698V247.022L351.703 247.074H343.288L343.326 247.037C343.326 247.811 343.326 248.444 343.326 248.937C343.326 249.133 343.326 249.299 343.326 249.449C343.326 249.6 343.266 249.563 343.266 249.563Z"
        fill="#263238"
      />
      <path
        d="M339.652 202.688C339.652 202.688 339.652 202.635 339.652 202.522V202.016C339.652 201.519 339.652 200.878 339.652 200.094H348.067L348.127 200.147V202.77H348.075H342.043H340.286H342.05H348.082L348.029 202.823C348.029 202.409 348.029 201.986 348.029 201.557V200.252L348.082 200.305H339.667L339.705 200.267C339.705 201.046 339.705 201.68 339.705 202.167V202.537C339.66 202.62 339.652 202.688 339.652 202.688Z"
        fill="#263238"
      />
      <path
        d="M298.94 276.074C298.937 276.019 298.937 275.964 298.94 275.908C298.94 275.765 298.94 275.599 298.94 275.403C298.94 274.913 298.94 274.272 298.94 273.48H298.978H307.392L307.445 273.533V276.157H307.392H301.36H299.604H301.375H307.407L307.355 276.21V274.943C307.355 274.725 307.355 274.506 307.355 274.287V273.639L307.415 273.699H299V273.661C299 274.415 299 275.079 299 275.562C299 275.758 299 275.931 299 276.074H298.94Z"
        fill="#263238"
      />
      <path
        d="M371.897 103.23H299.234V153.809H326.409L335.683 163.89L344.912 153.809H371.897V103.23Z"
        fill="white"
      />
      <path
        d="M335.272 71.6841C332.451 71.747 329.702 72.5799 327.32 74.0927C324.939 75.6055 323.016 77.7406 321.761 80.2671C320.505 82.7936 319.965 85.6153 320.197 88.427C320.43 91.2386 321.426 93.9332 323.08 96.2193L323.23 96.4228L334.201 111.299C334.425 111.603 334.718 111.848 335.057 112.014C335.395 112.181 335.768 112.263 336.145 112.255C336.522 112.247 336.892 112.148 337.223 111.968C337.553 111.787 337.836 111.529 338.047 111.216L347.954 96.4907C349.824 93.633 351.113 90.6472 351.113 87.126C351.11 85.0653 350.695 83.026 349.893 81.1278C349.09 79.2297 347.917 77.5109 346.441 76.0725C344.965 74.6341 343.217 73.5049 341.299 72.7513C339.381 71.9977 337.332 71.6349 335.272 71.6841ZM335.641 98.4059C333.34 98.4059 331.091 97.7235 329.178 96.4451C327.264 95.1668 325.773 93.3497 324.893 91.2239C324.012 89.098 323.782 86.7587 324.231 84.5019C324.68 82.2451 325.788 80.1721 327.415 78.545C329.042 76.9179 331.115 75.8099 333.372 75.361C335.628 74.9121 337.968 75.1425 340.093 76.023C342.219 76.9036 344.036 78.3948 345.315 80.308C346.593 82.2213 347.275 84.4706 347.275 86.7716C347.275 89.8572 346.05 92.8164 343.868 94.9983C341.686 97.1801 338.727 98.4059 335.641 98.4059Z"
        fill={theme.palette.primary.main}
      />
      <g opacity="0.3">
        <path
          d="M335.272 71.6841C332.451 71.747 329.702 72.5799 327.32 74.0927C324.939 75.6055 323.016 77.7406 321.761 80.2671C320.505 82.7936 319.965 85.6153 320.197 88.427C320.43 91.2386 321.426 93.9332 323.08 96.2193L323.23 96.4228L334.201 111.299C334.425 111.603 334.718 111.848 335.057 112.014C335.395 112.181 335.768 112.263 336.145 112.255C336.522 112.247 336.892 112.148 337.223 111.968C337.553 111.787 337.836 111.529 338.047 111.216L347.954 96.4907C349.824 93.633 351.113 90.6472 351.113 87.126C351.11 85.0653 350.695 83.026 349.893 81.1278C349.09 79.2297 347.917 77.5109 346.441 76.0725C344.965 74.6341 343.217 73.5049 341.299 72.7513C339.381 71.9977 337.332 71.6349 335.272 71.6841ZM335.641 98.4059C333.34 98.4059 331.091 97.7235 329.178 96.4451C327.264 95.1668 325.773 93.3497 324.893 91.2239C324.012 89.098 323.782 86.7587 324.231 84.5019C324.68 82.2451 325.788 80.1721 327.415 78.545C329.042 76.9179 331.115 75.8099 333.372 75.361C335.628 74.9121 337.968 75.1425 340.093 76.023C342.219 76.9036 344.036 78.3948 345.315 80.308C346.593 82.2213 347.275 84.4706 347.275 86.7716C347.275 89.8572 346.05 92.8164 343.868 94.9983C341.686 97.1801 338.727 98.4059 335.641 98.4059Z"
          fill="black"
        />
      </g>
      <path
        d="M334.354 71.6841C331.533 71.747 328.784 72.5799 326.402 74.0927C324.021 75.6055 322.098 77.7406 320.843 80.2671C319.588 82.7936 319.047 85.6153 319.279 88.427C319.512 91.2386 320.508 93.9332 322.162 96.2193L322.312 96.4228L333.283 111.299C333.508 111.603 333.802 111.848 334.141 112.014C334.48 112.181 334.854 112.263 335.231 112.255C335.609 112.247 335.979 112.148 336.31 111.968C336.642 111.787 336.925 111.529 337.136 111.216L347.036 96.4907C348.914 93.633 350.195 90.6472 350.195 87.126C350.192 85.0653 349.777 83.026 348.975 81.1278C348.172 79.2297 346.999 77.5109 345.523 76.0725C344.047 74.6341 342.299 73.5049 340.381 72.7513C338.463 71.9977 336.414 71.6349 334.354 71.6841ZM334.723 96.3097C332.98 96.3112 331.275 95.7955 329.824 94.8279C328.374 93.8603 327.243 92.4842 326.575 90.8738C325.906 89.2633 325.731 87.4908 326.07 85.7805C326.409 84.0702 327.248 82.499 328.48 81.2655C329.713 80.0321 331.283 79.1919 332.993 78.8511C334.703 78.5104 336.476 78.6845 338.087 79.3515C339.698 80.0184 341.075 81.1481 342.044 82.5978C343.013 84.0474 343.53 85.7519 343.53 87.4955C343.53 89.8319 342.602 92.0727 340.951 93.7254C339.3 95.3782 337.06 96.3077 334.723 96.3097Z"
        fill={theme.palette.primary.main}
      />
      <path
        d="M348.083 124.626C348.083 124.731 340.905 124.822 332.045 124.822C323.186 124.822 316 124.731 316 124.626C316 124.52 323.186 124.43 332.045 124.43C340.905 124.43 348.083 124.513 348.083 124.626Z"
        fill="black"
      />
      <path
        d="M346.378 131.052C346.378 131.157 340.444 131.248 333.123 131.248C325.801 131.248 319.875 131.157 319.875 131.052C319.875 130.946 325.809 130.855 333.123 130.855C340.437 130.855 346.378 130.946 346.378 131.052Z"
        fill="black"
      />
      <path
        d="M349.026 137.731C349.026 137.844 344.615 137.927 339.179 137.927C333.743 137.927 329.324 137.844 329.324 137.731C329.324 137.618 333.735 137.535 339.179 137.535C344.623 137.535 349.026 137.626 349.026 137.731Z"
        fill="black"
      />
      <path
        d="M364.19 145.458C364.19 145.571 357.404 145.654 349.027 145.654C340.65 145.654 333.895 145.571 333.895 145.458C333.895 145.345 340.681 145.262 349.057 145.262C357.434 145.262 364.19 145.352 364.19 145.458Z"
        fill="black"
      />
      <path
        d="M113.447 342.606H40L44.1319 338.527H115.86L113.447 342.606Z"
        fill="#E0E0E0"
      />
      <path
        d="M175.141 256.535C175.602 256.311 176.042 256.043 176.453 255.736C177.244 255.208 178.323 254.469 179.469 253.632L180.064 253.21L179.846 253.157C180.479 254.265 181.044 255.238 181.467 255.924C181.677 256.31 181.93 256.672 182.221 257.002C182.085 256.59 181.9 256.195 181.67 255.826C181.301 255.11 180.758 254.115 180.162 253.006L180.072 252.855L179.936 252.953L179.333 253.376C178.157 254.213 177.071 254.982 176.317 255.555C175.891 255.838 175.496 256.167 175.141 256.535Z"
        fill="#263238"
      />
      <path
        d="M262.006 339.856C262.96 326.235 252.691 314.42 239.069 313.466C225.448 312.513 213.633 322.782 212.68 336.403C211.726 350.024 221.995 361.839 235.616 362.793C249.238 363.746 261.053 353.477 262.006 339.856Z"
        fill="#263238"
      />
      <path
        d="M211.61 337.676V337.744C211.581 344.242 214.118 350.489 218.67 355.127C223.222 359.766 229.42 362.42 235.918 362.513C242.416 362.607 248.688 360.132 253.372 355.626C258.055 351.121 260.771 344.949 260.929 338.452C260.929 338.452 260.929 338.407 260.929 338.392L211.61 337.676Z"
        fill="#263238"
      />
      <path
        d="M218.955 337.85C218.9 341.281 219.865 344.653 221.727 347.536C223.589 350.419 226.265 352.685 229.416 354.046C232.567 355.408 236.051 355.804 239.427 355.184C242.803 354.564 245.919 352.957 248.38 350.565C250.842 348.173 252.538 345.104 253.255 341.748C253.972 338.391 253.676 334.897 252.406 331.708C251.135 328.52 248.947 325.78 246.119 323.836C243.29 321.891 239.948 320.83 236.516 320.787C231.927 320.728 227.502 322.491 224.21 325.69C220.918 328.888 219.029 333.261 218.955 337.85Z"
        fill="#FAFAFA"
      />
      <path
        d="M236.514 320.787C231.925 320.728 227.499 322.491 224.208 325.69C220.916 328.888 219.027 333.261 218.953 337.85L253.577 338.347C253.635 333.758 251.872 329.333 248.674 326.041C245.475 322.75 241.103 320.86 236.514 320.787Z"
        fill="#E0E0E0"
      />
      <path
        d="M225.716 337.946C225.685 340.034 226.274 342.084 227.408 343.837C228.543 345.591 230.172 346.968 232.089 347.795C234.007 348.623 236.127 348.863 238.18 348.485C240.234 348.107 242.13 347.128 243.628 345.673C245.125 344.218 246.158 342.351 246.594 340.308C247.03 338.266 246.851 336.14 246.079 334.2C245.307 332.26 243.976 330.592 242.256 329.408C240.536 328.224 238.503 327.576 236.415 327.548C233.618 327.51 230.92 328.583 228.914 330.533C226.908 332.482 225.758 335.148 225.716 337.946Z"
        fill="#263238"
      />
      <path
        d="M224.564 301.934C224.564 301.934 249.816 294.296 260.266 321.727L207.426 338.096L224.564 301.934Z"
        fill="#455A64"
      />
      <path
        d="M59.44 337.741C59.3704 342.619 60.7488 347.407 63.4008 351.502C66.0528 355.596 69.8593 358.812 74.339 360.742C78.8187 362.673 83.7703 363.232 88.5677 362.349C93.3651 361.465 97.7928 359.179 101.291 355.779C104.789 352.379 107.2 348.018 108.22 343.248C109.239 338.477 108.821 333.512 107.018 328.979C105.216 324.446 102.11 320.55 98.0924 317.783C94.0753 315.015 89.3278 313.501 84.4502 313.432C81.2116 313.385 77.9956 313.977 74.9857 315.174C71.9759 316.37 69.2313 318.148 66.9087 320.405C64.5862 322.663 62.7311 325.356 61.4496 328.33C60.1681 331.305 59.4852 334.503 59.44 337.741Z"
        fill="#263238"
      />
      <path
        d="M59.4377 337.676V337.744C59.4091 344.242 61.9464 350.489 66.4983 355.127C71.0501 359.766 77.2485 362.42 83.7464 362.513C90.2443 362.607 96.5165 360.132 101.2 355.626C105.883 351.121 108.599 344.949 108.757 338.452C108.757 338.452 108.757 338.407 108.757 338.392L59.4377 337.676Z"
        fill="#263238"
      />
      <path
        d="M66.7835 337.849C66.7285 341.282 67.6937 344.654 69.5568 347.538C71.4199 350.422 74.0971 352.688 77.2492 354.049C80.4012 355.41 83.8863 355.804 87.2629 355.183C90.6395 354.561 93.7556 352.951 96.2164 350.557C98.6772 348.163 100.372 345.092 101.086 341.734C101.8 338.376 101.501 334.881 100.227 331.693C98.9535 328.505 96.762 325.766 93.9304 323.825C91.0988 321.883 87.7546 320.826 84.3215 320.786C79.7362 320.734 75.3168 322.5 72.0301 325.697C68.7434 328.895 66.8569 333.264 66.7835 337.849Z"
        fill="#FAFAFA"
      />
      <path
        d="M84.3185 320.787C79.7293 320.728 75.3041 322.491 72.0124 325.69C68.7208 328.888 66.8313 333.261 66.7578 337.85L101.381 338.347C101.44 333.758 99.6768 329.333 96.4785 326.041C93.2802 322.75 88.9074 320.86 84.3185 320.787Z"
        fill="#E0E0E0"
      />
      <path
        d="M73.5441 337.946C73.513 340.034 74.1019 342.084 75.2364 343.837C76.3709 345.591 77.9999 346.968 79.9174 347.795C81.8349 348.623 83.9547 348.863 86.0085 348.485C88.0624 348.107 89.9581 347.128 91.4557 345.673C92.9534 344.218 93.9856 342.351 94.422 340.308C94.8583 338.266 94.6791 336.14 93.907 334.2C93.1349 332.26 91.8046 330.592 90.0844 329.408C88.3643 328.224 86.3315 327.576 84.2434 327.548C81.4463 327.51 78.7483 328.583 76.7422 330.533C74.7361 332.482 73.5858 335.148 73.5441 337.946Z"
        fill="#263238"
      />
      <path
        d="M119.18 328.197C119.006 328.265 106.188 326.191 106.188 326.191C105.494 327.099 104.61 327.844 103.598 328.374C102.586 328.904 101.471 329.206 100.33 329.26C94.7878 329.524 89.359 329.773 84.6616 330.014C82.5667 330.11 80.5947 331.03 79.1752 332.574C77.7558 334.118 77.0041 336.16 77.0839 338.255C77.1692 340.252 78.0018 342.144 79.4165 343.556C80.8312 344.968 82.7248 345.797 84.7219 345.878L112.032 346.949C116.556 347.13 122.497 344.401 125.302 340.917L119.18 328.197Z"
        fill="#455A64"
      />
      <path
        d="M52.0808 317.28C52.0808 317.28 50.9045 293.25 73.4944 288.236V285.16H152.619V292.504C152.619 292.504 141.008 306.49 144.8 318.102C148.593 329.714 149.777 330.92 149.777 330.92H194.813C198.364 325.922 200.343 319.978 200.498 313.85C200.739 303.663 196.502 286.231 193.343 275.094C190.47 264.96 188.653 256.493 188.653 256.493L202.157 251.969C202.157 251.969 227.16 284.655 228.178 286.494C229.195 288.334 232.702 292.617 231.857 302.012C231.013 311.407 208.573 340.405 202.655 343.678C196.736 346.95 191.39 347.154 186.112 347.976C181.497 348.684 147.409 348.209 138.489 348.074C135.389 348.057 132.349 347.213 129.682 345.631C127.013 344.017 125.008 341.34 122.798 336.945L118.101 327.753L52.0808 317.28Z"
        fill="#455A64"
      />
      <path
        d="M58.131 315.637L48.1631 331.222C47.8776 331.657 47.7396 332.173 47.7697 332.693C47.7997 333.213 47.9961 333.71 48.33 334.109C48.6638 334.509 49.1173 334.791 49.6236 334.913C50.1298 335.035 50.662 334.992 51.1414 334.788C52.3814 334.241 53.5128 333.474 54.4817 332.526C59.0434 328.183 67.1715 316.76 67.1715 316.76L58.131 315.637Z"
        fill="#455A64"
      />
      <path
        d="M129.605 318.417C129.616 318.34 129.634 318.264 129.658 318.19C129.708 318.035 129.776 317.816 129.861 317.534C130.101 316.692 130.275 315.832 130.382 314.963C130.729 311.743 130.208 308.489 128.874 305.538C127.967 303.506 126.726 301.64 125.202 300.019C123.447 298.17 121.411 296.61 119.17 295.397C116.685 294.055 114.025 293.066 111.268 292.456C108.295 291.814 105.261 291.5 102.22 291.521C99.1925 291.545 96.17 291.767 93.1717 292.185C90.2537 292.585 87.4489 293.067 84.8099 293.693C80.1188 294.686 75.5976 296.357 71.3887 298.654C68.5633 300.224 65.9804 302.195 63.7205 304.505C62.9212 305.327 62.3557 306.013 61.9712 306.481L61.5414 307.016C61.4966 307.078 61.4461 307.136 61.3906 307.189C62.061 306.202 62.818 305.276 63.6526 304.422C65.8914 302.065 68.4712 300.057 71.3057 298.466C75.5194 296.122 80.0577 294.417 84.7722 293.406C87.4187 292.796 90.2236 292.306 93.1491 291.898C96.1718 291.47 99.2197 291.243 102.273 291.22C105.329 291.198 108.379 291.517 111.366 292.17C114.151 292.804 116.835 293.819 119.343 295.186C121.615 296.418 123.676 298.004 125.45 299.883C126.989 301.53 128.236 303.427 129.138 305.493C130.476 308.48 130.978 311.774 130.593 315.024C130.473 315.898 130.278 316.761 130.012 317.602L129.778 318.251C129.724 318.309 129.666 318.365 129.605 318.417Z"
        fill="#263238"
      />
      <path
        d="M125.037 313.027C124.999 313.027 125.165 312.642 125.338 311.956C125.561 310.965 125.589 309.941 125.421 308.94C125.19 307.468 124.695 306.05 123.959 304.755C123.539 303.981 123.049 303.246 122.496 302.561C121.907 301.825 121.242 301.153 120.513 300.555C119.099 299.397 117.511 298.468 115.808 297.803C114.411 297.266 112.964 296.872 111.487 296.627C110.489 296.459 109.482 296.344 108.471 296.28C108.098 296.277 107.725 296.25 107.355 296.197C107.453 296.184 107.552 296.184 107.65 296.197C107.838 296.197 108.117 296.197 108.479 296.197C109.489 296.213 110.496 296.296 111.495 296.446C112.993 296.664 114.464 297.041 115.883 297.57C117.623 298.233 119.245 299.173 120.686 300.352C121.426 300.971 122.096 301.669 122.684 302.433C123.254 303.14 123.759 303.897 124.192 304.695C124.935 306.026 125.423 307.483 125.632 308.993C125.779 310.013 125.712 311.053 125.436 312.046C125.366 312.307 125.27 312.559 125.15 312.8C125.119 312.879 125.081 312.954 125.037 313.027Z"
        fill="#F5F5F5"
      />
      <g opacity="0.4">
        <path
          d="M109.547 291.965C113.808 292.749 117.862 294.399 121.46 296.813C125.079 299.218 127.867 302.68 129.445 306.728C131.021 310.792 130.787 316.176 129.121 319.546L134.715 320.006C136.6 313.733 134.55 306.027 130.026 301.111C127.435 298.247 124.276 295.954 120.75 294.379C117.224 292.804 113.409 291.982 109.547 291.965Z"
          fill="black"
        />
      </g>
      <path
        d="M152.582 287.955C152.582 288.046 134.795 288.114 112.861 288.114C90.9275 288.114 73.1406 288.046 73.1406 287.955C73.1406 287.865 90.9275 287.797 112.861 287.797C134.795 287.797 152.582 287.872 152.582 287.955Z"
        fill="#263238"
      />
      <path
        d="M152.618 285.159C153.421 284.137 153.918 282.908 154.051 281.615C154.172 279.625 153.297 277.137 151.133 277.137H123.808C122.755 277.137 121.712 277.344 120.739 277.748C119.766 278.151 118.882 278.742 118.138 279.487C117.393 280.232 116.803 281.116 116.401 282.09C115.999 283.063 115.792 284.106 115.793 285.159H152.618Z"
        fill="#455A64"
      />
      <path
        d="M188.653 256.476L183.895 246.569C183.26 245.209 183.154 243.661 183.599 242.228C184.044 240.795 185.007 239.579 186.3 238.818L200.506 230.343C201.249 229.898 202.098 229.664 202.964 229.664H206.032L207.269 249.69L202.526 251.545L205.542 256.416L188.653 256.476Z"
        fill="#455A64"
      />
      <path
        d="M206.078 230.387C206.078 230.387 210.941 231.503 211.552 238.997C212.163 246.492 207.269 248.799 207.269 248.799L206.078 230.387Z"
        fill="white"
      />
      <path
        d="M206.077 230.386C206.11 230.517 206.128 230.651 206.129 230.786L206.22 231.864C206.303 232.844 206.401 234.171 206.529 235.8C206.785 239.117 207.125 243.679 207.457 248.814L207.178 248.648C207.7 248.362 208.18 248.004 208.603 247.585C209.566 246.653 210.299 245.509 210.744 244.244C211.165 243.065 211.392 241.825 211.415 240.572C211.494 238.437 211.084 236.312 210.216 234.359C209.609 233.054 208.664 231.935 207.479 231.117C207.036 230.824 206.566 230.572 206.077 230.363C206.216 230.372 206.354 230.403 206.484 230.454C206.86 230.588 207.221 230.76 207.562 230.966C208.816 231.755 209.822 232.882 210.465 234.216C211.393 236.198 211.842 238.37 211.777 240.557C211.763 241.842 211.537 243.116 211.106 244.327C210.633 245.651 209.859 246.846 208.844 247.818C208.396 248.263 207.888 248.644 207.336 248.949L207.072 249.085V248.783C206.74 243.558 206.484 238.906 206.318 235.596C206.243 233.99 206.175 232.678 206.129 231.705L206.084 230.672C206.074 230.577 206.072 230.481 206.077 230.386Z"
        fill="#263238"
      />
      <path
        d="M188.576 242.925C188.576 242.925 175.629 249.063 174.046 250.035C172.953 250.737 172.01 251.958 172.87 254.115C174.34 257.779 180.41 254.333 180.41 254.333L192.474 248.301C192.474 248.301 197.103 246.107 195.392 243.378C193.446 240.347 188.576 242.925 188.576 242.925Z"
        fill="#263238"
      />
      <path
        d="M186.939 234.89C189.059 234.89 190.777 231.862 190.777 228.127C190.777 224.391 189.059 221.363 186.939 221.363C184.82 221.363 183.102 224.391 183.102 228.127C183.102 231.862 184.82 234.89 186.939 234.89Z"
        fill="#263238"
      />
      <path
        d="M187.566 232.778L189.678 240.084C190.063 239.891 190.37 239.572 190.549 239.179C190.727 238.787 190.766 238.345 190.658 237.928C190.13 235.424 189.828 233.645 189.248 231.451C189.18 231.232 187.566 232.778 187.566 232.778Z"
        fill="#263238"
      />
      <g opacity="0.3">
        <path
          d="M145.839 321.221C145.628 320.618 145.417 320.007 145.213 319.374C145.009 318.741 144.806 318.175 144.647 317.587C144.401 316.685 144.224 315.764 144.12 314.835C140.561 329.319 145.99 339.521 155.324 340.237C168.949 341.285 185.567 342.047 192.27 340.282C204.523 337.07 209.016 326.854 210.087 325.202C211.158 323.551 220.907 305.704 214.935 288.558C208.964 271.412 198.558 253.195 198.551 253.195L188.636 256.505C188.636 256.505 190.453 264.973 193.326 275.107C196.485 286.243 200.722 303.676 200.481 313.862C200.326 319.991 198.347 325.935 194.796 330.933H149.775C149.775 330.933 148.81 329.968 145.839 321.251"
          fill="black"
        />
      </g>
      <path
        d="M50.2781 313.509L50.5948 310.07L132.781 319.541C133.88 319.67 134.94 320.023 135.898 320.578C136.856 321.132 137.69 321.876 138.35 322.764C139.01 323.652 139.482 324.665 139.736 325.742C139.991 326.819 140.023 327.936 139.831 329.026L139.461 331.107L54.4025 318.741C53.1757 318.563 52.0641 317.921 51.2968 316.947C50.5294 315.974 50.1648 314.743 50.2781 313.509Z"
        fill="#455A64"
      />
      <g opacity="0.3">
        <path
          d="M50.2781 313.509L50.5948 310.07L132.781 319.541C133.88 319.67 134.94 320.023 135.898 320.578C136.856 321.132 137.69 321.876 138.35 322.764C139.01 323.652 139.482 324.665 139.736 325.742C139.991 326.819 140.023 327.936 139.831 329.026L139.461 331.107L54.4025 318.741C53.1757 318.563 52.0641 317.921 51.2968 316.947C50.5294 315.974 50.1648 314.743 50.2781 313.509Z"
          fill="black"
        />
      </g>
      <g opacity="0.3">
        <path
          d="M210.102 336.505C210.102 336.505 228.198 316.607 231.93 300.954C233.805 300.944 235.679 301.083 237.532 301.368C237.532 301.368 226.825 330.458 210.102 336.505Z"
          fill="black"
        />
      </g>
      <path
        d="M231.664 293.941C231.714 294.106 231.746 294.275 231.762 294.447C231.807 294.778 231.906 295.261 231.973 295.902C232.139 297.701 232.091 299.513 231.83 301.3C231.412 303.955 230.606 306.533 229.44 308.954C228.009 311.895 226.41 314.752 224.652 317.511C221.499 322.555 217.957 327.345 214.058 331.837C212.588 333.579 211.374 334.967 210.522 335.917L209.549 337.01C209.44 337.143 209.319 337.267 209.188 337.379C209.278 337.235 209.381 337.098 209.497 336.972L210.432 335.841L213.892 331.694C217.728 327.177 221.233 322.389 224.381 317.368C226.132 314.616 227.735 311.771 229.184 308.848C230.345 306.462 231.162 303.923 231.611 301.308C231.894 299.536 231.972 297.737 231.845 295.947C231.808 295.314 231.725 294.824 231.702 294.492C231.674 294.31 231.661 294.126 231.664 293.941Z"
        fill="#263238"
      />
      <path
        d="M200.385 336.361C198.383 334.694 196.52 332.869 194.812 330.902C195.846 331.696 196.814 332.571 197.708 333.519C198.676 334.392 199.571 335.342 200.385 336.361Z"
        fill="#263238"
      />
      <path
        d="M146.684 335.75C146.972 334.819 147.421 333.946 148.011 333.171C148.518 332.341 149.16 331.602 149.911 330.984C149.986 331.045 149.157 332.04 148.275 333.344C147.392 334.649 146.767 335.787 146.684 335.75Z"
        fill="#263238"
      />
      <path
        d="M111.915 347.244C112.904 346.341 113.737 345.281 114.381 344.107C115.058 342.825 115.47 341.42 115.595 339.976C115.779 338.215 115.472 336.438 114.708 334.841C113.944 333.244 112.753 331.889 111.267 330.928C110.068 330.112 108.716 329.548 107.293 329.269C105.976 329.028 104.628 329.01 103.305 329.216C103.305 329.216 103.395 329.178 103.576 329.133C103.823 329.064 104.075 329.014 104.33 328.982C105.318 328.846 106.321 328.869 107.301 329.05C108.761 329.308 110.153 329.865 111.388 330.686C112.935 331.665 114.174 333.062 114.963 334.715C115.751 336.368 116.056 338.209 115.844 340.028C115.705 341.506 115.261 342.939 114.539 344.236C114.063 345.109 113.452 345.903 112.73 346.588C112.481 346.837 112.247 346.988 112.111 347.108C112.052 347.161 111.986 347.207 111.915 347.244Z"
        fill="#263238"
      />
      <path
        d="M81.9004 340.938C81.6966 339.987 81.598 339.016 81.6064 338.043C81.5062 337.073 81.5062 336.095 81.6064 335.125C81.8105 336.079 81.9091 337.052 81.9004 338.028C82.0048 338.995 82.0048 339.971 81.9004 340.938Z"
        fill="#263238"
      />
      <path
        d="M84.0803 340.946C83.8039 340.002 83.627 339.031 83.5525 338.05C83.3795 337.083 83.3062 336.1 83.3338 335.117C83.6154 336.06 83.7924 337.031 83.8616 338.013C84.0436 338.979 84.117 339.963 84.0803 340.946Z"
        fill="#263238"
      />
      <path
        d="M117.98 285.158C117.98 285.241 107.99 285.317 95.6619 285.317C83.334 285.317 73.3359 285.241 73.3359 285.158C73.3359 285.075 83.334 285 95.6619 285C107.99 285 117.98 285.068 117.98 285.158Z"
        fill="#263238"
      />
      <path
        d="M65.6512 354.841C65.5535 354.764 65.465 354.675 65.3873 354.577C65.2289 354.396 64.9726 354.133 64.686 353.763C63.8408 352.741 63.084 351.649 62.424 350.498C60.2432 346.687 59.1041 342.368 59.1213 337.976C59.1385 333.585 60.3114 329.275 62.5221 325.481C63.1811 324.334 63.9379 323.247 64.7841 322.231C65.0706 321.861 65.3345 321.605 65.4928 321.424C65.5741 321.327 65.665 321.239 65.7643 321.16C65.7009 321.267 65.6277 321.368 65.5456 321.462C65.3948 321.658 65.1535 321.929 64.8821 322.306C64.0799 323.342 63.3589 324.439 62.7256 325.586C60.5931 329.367 59.4638 333.631 59.4454 337.972C59.4269 342.313 60.5198 346.586 62.6201 350.385C63.248 351.538 63.9612 352.642 64.7539 353.688C65.0178 354.072 65.2591 354.336 65.4023 354.54C65.4971 354.63 65.5807 354.731 65.6512 354.841Z"
        fill="#455A64"
      />
      <path
        d="M149.918 345.041C149.918 345.041 150.612 361.169 150.627 361.946L154.05 364.54L162.261 362.496L161.507 344.672L149.918 345.041Z"
        fill="#FFBE9D"
      />
      <path
        d="M172.538 203.139L181.127 207.731L195.49 197.258L199.667 204.466C199.667 204.466 190.921 212.903 187.814 215.776C184.708 218.649 182.672 220.179 180.403 219.735C178.133 219.29 165.496 212.27 165.496 212.27C165.496 212.27 169.176 203.29 172.538 203.139Z"
        fill="#FFBE9D"
      />
      <path
        d="M181.172 210.927C181.172 210.927 181.225 210.979 181.255 211.07V211.145H181.066V211.077V210.851C181.014 210.421 180.987 209.988 180.984 209.554C180.912 208.934 180.966 208.306 181.142 207.707C181.353 208.296 181.433 208.924 181.376 209.547C181.376 210.052 181.376 210.512 181.338 210.851V211.077V211.145C180.946 211.145 181.225 211.145 181.142 211.145V211.062C181.119 210.979 181.149 210.927 181.172 210.927Z"
        fill="#EB996E"
      />
      <path
        d="M197.277 206.425C197.563 206.516 200.24 203.628 200.24 203.628C200.24 203.628 205.254 203.538 206.453 202.874C207.652 202.211 209.469 199.737 209.469 199.737L207.049 192.363C204.81 192.51 202.582 192.787 200.376 193.193C198.777 193.638 194.954 197.641 194.954 197.641L193.311 200.197C193.311 200.197 192.798 205.046 197.277 206.425Z"
        fill="#FFBE9D"
      />
      <path
        d="M205.754 203.287C206.369 203.243 206.98 203.165 207.586 203.053C208.793 202.85 210.037 202.744 209.999 201.545C210.002 201.347 209.963 201.149 209.884 200.967C209.804 200.785 209.687 200.622 209.539 200.49C209.539 200.49 210.429 200.12 210.421 199.449C210.419 199.254 210.371 199.062 210.281 198.889C210.19 198.716 210.06 198.567 209.901 198.454C209.901 198.454 211.13 197.888 211.168 196.893C211.173 196.525 211.075 196.163 210.886 195.848C210.697 195.532 210.424 195.275 210.097 195.106C210.097 195.106 213.867 194.028 214.169 193.907C215.239 193.47 217.283 192.497 216.431 191.698C216.121 191.404 216.001 191.08 213.844 191.344C211.884 191.577 208.8 192.301 208.8 192.301C208.8 192.301 206.161 192.429 204.774 192.573C203.054 192.73 201.351 193.035 199.684 193.485C197.905 194.307 196.352 196.644 196.352 196.644L200.265 203.626L205.754 203.287Z"
        fill="#FFBE9D"
      />
      <path
        d="M209.242 200.461C208.89 200.413 208.534 200.392 208.179 200.4H207.025C206.797 200.382 206.568 200.382 206.339 200.4C206.078 200.433 205.835 200.55 205.646 200.732C205.542 200.825 205.466 200.944 205.426 201.077C205.386 201.21 205.384 201.352 205.419 201.486C205.496 201.722 205.661 201.919 205.879 202.036C206.058 202.147 206.247 202.238 206.445 202.308L206.943 202.496C207.259 202.609 207.508 202.685 207.697 202.73C207.885 202.775 207.975 202.798 207.975 202.783C207.975 202.768 207.598 202.632 206.995 202.391C206.641 202.257 206.298 202.096 205.97 201.908C205.788 201.806 205.651 201.639 205.585 201.441C205.561 201.336 205.565 201.226 205.598 201.124C205.632 201.022 205.692 200.93 205.774 200.86C205.938 200.704 206.146 200.601 206.369 200.566C206.59 200.548 206.812 200.548 207.033 200.566H208.187C208.541 200.559 208.894 200.524 209.242 200.461Z"
        fill="#EB996E"
      />
      <path
        d="M205.126 195.31C205.519 195.143 205.865 194.885 206.137 194.556C206.454 194.274 206.695 193.916 206.838 193.516C206.8 193.516 206.491 193.953 206.016 194.443C205.541 194.933 205.096 195.272 205.126 195.31Z"
        fill="#EB996E"
      />
      <path
        d="M201.942 193.57C202.941 193.811 203.85 194.334 204.559 195.078C205.26 195.82 205.844 196.664 206.293 197.582C206.67 198.336 206.994 199.203 206.579 199.904C206.327 200.247 205.957 200.486 205.54 200.575C205.123 200.664 204.688 200.597 204.317 200.386C203.594 199.95 203.024 199.299 202.689 198.524C202.356 197.752 201.931 197.022 201.422 196.353"
        fill="#FFBE9D"
      />
      <path
        d="M201.477 196.346C201.477 196.346 201.612 196.519 201.831 196.866C202.107 197.356 202.359 197.859 202.585 198.374C202.755 198.738 202.957 199.086 203.188 199.414C203.452 199.801 203.797 200.125 204.199 200.364C204.656 200.625 205.194 200.703 205.707 200.583C205.989 200.52 206.249 200.382 206.461 200.183C206.664 199.978 206.799 199.715 206.845 199.429C206.898 198.869 206.785 198.305 206.521 197.808C206.294 197.352 206.042 196.909 205.767 196.481C205.315 195.748 204.744 195.096 204.078 194.551C203.627 194.186 203.117 193.9 202.57 193.707C202.421 193.652 202.267 193.612 202.11 193.586C202.004 193.586 201.952 193.586 201.952 193.586C201.952 193.586 202.17 193.646 202.547 193.79C203.077 194.004 203.57 194.299 204.01 194.664C204.657 195.211 205.21 195.861 205.646 196.587C205.908 197.011 206.147 197.449 206.362 197.899C206.611 198.36 206.718 198.885 206.672 199.407C206.633 199.662 206.517 199.898 206.34 200.085C206.156 200.259 205.93 200.381 205.684 200.44C205.21 200.559 204.707 200.492 204.281 200.251C203.898 200.023 203.567 199.718 203.309 199.354C203.078 199.034 202.874 198.696 202.698 198.344C202.45 197.824 202.171 197.321 201.861 196.836C201.748 196.67 201.642 196.549 201.575 196.466C201.507 196.383 201.477 196.338 201.477 196.346Z"
        fill="#EB996E"
      />
      <path
        d="M209.129 200.46C207.583 200.461 206.038 200.542 204.5 200.702C204.06 200.782 203.607 200.743 203.188 200.588C202.864 200.43 202.743 199.616 202.66 199.269L208.33 198.387"
        fill="#FFBE9D"
      />
      <path
        d="M208.331 198.387C208.184 198.386 208.038 198.398 207.893 198.424L206.687 198.59L202.645 199.186H202.562V199.277C202.623 199.533 202.676 199.819 202.766 200.098C202.802 200.215 202.853 200.326 202.917 200.43C202.948 200.483 202.986 200.531 203.03 200.573C203.079 200.617 203.135 200.653 203.196 200.679C203.41 200.763 203.637 200.804 203.867 200.8C204.312 200.8 204.719 200.739 205.111 200.709C205.865 200.641 206.619 200.581 207.192 200.543C207.765 200.506 208.263 200.49 208.602 200.475C208.773 200.488 208.944 200.488 209.115 200.475C208.945 200.447 208.774 200.434 208.602 200.438C208.263 200.438 207.78 200.438 207.185 200.438C206.589 200.438 205.88 200.506 205.096 200.566C204.704 200.566 204.289 200.649 203.874 200.641C203.665 200.646 203.457 200.608 203.264 200.528C203.083 200.468 203 200.257 202.924 200.053C202.849 199.85 202.789 199.51 202.728 199.246L202.661 199.344C204.259 199.096 205.677 198.862 206.687 198.688L207.886 198.477C208.036 198.459 208.185 198.429 208.331 198.387Z"
        fill="#EB996E"
      />
      <path
        d="M209.984 198.072L204.08 199.203C203.666 199.307 203.238 199.34 202.813 199.301C202.602 199.28 202.399 199.207 202.223 199.088C202.046 198.97 201.902 198.81 201.803 198.622C201.716 198.345 201.723 198.047 201.822 197.775C201.922 197.502 202.108 197.27 202.353 197.114C202.858 196.814 203.421 196.624 204.004 196.556C205.799 196.203 207.564 195.712 209.282 195.086"
        fill="#FFBE9D"
      />
      <path
        d="M209.263 195.062C209.204 195.071 209.146 195.086 209.09 195.108L208.6 195.266C208.177 195.394 207.567 195.59 206.805 195.794C206.044 195.997 205.124 196.231 204.098 196.435C203.545 196.507 203.005 196.665 202.5 196.902C202.229 197.044 202.002 197.258 201.844 197.521C201.669 197.793 201.599 198.12 201.648 198.44C201.685 198.599 201.755 198.749 201.853 198.879C201.952 199.009 202.077 199.116 202.221 199.194C202.489 199.341 202.79 199.416 203.096 199.413C203.647 199.373 204.194 199.29 204.732 199.164L207.469 198.621L209.308 198.244L209.806 198.131L209.98 198.079C209.92 198.07 209.859 198.07 209.799 198.079L209.293 198.161L207.446 198.486L204.702 198.998C204.173 199.119 203.636 199.198 203.096 199.232C202.819 199.236 202.546 199.169 202.304 199.036C202.181 198.97 202.074 198.879 201.99 198.768C201.905 198.658 201.845 198.531 201.814 198.395C201.773 198.117 201.834 197.833 201.987 197.596C202.13 197.361 202.333 197.168 202.575 197.038C203.066 196.806 203.59 196.651 204.128 196.578C205.154 196.367 206.074 196.126 206.835 195.907C207.597 195.688 208.208 195.47 208.622 195.319L209.097 195.13L209.263 195.062Z"
        fill="#EB996E"
      />
      <path
        d="M198.172 199.52C198.172 199.52 198.255 199.693 198.481 199.897C198.784 200.15 199.139 200.332 199.522 200.432C199.903 200.535 200.302 200.551 200.69 200.477C200.984 200.417 201.15 200.334 201.143 200.311C200.619 200.395 200.085 200.382 199.567 200.274C199.057 200.115 198.583 199.859 198.172 199.52Z"
        fill="#EB996E"
      />
      <path
        d="M166.227 241.289C166.227 241.289 180.553 243.936 181.548 244.207C182.543 244.478 186.637 246.409 186.826 247.645C186.935 249.272 186.935 250.904 186.826 252.531C186.826 252.531 186.072 253.127 185.635 251.936C185.332 250.777 185.202 249.58 185.25 248.384L182.988 247.51L184.225 249.711L184.428 254.869C184.428 254.869 182.845 254.725 182.536 253.489C182.341 252.633 182.24 251.758 182.234 250.88L180.575 249.478L181.819 251.159L182.234 254.869C182.234 254.869 181.028 255.261 180.643 254.439C180.368 253.367 180.231 252.265 180.236 251.159L175.561 249.523L172.47 251.249L169.114 249.41C168.645 249.15 168.238 248.791 167.923 248.357C167.608 247.923 167.392 247.425 167.29 246.899L166.227 241.289Z"
        fill="#FFBE9D"
      />
      <path
        d="M137.62 170.114L138.095 195.109C138.132 197.075 138.912 198.954 140.279 200.369C141.646 201.783 143.497 202.627 145.461 202.732C146.524 202.786 147.586 202.622 148.583 202.25C149.58 201.878 150.49 201.305 151.257 200.568C152.024 199.83 152.631 198.943 153.041 197.961C153.451 196.979 153.656 195.924 153.642 194.86C153.642 192.477 153.567 190.532 153.567 190.532C153.567 190.532 159.644 189.906 160.036 183.882C160.255 180.398 160.036 172.466 159.863 166.389C159.797 164.4 158.984 162.509 157.587 161.092C156.19 159.676 154.31 158.837 152.323 158.743L148.681 158.555C147.19 158.57 145.718 158.883 144.35 159.476C142.982 160.068 141.747 160.928 140.716 162.005C139.686 163.082 138.881 164.354 138.349 165.747C137.817 167.139 137.569 168.624 137.62 170.114Z"
        fill="#FFBE9D"
      />
      <path
        d="M153.568 190.472C150.785 190.317 148.103 189.37 145.84 187.742C145.84 187.742 147.551 192.266 153.599 191.995L153.568 190.472Z"
        fill="#EB996E"
      />
      <path
        d="M158.43 172.05C158.325 172.163 157.676 171.643 156.764 171.598C155.852 171.552 155.135 171.982 155.045 171.862C154.954 171.741 155.113 171.613 155.422 171.409C155.839 171.156 156.322 171.035 156.809 171.062C157.292 171.086 157.754 171.263 158.129 171.568C158.4 171.794 158.491 172.005 158.43 172.05Z"
        fill="#263238"
      />
      <path
        d="M149.512 174.033C149.504 174.258 149.408 174.472 149.244 174.627C149.081 174.782 148.863 174.867 148.637 174.863C148.527 174.865 148.418 174.845 148.316 174.805C148.213 174.764 148.12 174.704 148.041 174.628C147.962 174.552 147.898 174.461 147.855 174.36C147.811 174.259 147.787 174.151 147.785 174.041C147.793 173.815 147.889 173.602 148.053 173.447C148.216 173.292 148.434 173.207 148.66 173.211C148.77 173.208 148.88 173.227 148.982 173.267C149.085 173.307 149.179 173.367 149.258 173.443C149.338 173.52 149.401 173.611 149.444 173.713C149.488 173.814 149.511 173.923 149.512 174.033Z"
        fill="#263238"
      />
      <path
        d="M157.949 174.033C157.941 174.258 157.845 174.472 157.682 174.627C157.518 174.782 157.3 174.867 157.075 174.863C156.965 174.866 156.855 174.847 156.752 174.807C156.649 174.767 156.556 174.707 156.476 174.63C156.397 174.554 156.334 174.462 156.29 174.361C156.247 174.26 156.224 174.151 156.223 174.041C156.231 173.815 156.327 173.602 156.49 173.447C156.654 173.292 156.872 173.207 157.097 173.211C157.207 173.208 157.317 173.227 157.42 173.267C157.523 173.307 157.616 173.367 157.696 173.443C157.775 173.52 157.838 173.611 157.882 173.713C157.925 173.814 157.948 173.923 157.949 174.033Z"
        fill="#263238"
      />
      <path
        d="M149.483 171.718C149.37 171.824 148.729 171.304 147.817 171.258C146.904 171.213 146.188 171.643 146.09 171.522C145.992 171.402 146.165 171.274 146.474 171.078C146.888 170.817 147.374 170.693 147.862 170.723C148.344 170.746 148.807 170.923 149.181 171.228C149.453 171.462 149.536 171.666 149.483 171.718Z"
        fill="#263238"
      />
      <path
        d="M152.405 179.091C152.897 178.964 153.404 178.898 153.913 178.895C154.146 178.895 154.38 178.85 154.425 178.692C154.455 178.449 154.413 178.202 154.305 177.983L153.686 176.143C153.117 174.583 152.673 172.979 152.359 171.348C153.054 172.858 153.626 174.421 154.071 176.022C154.275 176.671 154.463 177.282 154.652 177.87C154.785 178.163 154.809 178.495 154.719 178.805C154.681 178.887 154.625 178.96 154.554 179.018C154.484 179.075 154.401 179.116 154.312 179.136C154.18 179.154 154.045 179.154 153.913 179.136C153.41 179.183 152.904 179.168 152.405 179.091Z"
        fill="#263238"
      />
      <path
        d="M149.64 179.59C149.798 179.59 149.745 180.6 150.567 181.354C151.389 182.108 152.467 182.056 152.467 182.199C152.467 182.342 152.218 182.38 151.766 182.372C151.176 182.348 150.613 182.119 150.175 181.724C149.755 181.33 149.502 180.79 149.466 180.216C149.451 179.824 149.572 179.582 149.64 179.59Z"
        fill="#263238"
      />
      <path
        d="M149.593 168.355C149.488 168.596 148.575 168.43 147.475 168.505C146.374 168.581 145.492 168.83 145.356 168.596C145.296 168.49 145.461 168.257 145.831 168.03C146.317 167.752 146.862 167.592 147.422 167.563C147.982 167.525 148.543 167.62 149.058 167.842C149.45 168.023 149.639 168.234 149.593 168.355Z"
        fill="#263238"
      />
      <path
        d="M158.153 168.705C157.979 168.908 157.353 168.652 156.584 168.607C155.815 168.561 155.159 168.674 155.024 168.441C154.963 168.335 155.076 168.132 155.37 167.943C155.763 167.724 156.213 167.627 156.662 167.664C157.11 167.702 157.538 167.872 157.889 168.154C158.153 168.38 158.213 168.607 158.153 168.705Z"
        fill="#263238"
      />
      <path
        d="M139.421 174.711C139.323 174.659 135.342 173.271 135.259 177.396C135.176 181.52 139.361 180.758 139.361 180.668C139.361 180.578 139.421 174.711 139.421 174.711Z"
        fill="#FFBE9D"
      />
      <path
        d="M138.117 179.048C138.117 179.048 138.05 179.101 137.921 179.154C137.749 179.219 137.558 179.219 137.386 179.154C137.13 178.974 136.926 178.731 136.794 178.448C136.661 178.164 136.606 177.852 136.632 177.54C136.631 177.187 136.705 176.837 136.851 176.515C136.893 176.386 136.965 176.269 137.063 176.174C137.16 176.08 137.279 176.01 137.409 175.972C137.491 175.952 137.577 175.962 137.653 175.999C137.728 176.036 137.789 176.098 137.823 176.175C137.876 176.296 137.823 176.379 137.876 176.386C137.929 176.394 137.967 176.319 137.936 176.145C137.913 176.043 137.857 175.95 137.778 175.881C137.664 175.795 137.521 175.755 137.378 175.768C137.211 175.802 137.054 175.877 136.923 175.986C136.791 176.095 136.688 176.235 136.624 176.394C136.439 176.747 136.345 177.141 136.353 177.54C136.325 177.908 136.406 178.275 136.586 178.597C136.766 178.919 137.036 179.181 137.363 179.35C137.475 179.381 137.591 179.389 137.706 179.372C137.82 179.355 137.93 179.314 138.027 179.252C138.11 179.161 138.132 179.056 138.117 179.048Z"
        fill="#EB996E"
      />
      <path
        d="M137.139 174.447C137.532 174.444 137.919 174.546 138.259 174.744C138.598 174.941 138.878 175.227 139.07 175.571C139.303 176.174 139.333 176.845 139.567 177.448C139.658 177.759 139.849 178.031 140.111 178.22C140.373 178.41 140.691 178.507 141.015 178.496C141.233 178.44 141.432 178.328 141.592 178.17C141.752 178.013 141.868 177.815 141.927 177.599C142.038 177.166 142.066 176.715 142.01 176.272C141.859 174.334 141.558 172.404 141.58 170.458C141.523 168.503 142.048 166.574 143.088 164.916C143.618 164.098 144.358 163.438 145.231 163.005C146.104 162.573 147.078 162.384 148.05 162.458C149.324 162.624 150.462 163.356 151.729 163.605C152.477 163.738 153.245 163.7 153.976 163.495C154.707 163.291 155.382 162.923 155.952 162.421C156.102 162.293 156.766 161.9 156.766 161.9C156.772 161.441 156.644 160.991 156.396 160.604C153.991 158.138 149.475 157.248 146.097 157.919C144.38 158.247 142.755 158.945 141.336 159.964C139.916 160.984 138.736 162.301 137.878 163.823C136.28 166.877 136.483 171.25 137.124 174.447"
        fill="#263238"
      />
      <path
        d="M154.9 161.239C152.638 161.322 148.257 162.167 146.455 163.569C146.244 163.735 146.01 164.006 146.153 164.24C146.297 164.474 146.508 164.421 146.711 164.414C148.804 164.52 150.88 164.836 152.909 165.356C154.201 165.812 155.567 166.02 156.936 165.967C157.619 165.929 158.282 165.715 158.858 165.345C159.434 164.975 159.905 164.462 160.223 163.856L160.804 164.074C160.143 163.137 159.254 162.385 158.221 161.889C157.187 161.392 156.044 161.169 154.9 161.239Z"
        fill="#263238"
      />
      <path
        d="M159.631 164.013C158.401 162.856 156.824 162.135 155.144 161.962C149.927 161.487 141.361 163.055 136.822 172.02C136.328 170.469 136.019 168.864 135.902 167.24C135.902 166.011 136.656 158.705 144.196 156.443C144.211 156.443 155.567 152.168 159.631 164.013Z"
        fill="#455A64"
      />
      <g opacity="0.3">
        <path
          d="M159.631 164.013C158.323 162.616 156.521 161.785 154.609 161.698C149.934 161.472 141.097 163.568 136.822 172.02C136.328 170.469 136.019 168.864 135.902 167.24C135.902 166.011 136.656 158.705 144.196 156.443C144.211 156.443 155.567 152.168 159.631 164.013Z"
          fill="black"
        />
      </g>
      <path
        d="M137.53 170.744C139.792 166.974 143.185 164.373 146.842 162.111C150.499 159.849 156.523 157.64 160.678 156.554C161.908 156.157 163.209 156.029 164.493 156.177C165.133 156.26 165.736 156.523 166.233 156.933C166.731 157.344 167.102 157.887 167.305 158.499C167.697 160.068 164.908 162.465 163.596 163.408C162.381 164.217 161.123 164.957 159.826 165.625C159.826 165.625 159.675 162.82 155.03 162.209C148.704 161.38 137.334 170.903 137.53 170.744Z"
        fill="#455A64"
      />
      <path
        d="M146.148 159.174C147.526 158.525 148.966 158.02 150.446 157.666C151.942 157.435 153.458 157.351 154.97 157.417C154.545 157.262 154.096 157.18 153.643 157.175C152.549 157.088 151.448 157.149 150.371 157.356C149.297 157.567 148.257 157.922 147.279 158.412C146.864 158.604 146.483 158.861 146.148 159.174Z"
        fill="white"
      />
      <path
        d="M162.369 361.492L162.414 362.201C162.414 362.201 175.232 366.476 175.526 368.746L150.674 369.696L150.523 361.756C152.409 362.533 154.435 362.91 156.474 362.865C158.512 362.819 160.52 362.352 162.369 361.492Z"
        fill="#455A64"
      />
      <g opacity="0.6">
        <path
          d="M150.671 369.697L150.633 367.789L174.444 367.57C174.444 367.57 175.575 367.993 175.5 368.747L150.671 369.697Z"
          fill="white"
        />
      </g>
      <path
        d="M162.502 362.261C162.502 362.374 161.906 362.45 161.333 362.849C160.76 363.249 160.474 363.746 160.353 363.709C160.232 363.671 160.353 362.955 161.107 362.517C161.861 362.08 162.524 362.155 162.502 362.261Z"
        fill="#263238"
      />
      <path
        d="M165.172 363.196C165.21 363.309 164.697 363.52 164.313 364.033C163.928 364.546 163.845 365.066 163.724 365.066C163.604 365.066 163.483 364.41 163.973 363.784C164.463 363.159 165.165 363.083 165.172 363.196Z"
        fill="#263238"
      />
      <path
        d="M166.836 366.155C166.723 366.155 166.52 365.604 166.791 364.956C167.063 364.307 167.621 364.036 167.673 364.126C167.726 364.217 167.402 364.579 167.183 365.114C166.965 365.649 166.957 366.155 166.836 366.155Z"
        fill="#263238"
      />
      <path
        d="M164.357 305.99L160.15 291.966L154.547 274.111L154.856 264.92L145.477 258.458C139.347 258.563 121.484 257.508 121.484 257.508C121.484 257.508 121.944 266.827 122.864 273.538C123.051 274.869 123.544 276.139 124.304 277.248L132.53 289.244L146.676 315.634C146.676 315.634 147.618 325.059 148.01 333.202C148.447 342.325 149.918 358.838 149.918 358.838L164.47 359.185L165.382 322.631C165.752 317.142 166.159 311.193 164.357 305.99Z"
        fill="#263238"
      />
      <path
        d="M173.367 305.547C175.041 306.904 176.542 325.354 173.782 324.012L177.062 327.111L185.838 325.603L187.052 306.218L173.367 305.547Z"
        fill="#FFBE9D"
      />
      <path
        d="M148.559 250.406C148.559 250.406 184.917 260.299 188.687 268.125C190.206 270.688 190.916 273.65 190.723 276.623C190.504 281.901 187.503 319.85 187.503 319.85L173.773 318.945L172.453 304.943L172.227 283.748L173.185 281.335C172.134 281.578 171.04 281.565 169.995 281.298C168.434 280.838 144.744 273.667 144.744 273.667L135.492 259.085L148.559 250.406Z"
        fill="#263238"
      />
      <path
        d="M186.051 324.541V325.295C186.051 325.295 198.93 331.048 198.93 333.528L172.984 332.442L173.693 323.824C175.581 324.824 177.662 325.405 179.794 325.529C181.927 325.652 184.061 325.315 186.051 324.541Z"
        fill="#455A64"
      />
      <g opacity="0.6">
        <path
          d="M173.008 332.441L173.174 330.367L197.988 332.169C197.988 332.169 199.119 332.72 198.953 333.526L173.008 332.441Z"
          fill="white"
        />
      </g>
      <path
        d="M186.109 325.392C186.109 325.52 185.461 325.55 184.82 325.927C184.179 326.304 183.825 326.832 183.711 326.771C183.598 326.711 183.817 326.017 184.601 325.55C185.385 325.082 186.147 325.271 186.109 325.392Z"
        fill="#263238"
      />
      <path
        d="M188.789 326.626C188.789 326.755 188.262 326.943 187.802 327.463C187.342 327.984 187.206 328.542 187.048 328.534C186.889 328.527 186.874 327.78 187.447 327.169C188.02 326.559 188.797 326.506 188.789 326.626Z"
        fill="#263238"
      />
      <path
        d="M190.197 329.962C190.084 329.962 189.933 329.343 190.288 328.665C190.642 327.986 191.245 327.73 191.298 327.835C191.351 327.941 190.966 328.303 190.68 328.861C190.393 329.419 190.325 329.962 190.197 329.962Z"
        fill="#263238"
      />
      <path
        d="M178.995 274.293C178.559 274.494 178.157 274.761 177.803 275.085C176.905 275.815 176.097 276.65 175.398 277.573C174.698 278.503 174.116 279.516 173.664 280.589C173.447 281.018 173.299 281.478 173.227 281.954C173.918 280.501 174.73 279.108 175.654 277.792C176.666 276.532 177.783 275.362 178.995 274.293Z"
        fill="#455A64"
      />
      <path
        d="M176.042 271.414C175.703 271.828 175.424 272.287 175.212 272.779C174.063 275.091 173.408 277.618 173.29 280.198C173.242 280.729 173.265 281.264 173.357 281.789C173.447 281.268 173.5 280.742 173.516 280.213C173.634 278.942 173.85 277.681 174.164 276.443C174.481 275.214 174.895 274.011 175.401 272.847C175.643 272.382 175.857 271.904 176.042 271.414Z"
        fill="#455A64"
      />
      <path
        d="M151.689 266.027C151.787 266.027 153.431 270.551 155.353 276.131C157.276 281.711 158.754 286.325 158.648 286.363C158.543 286.4 156.907 281.876 154.984 276.259C153.061 270.642 151.583 266.065 151.689 266.027Z"
        fill="#455A64"
      />
      <path
        d="M157.234 199.308L163.168 196.926L178.648 205.333L172.329 219.795L158.705 213.031L157.234 199.308Z"
        fill={theme.palette.primary.main}
      />
      <path
        d="M163.169 196.924L153.759 193.365C153.759 193.365 151.7 197.716 147.199 196.381C142.697 195.046 137.736 191.035 137.736 191.035C137.736 191.035 129.178 194.428 126.569 195.974C123.961 197.52 122.551 237.625 122.551 237.625L121.842 253.142L121.42 256.068C121.24 257.468 121.146 258.878 121.141 260.29C137.088 263.872 152.854 260.079 161.306 255.389C161.306 255.389 162.422 254.514 161.94 252.516C161.457 250.518 160.432 250.171 160.432 250.171L160.643 232.633L162.211 214.696L163.169 196.924Z"
        fill={theme.palette.primary.main}
      />
      <path
        d="M171.589 242.286L150.417 233.524L137.297 204.473L125.625 209.374C125.625 209.374 138.156 240.876 143.02 243.492C147.883 246.109 167.939 247.315 167.939 247.315L171.589 242.286Z"
        fill="#FFBE9D"
      />
      <path
        d="M126.544 195.974C126.544 195.974 122.133 198.183 122.141 206.628C122.141 213.964 124.305 225.658 124.305 225.658L145.085 218.428L138.661 203.498C137.153 199.94 133.805 193.395 126.544 195.974Z"
        fill={theme.palette.primary.main}
      />
      <path
        d="M126.703 224.832C126.815 224.773 126.931 224.723 127.05 224.681L128.068 224.289L131.891 222.901L145.048 218.249L144.935 218.491C144.279 216.515 143.563 214.404 142.778 212.255C141.542 208.87 140.253 205.695 138.933 202.868C138.35 201.522 137.641 200.234 136.814 199.022C136.116 197.962 135.144 197.11 134.002 196.557C132.314 195.791 130.456 195.477 128.611 195.644C128.114 195.701 127.628 195.834 127.171 196.036C127.021 196.134 126.865 196.219 126.703 196.293C126.703 196.293 126.703 196.255 126.809 196.202C126.908 196.113 127.017 196.034 127.133 195.969C127.586 195.725 128.079 195.564 128.588 195.494C130.469 195.261 132.379 195.54 134.115 196.3C135.313 196.862 136.337 197.738 137.078 198.834C137.93 200.054 138.66 201.354 139.257 202.717C140.607 205.544 141.904 208.749 143.148 212.119C143.902 214.276 144.656 216.387 145.289 218.37L145.35 218.551L145.176 218.611L131.974 223.135L128.113 224.417L127.073 224.749C126.954 224.793 126.829 224.821 126.703 224.832Z"
        fill="#263238"
      />
      <path
        d="M159.479 250.789C159.157 251.092 158.811 251.369 158.446 251.618C158.107 251.875 157.692 252.184 157.172 252.501C156.652 252.817 156.086 253.217 155.415 253.571C154.744 253.926 154.013 254.325 153.191 254.717C152.369 255.109 151.494 255.471 150.552 255.841C148.492 256.59 146.374 257.168 144.218 257.568C142.058 257.927 139.871 258.103 137.681 258.095C136.671 258.095 135.706 258.05 134.816 257.937C133.987 257.874 133.161 257.769 132.343 257.62C131.589 257.515 130.918 257.341 130.322 257.213C129.726 257.085 129.229 256.942 128.814 256.814C128.385 256.707 127.966 256.564 127.562 256.384C127.998 256.446 128.429 256.539 128.852 256.663C129.267 256.768 129.764 256.896 130.36 256.994C130.955 257.093 131.619 257.258 132.373 257.341C133.127 257.424 133.949 257.568 134.839 257.613C135.728 257.658 136.671 257.711 137.674 257.733C139.842 257.723 142.005 257.537 144.143 257.175C146.278 256.787 148.379 256.227 150.424 255.502C151.351 255.132 152.248 254.808 153.048 254.423C153.847 254.039 154.601 253.669 155.31 253.33C156.018 252.991 156.561 252.621 157.082 252.312C157.53 252.06 157.965 251.786 158.386 251.49C158.731 251.228 159.097 250.993 159.479 250.789Z"
        fill="#263238"
      />
      <path
        d="M159.571 213.867H153.758V216.619H159.571V213.867Z"
        fill="white"
      />
      <path
        d="M162.864 205.324C162.977 205.324 162.759 209.577 162.389 214.794C162.02 220.012 161.635 224.25 161.522 224.242C161.409 224.235 161.628 219.99 161.997 214.772C162.367 209.554 162.736 205.317 162.864 205.324Z"
        fill="#263238"
      />
      <path
        d="M112.859 224.832H57.9375V236.828H112.859V224.832Z"
        fill="#CE9E6C"
      />
      <path
        d="M116.561 236.953H54.2734V284.99H116.561V236.953Z"
        fill="#CE9E6C"
      />
      <path
        d="M100.952 284.662C100.885 284.662 100.824 273.955 100.824 260.745C100.824 247.535 100.885 236.828 100.952 236.828C101.02 236.828 101.073 247.535 101.073 260.745C101.073 273.955 101.02 284.662 100.952 284.662Z"
        fill="#263238"
      />
      <path
        d="M114.391 274.066H106.504V281.953H114.391V274.066Z"
        fill="#F5F5F5"
      />
      <path
        opacity="0.3"
        d="M80.3069 236.953H73.2344V247.208H80.3069V236.953Z"
        fill="white"
      />
      <path
        opacity="0.3"
        d="M80.346 274.746H73.2734V285H80.346V274.746Z"
        fill="white"
      />
      <path
        opacity="0.3"
        d="M116.561 236.828H100.953V285.129H116.561V236.828Z"
        fill="black"
      />
      <path
        d="M116.35 236.954C116.35 237.067 102.477 237.15 85.3683 237.15C68.26 237.15 54.3789 237.067 54.3789 236.954C54.3789 236.841 68.2525 236.758 85.3683 236.758C102.484 236.758 116.35 236.848 116.35 236.954Z"
        fill="#263238"
      />
      <path
        opacity="0.3"
        d="M112.858 224.832H97.4844V236.745H112.858V224.832Z"
        fill="black"
      />
      <path
        d="M97.3641 236.667C97.1702 234.741 97.1047 232.804 97.168 230.869C97.1044 228.934 97.1699 226.997 97.3641 225.07C97.5627 226.996 97.6282 228.934 97.5601 230.869C97.6279 232.804 97.5624 234.741 97.3641 236.667Z"
        fill="#263238"
      />
      <path
        d="M81.7949 224.832H74.0664V228.466H81.7949V224.832Z"
        fill="white"
      />
      <path
        d="M84.8853 225.064C84.8755 225.007 84.8755 224.948 84.8853 224.891L84.9456 224.371C84.9984 223.926 85.0964 223.262 85.2774 222.41C85.7637 220.001 86.6862 217.701 87.9993 215.624C88.4497 214.939 88.954 214.291 89.5073 213.686C90.0691 212.993 90.7416 212.396 91.4979 211.922C91.9264 211.665 92.4249 211.549 92.9229 211.59C93.1855 211.635 93.4326 211.745 93.642 211.909C93.8514 212.074 94.0163 212.288 94.1218 212.533C94.4506 213.508 94.4743 214.56 94.1897 215.549C93.6332 217.657 92.4846 219.562 90.8796 221.038C89.1673 222.578 87.2853 223.919 85.2698 225.034L84.9909 225.2L84.8778 225.268L84.7722 225.192C82.9093 223.87 81.1453 222.413 79.4942 220.834C77.9461 219.354 76.67 217.614 75.7242 215.692C75.4837 215.237 75.3037 214.753 75.1889 214.252C75.066 213.749 75.111 213.219 75.317 212.744C75.419 212.5 75.5787 212.285 75.7823 212.117C75.9859 211.949 76.2273 211.833 76.4857 211.779C76.9861 211.727 77.4879 211.861 77.8957 212.156C78.2663 212.417 78.6054 212.721 78.9061 213.061C79.2077 213.377 79.4867 213.702 79.7581 214.018C80.2746 214.633 80.7579 215.275 81.2058 215.941C82.5747 217.944 83.6251 220.146 84.3198 222.471C84.5024 223.1 84.6509 223.74 84.7647 224.386L84.8401 224.891C84.8434 224.949 84.8434 225.007 84.8401 225.064C84.8401 225.064 84.8401 225.012 84.7873 224.898L84.6742 224.401C84.5762 223.963 84.4178 223.323 84.1615 222.516C83.4252 220.237 82.3609 218.078 81.0022 216.107C80.5532 215.453 80.07 214.824 79.5545 214.222C79.2831 213.905 79.0041 213.588 78.7025 213.287C78.4155 212.966 78.0915 212.68 77.7374 212.435C77.3997 212.19 76.9839 212.077 76.5687 212.118C76.3665 212.159 76.1775 212.25 76.0184 212.381C75.8593 212.513 75.735 212.681 75.6563 212.872C75.2718 213.686 75.6563 214.674 76.071 215.541C77.0069 217.442 78.2674 219.164 79.7958 220.631C81.4307 222.193 83.177 223.635 85.021 224.944H84.8024L85.0813 224.778C87.0711 223.676 88.9302 222.353 90.6232 220.834C92.1813 219.42 93.3013 217.588 93.8504 215.556C94.1343 214.64 94.1343 213.66 93.8504 212.744C93.767 212.548 93.6356 212.376 93.4682 212.244C93.3008 212.112 93.1029 212.025 92.8928 211.99C92.468 211.955 92.043 212.055 91.6788 212.276C90.9505 212.731 90.299 213.299 89.7486 213.958C89.1984 214.549 88.6943 215.182 88.2406 215.85C86.9215 217.886 85.9697 220.137 85.4282 222.501C85.2321 223.338 85.1115 224.009 85.0286 224.438L84.9381 224.944L84.8853 225.064Z"
        fill="#263238"
      />
      <path
        d="M116.743 258.196C116.743 258.302 102.778 258.392 85.5646 258.392C68.3508 258.392 54.3867 258.302 54.3867 258.196C54.3867 258.09 68.3433 258 85.5646 258C102.786 258 116.743 258.083 116.743 258.196Z"
        fill="#263238"
      />
      <path
        d="M85.0085 285.77C84.903 285.77 84.8125 272.033 84.8125 255.09C84.8125 238.148 84.903 224.402 85.0085 224.402C85.1141 224.402 85.2046 238.14 85.2046 255.09C85.2046 272.04 85.1216 285.77 85.0085 285.77Z"
        fill="#263238"
      />
    </svg>
  );
};

SolutionSvg.propTypes = {};

export default SolutionSvg;
