<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Bank extends Model
{
    use HasFactory;

    protected $fillable = [
        'bank',
        'address',
        'bank_code',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    /**
     * ✅ Relation: Bank has many Branches
     */
    public function branches()
    {
        return $this->hasMany(Branch::class, 'bank_id');
    }

    /**
     * ✅ Scope: Only active banks
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }
}
