<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model; // ✅ Use Model, not Authenticatable (unless login needed)

class Customer extends Model
{
    use HasFactory;

    protected $table = 'customers';

    /**
     * Mass assignable attributes
     */
    protected $fillable = [
        'full_name',       // ✅ fixed (was name before)
        'email',
        'phone',
        'password',
        'address',
        'city',
        'state',
        'pincode',
        'is_active',
        'email_verified',
        'phone_verified',
        'last_login_at',
    ];

    /**
     * Attributes that should be hidden for arrays
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Cast attributes to native types
     */
    protected $casts = [
        'is_active' => 'boolean',
        'email_verified' => 'boolean',
        'phone_verified' => 'boolean',
        'last_login_at' => 'datetime',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    /**
     * Automatically hash password when setting
     */
    public function setPasswordAttribute($value)
    {
        if (!empty($value)) {
            $this->attributes['password'] = bcrypt($value);
        }
    }

    /**
     * A customer has many orders
     */
    public function orders()
    {
        return $this->hasMany(Order::class);
    }

    /**
     * A customer has many subscriptions
     */
    public function subscriptions()
    {
        return $this->hasMany(Subscription::class);
    }
}
