@extends('admin.layouts.app')

@section('title', 'Edit Agent')

@section('content')
    <div class="card">
        <div class="card-header bg-dark text-white">
            <h4 class="mb-0">✏️ Edit Agent</h4>
        </div>
        <div class="card-body">
            <form action="{{ route('admin.agent.update', $agent->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Bank</label>
                        <select name="bank_id" class="form-select" id="bankDropdown" required>
                            @foreach($banks as $bank)
                                <option value="{{ $bank->id }}" {{ $agent->bank_id == $bank->id ? 'selected' : '' }}>
                                    {{ $bank->bank }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Branch</label>
                        <select name="branch_id" class="form-select" id="branchDropdown" required>
                            @foreach($branches as $branch)
                                <option value="{{ $branch->id }}" {{ $agent->branch_id == $branch->id ? 'selected' : '' }}>
                                    {{ $branch->branch_address }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Mobile Number</label>
                        <input type="tel" name="mobile_number" value="{{ old('mobile_number', $agent->mobile_number) }}"
                            class="form-control" pattern="[0-9]{10}" maxlength="10" required
                            placeholder="Enter 10-digit mobile number">
                        @error('mobile_number')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">WhatsApp Number</label>
                        <input type="tel" name="whatsapp_number"
                            value="{{ old('whatsapp_number', $agent->whatsapp_number) }}" class="form-control"
                            pattern="[0-9]{10}" maxlength="10" placeholder="Enter WhatsApp number (optional)">
                        @error('whatsapp_number')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>

                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Designation</label>
                        <input type="text" name="designation" class="form-control" value="{{ $agent->designation }}"
                            required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Name</label>
                        <input type="text" name="name" class="form-control" value="{{ $agent->name }}" required>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Email</label>
                        <input type="email" name="email" class="form-control" value="{{ $agent->email }}" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Password</label>
                        <input type="password" name="password" class="form-control"
                            placeholder="Leave blank to keep current password">
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Profile Image</label>
                        <input type="file" name="image" class="form-control">
                        @if($agent->image)
                            <img src="{{ asset('storage/' . $agent->image) }}" width="80" class="mt-2 rounded">
                        @endif
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Status</label>
                        <select name="is_active" class="form-select">
                            <option value="1" {{ $agent->is_active ? 'selected' : '' }}>Active</option>
                            <option value="0" {{ !$agent->is_active ? 'selected' : '' }}>Inactive</option>
                        </select>
                    </div>
                </div>

                <div class="d-flex justify-content-end gap-2">
                    <button type="submit" class="btn btn-success">Update Agent</button>
                    <a href="{{ route('admin.agent.index') }}" class="btn btn-light">Cancel</a>
                </div>
            </form>
        </div>
    </div>

    {{-- ✅ Ajax script for dependent branch dropdown --}}
    <script>
        document.getElementById('bankDropdown').addEventListener('change', function () {
            let bankId = this.value;
            let branchDropdown = document.getElementById('branchDropdown');

            branchDropdown.innerHTML = '<option value="">Loading...</option>';

            fetch(`/admin/branches-by-bank/${bankId}`)
                .then(res => res.json())
                .then(data => {
                    branchDropdown.innerHTML = '<option value="">Select Branch</option>';
                    data.forEach(branch => {
                        branchDropdown.innerHTML += `<option value="${branch.id}">${branch.branch_address}</option>`;
                    });
                });
        });
    </script>
@endsection