@extends('admin.layouts.app')

@section('title', 'Add Branch')

@section('content')
    <div class="row">
        <div class="col-lg-10 offset-lg-1">
            <div class="card shadow-sm">
                <div class="card-header bg-dark text-white">
                    <h4 class="card-title mb-0">Add Branch</h4>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.branch.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        <div class="row">
                            {{-- Left Column --}}
                            <div class="col-md-6">
                                <!-- Bank -->
                                <div class="mb-3">
                                    <label class="form-label">Bank</label>
                                    <select name="bank_id" class="form-select" required>
                                        <option value="">Select Bank</option>
                                        @foreach($banks as $bank)
                                            <option value="{{ $bank->id }}">{{ $bank->bank }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <!-- Branch Address -->
                                <div class="mb-3">
                                    <label class="form-label">Branch Address</label>
                                    <input type="text" name="branch_address" class="form-control" required>
                                </div>
                            </div>

                            {{-- Right Column --}}
                            <div class="col-md-6">
                                <!-- Status -->
                                <div class="mb-3">
                                    <label class="form-label">Status</label>
                                    <select name="is_active" class="form-select">
                                        <option value="1">Active</option>
                                        <option value="0">Inactive</option>
                                    </select>
                                </div>


                            </div>
                        </div>

                        <div class="d-flex justify-content-end gap-2">
                            <button type="submit" class="btn btn-success">Save Branch</button>
                            <a href="{{ route('admin.branch.index') }}" class="btn btn-light">Cancel</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection