<?php $__env->startSection('title', 'Bank & Branch Management Dashboard'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <!-- Enhanced Page Header -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="page-title-box d-flex align-items-center justify-content-between p-3 rounded-3" style="background: linear-gradient(135deg, #4361ee 0%, #3a0ca3 100%);">
                    <div class="d-flex align-items-center">
                        <div class="avatar-md bg-white bg-opacity-20 rounded-circle d-flex align-items-center justify-content-center me-3">
                            <i class="ri-bar-chart-box-line text-white fs-4"></i>
                        </div>
                        <div>
                            <h4 class="mb-0 text-white">📊 Bank & Branch Management Dashboard</h4>
                            <p class="mb-0 text-white-50">Monitor your banking network at a glance</p>
                        </div>
                    </div>
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>" class="text-white-50">Home</a></li>
                            <li class="breadcrumb-item active text-white">Dashboard</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <!-- Statistics Cards with Enhanced Design -->
        <div class="row mb-4">
            <div class="col-xl-4 col-md-6 mb-4">
                <div class="card stat-card border-0 shadow-sm h-100">
                    <div class="card-body position-relative overflow-hidden">
                        <div class="d-flex align-items-center">
                            <div class="stat-icon bg-primary bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center me-3">
                                <i class="ri-bank-line text-primary fs-3"></i>
                            </div>
                            <div class="flex-grow-1">
                                <h3 class="mb-1 fw-bold"><?php echo e(number_format($stats['total_banks'])); ?></h3>
                                <p class="mb-1 text-muted">Total Banks</p>
                                <div class="d-flex align-items-center">
                                    <span class="badge bg-success bg-opacity-10 text-success border border-success border-opacity-25">
                                        <i class="ri-checkbox-circle-line me-1"></i><?php echo e($stats['active_banks']); ?> Active
                                    </span>
                                    <span class="badge bg-danger bg-opacity-10 text-danger border border-danger border-opacity-25 ms-2">
                                        <?php echo e($stats['total_banks'] - $stats['active_banks']); ?> Inactive
                                    </span>
                                </div>
                            </div>
                        </div>
                        
                    </div>
                    <div class="card-footer bg-transparent border-top-0 pt-0">
                        <a href="<?php echo e(route('admin.bank.index')); ?>" class="btn btn-sm btn-outline-primary w-100">
                            <i class="ri-external-link-line me-1"></i>Manage Banks
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-xl-4 col-md-6 mb-4">
                <div class="card stat-card border-0 shadow-sm h-100">
                    <div class="card-body position-relative overflow-hidden">
                        <div class="d-flex align-items-center">
                            <div class="stat-icon bg-success bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center me-3">
                                <i class="ri-building-4-line text-success fs-3"></i>
                            </div>
                            <div class="flex-grow-1">
                                <h3 class="mb-1 fw-bold"><?php echo e(number_format($stats['total_branches'])); ?></h3>
                                <p class="mb-1 text-muted">Total Branches</p>
                                <div class="d-flex align-items-center">
                                    <span class="badge bg-success bg-opacity-10 text-success border border-success border-opacity-25">
                                        <i class="ri-checkbox-circle-line me-1"></i><?php echo e($stats['active_branches']); ?> Active
                                    </span>
                                    <span class="badge bg-danger bg-opacity-10 text-danger border border-danger border-opacity-25 ms-2">
                                        <?php echo e($stats['total_branches'] - $stats['active_branches']); ?> Inactive
                                    </span>
                                </div>
                            </div>
                        </div>
                      
                    </div>
                    <div class="card-footer bg-transparent border-top-0 pt-0">
                        <a href="<?php echo e(route('admin.branch.index')); ?>" class="btn btn-sm btn-outline-success w-100">
                            <i class="ri-external-link-line me-1"></i>Manage Branches
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-xl-4 col-md-6 mb-4">
                <div class="card stat-card border-0 shadow-sm h-100">
                    <div class="card-body position-relative overflow-hidden">
                        <div class="d-flex align-items-center">
                            <div class="stat-icon bg-info bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center me-3">
                                <i class="ri-user-3-line text-info fs-3"></i>
                            </div>
                            <div class="flex-grow-1">
                                <h3 class="mb-1 fw-bold"><?php echo e(number_format($stats['total_agents'])); ?></h3>
                                <p class="mb-1 text-muted">Total Agents</p>
                                <div class="d-flex align-items-center">
                                    <span class="badge bg-success bg-opacity-10 text-success border border-success border-opacity-25">
                                        <i class="ri-checkbox-circle-line me-1"></i><?php echo e($stats['active_agents']); ?> Active
                                    </span>
                                    <span class="badge bg-danger bg-opacity-10 text-danger border border-danger border-opacity-25 ms-2">
                                        <?php echo e($stats['total_agents'] - $stats['active_agents']); ?> Inactive
                                    </span>
                                </div>
                            </div>
                        </div>
                       
                    </div>
                    <div class="card-footer bg-transparent border-top-0 pt-0">
                        <a href="<?php echo e(route('admin.agent.index')); ?>" class="btn btn-sm btn-outline-info w-100">
                            <i class="ri-external-link-line me-1"></i>Manage Agents
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-transparent border-0 py-3">
                        <h5 class="card-title mb-0">Quick Actions</h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-3 col-6">
                                <a href="<?php echo e(route('admin.bank.create')); ?>" class="btn btn-outline-primary d-flex flex-column align-items-center justify-content-center p-3 w-100 h-100 text-decoration-none">
                                    <i class="ri-add-circle-line fs-2 mb-2"></i>
                                    <span class="fw-medium">Add New Bank</span>
                                </a>
                            </div>
                            <div class="col-md-3 col-6">
                                <a href="<?php echo e(route('admin.branch.create')); ?>" class="btn btn-outline-success d-flex flex-column align-items-center justify-content-center p-3 w-100 h-100 text-decoration-none">
                                    <i class="ri-building-line fs-2 mb-2"></i>
                                    <span class="fw-medium">Add New Branch</span>
                                </a>
                            </div>
                            <div class="col-md-3 col-6">
                                <a href="<?php echo e(route('admin.agent.create')); ?>" class="btn btn-outline-info d-flex flex-column align-items-center justify-content-center p-3 w-100 h-100 text-decoration-none">
                                    <i class="ri-user-add-line fs-2 mb-2"></i>
                                    <span class="fw-medium">Add New Agent</span>
                                </a>
                            </div>
                            <div class="col-md-3 col-6">
                                <a href="#" class="btn btn-outline-warning d-flex flex-column align-items-center justify-content-center p-3 w-100 h-100 text-decoration-none">
                                    <i class="ri-file-chart-line fs-2 mb-2"></i>
                                    <span class="fw-medium">View Reports</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Branches and Agents -->
        <div class="row">
            <!-- Recent Branches -->
            <div class="col-xl-6 mb-4">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-header bg-transparent border-0 d-flex justify-content-between align-items-center py-3">
                        <h5 class="card-title mb-0 d-flex align-items-center">
                            <i class="ri-building-4-line text-primary me-2"></i>Recent Branches
                        </h5>
                        <a href="<?php echo e(route('admin.branch.index')); ?>" class="btn btn-sm btn-primary d-flex align-items-center">
                            <i class="ri-external-link-line me-1"></i>View All
                        </a>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th class="ps-4">#</th>
                                        <th>Bank</th>
                                        <th>Branch Address</th>
                                        <th class="text-center">Status</th>
                                        <th class="text-end pe-4">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $recentBranches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td class="ps-4 fw-medium"><?php echo e($branch->id); ?></td>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="flex-shrink-0">
                                                        <div class="bg-primary bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center" style="width: 32px; height: 32px;">
                                                            <i class="ri-bank-line text-primary fs-6"></i>
                                                        </div>
                                                    </div>
                                                    <div class="flex-grow-1 ms-2">
                                                        <?php echo e($branch->bank->bank ?? 'N/A'); ?>

                                                    </div>
                                                </div>
                                            </td>
                                            <td class="text-truncate" style="max-width: 200px;"><?php echo e($branch->branch_address); ?></td>
                                            <td class="text-center">
                                                <?php if($branch->is_active): ?>
                                                    <span class="badge bg-success bg-opacity-10 text-success border border-success border-opacity-25">
                                                        <i class="ri-checkbox-circle-line me-1"></i>Active
                                                    </span>
                                                <?php else: ?>
                                                    <span class="badge bg-danger bg-opacity-10 text-danger border border-danger border-opacity-25">
                                                        <i class="ri-close-circle-line me-1"></i>Inactive
                                                    </span>
                                                <?php endif; ?>
                                            </td>
                                            <td class="text-end pe-4">
                                                <div class="btn-group btn-group-sm">
                                                    <a href="<?php echo e(route('admin.branch.index')); ?>" class="btn btn-outline-primary btn-sm me-2">
                                                        <i class="ri-eye-line"></i>
                                                    </a>
                                                    <a href="<?php echo e(route('admin.branch.edit', $branch->id)); ?>" class="btn btn-outline-secondary btn-sm">
                                                        <i class="ri-edit-line"></i>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="5" class="text-center py-4">
                                                <div class="text-muted">
                                                    <i class="ri-inbox-line fs-1"></i>
                                                    <p class="mt-2">No branches found</p>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Recent Agents -->
            <div class="col-xl-6 mb-4">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-header bg-transparent border-0 d-flex justify-content-between align-items-center py-3">
                        <h5 class="card-title mb-0 d-flex align-items-center">
                            <i class="ri-user-3-line text-info me-2"></i>Recent Agents
                        </h5>
                        <a href="<?php echo e(route('admin.agent.index')); ?>" class="btn btn-sm btn-primary d-flex align-items-center">
                            <i class="ri-external-link-line me-1"></i>View All
                        </a>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th class="ps-4">#</th>
                                        <th>Name</th>
                                        <th>Bank</th>
                                        <th>Branch</th>
                                        <th class="text-center">Status</th>
                                        <th class="text-end pe-4">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $recentAgents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td class="ps-4 fw-medium"><?php echo e($agent->id); ?></td>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="flex-shrink-0">
                                                        <div class="bg-info bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center" style="width: 32px; height: 32px;">
                                                            <i class="ri-user-line text-info fs-6"></i>
                                                        </div>
                                                    </div>
                                                    <div class="flex-grow-1 ms-2">
                                                        <?php echo e($agent->name); ?>

                                                    </div>
                                                </div>
                                            </td>
                                            <td><?php echo e($agent->bank->bank ?? 'N/A'); ?></td>
                                            <td class="text-truncate" style="max-width: 150px;"><?php echo e($agent->branch->branch_address ?? 'N/A'); ?></td>
                                            <td class="text-center">
                                                <?php if($agent->is_active): ?>
                                                    <span class="badge bg-success bg-opacity-10 text-success border border-success border-opacity-25">
                                                        <i class="ri-checkbox-circle-line me-1"></i>Active
                                                    </span>
                                                <?php else: ?>
                                                    <span class="badge bg-danger bg-opacity-10 text-danger border border-danger border-opacity-25">
                                                        <i class="ri-close-circle-line me-1"></i>Inactive
                                                    </span>
                                                <?php endif; ?>
                                            </td>
                                            <td class="text-end pe-4">
                                                <div class="btn-group btn-group-sm">
                                                    <a href="<?php echo e(route('admin.agent.index')); ?>" class="btn btn-outline-primary btn-sm me-2">
                                                        <i class="ri-eye-line"></i>
                                                    </a>
                                                    <a href="<?php echo e(route('admin.agent.edit',$agent->id)); ?>" class="btn btn-outline-secondary btn-sm">
                                                        <i class="ri-edit-line"></i>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="6" class="text-center py-4">
                                                <div class="text-muted">
                                                    <i class="ri-user-unfollow-line fs-1"></i>
                                                    <p class="mt-2">No agents found</p>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .stat-card {
            transition: transform 0.2s ease, box-shadow 0.2s ease;
        }
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.1) !important;
        }
        .stat-icon {
            width: 60px;
            height: 60px;
        }
        .page-title-box {
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .table > :not(caption) > * > * {
            padding: 0.75rem 0.5rem;
        }
        .btn-group .btn {
            border-radius: 0.375rem !important;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\LENOVO\Desktop\loanmanagement\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>