<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Role::create(['name' => 'admin']);
        Role::create(['name' => 'instructor']);

        $permissions = Permission::all();

        foreach ($permissions as $permission) {
            $role = Role::where('name', 'admin')->first();
            $role->givePermissionTo($permission);
        }

        $permissions = Permission::all()->skip(94)->take(7);

        foreach ($permissions as $permission) {
            $role = Role::where('name', 'instructor')->first();
            $role->givePermissionTo($permission);
        }
    }
}
