@extends('layouts.app')

@section('title', $app_setting['name'] . ' | Chapter Update')

@section('content')

    <style>
        .hidden {
            display: none;
        }
    </style>

    <!-- ****Body-Section***** -->
    <div class="app-main-outer">
        <div class="app-main-inner">
            <div class="page-title-actions px-3 d-flex">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('course.index') }}">Course</a></li>
                        <li class="breadcrumb-item"><a
                                href="{{ $chapter->course ? route('chapter.index', $chapter->course?->id) : route('chapter.select_course') }}">Chapter</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">Edit</li>
                    </ol>
                </nav>
            </div>

            {{-- <div class="row" id="deleteTableItem">
                <div class="col-md-12">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul class="m-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <div class="main-card card d-flex h-100 flex-column">
                        <div class="card-body">
                            <h5 class="card-title py-2">Edit Chapter</h5>
                            <form action="{{ route('chapter.update', $chapter->id) }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf @method('PUT')
                                <div class="row">
                                    <div class="col-4">
                                        <div class="form-group">
                                            <label class="form-label" for="categoryInput">Course</label>
                                            <select id="categoryInput"
                                                class="form-select " name="course_id"
                                                aria-hidden="true">
                                                @foreach ($courses as $course)
                                                    <option value="{{ $course->id }}"
                                                        {{ $course->id === $chapter->course?->id ? 'selected="selected"' : '' }}>
                                                        {{ $course->title }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-4">
                                        <div class="mb-3">
                                            <label for="titleInput" class="form-label">Chapter Title</label>
                                            <input type="text" name="title" required class="form-control"
                                                value="{{ $chapter->title }}" id="titleInput">
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="mb-3">
                                            <label for="titleInput" class="form-label">Sequence</label>
                                            <input type="number" required value="{{ $chapter->serial_number }}"
                                                min="1" name="serial_number" class="form-control" id="titleInput"
                                                value="{{ $course->chapters()->count() + 1 }}">
                                        </div>
                                    </div>

                                    <div class="col-12">
                                        <label for="" class="form-label">Contents</label>
                                        <div id="contentsWrapper">

                                            @php $contentCounter = 1; @endphp
                                            @if (old('contents'))
                                                @foreach (old('contents', [1 => ['title' => '', 'serial_number' => 1]]) as $key => $content)
                                                    <div id="content{{ $key }}"
                                                        class="row border p-3 mb-3 d-flex align-items-center">
                                                        <div class="col-3">
                                                            <div class="mb-3">
                                                                <label class="form-label">Content Title</label>
                                                                <input type="text" required
                                                                    name="contents[{{ $key }}][title]"
                                                                    class="form-control" placeholder="Enter content title"
                                                                    value="{{ old("contents.$key.title") }}">
                                                            </div>
                                                        </div>

                                                        <div class="col-1">
                                                            <div class="mb-3">
                                                                <label class="form-label">Sequence</label>
                                                                <input type="number" min="1" required
                                                                    name="contents[{{ $key }}][serial_number]"
                                                                    class="form-control"
                                                                    value="{{ old("contents.$key.serial_number", $key) }}">
                                                            </div>
                                                        </div>

                                                        <div class="col-2">
                                                            <div class="mb-3">
                                                                <label for="fileInput" class="form-label">Select Video
                                                                    Type</label>
                                                                <select class="form-select videoTypeSelect"
                                                                    name="contents[{{ $key }}][video_type]"
                                                                    data-key="{{ $key }}">
                                                                    <option value="0">----Select Option----</option>
                                                                    <option value="upload"
                                                                        {{ old("contents.$key.video_type") == 'upload' ? 'selected' : '' }}>
                                                                        Upload Files</option>
                                                                    <option value="link"
                                                                        {{ old("contents.$key.video_type") == 'link' ? 'selected' : '' }}>
                                                                        Cloud Link</option>
                                                                </select>
                                                            </div>
                                                        </div>

                                                        <div class="col-2 {{ old("contents.$key.video_type") == 'upload' ? '' : 'hidden' }}"
                                                            id="uploadSection{{ $key }}">
                                                            <div class="mb-3">
                                                                <label for="fileInput" class="form-label">Upload
                                                                    File</label>
                                                                <input name="contents[{{ $key }}][media]"
                                                                    type="file" class="form-control">
                                                            </div>
                                                        </div>

                                                        <div class="col-2 {{ old("contents.$key.video_type") == 'link' ? '' : 'hidden' }}"
                                                            id="linkSection{{ $key }}">
                                                            <div class="mb-3">
                                                                <label for="fileInput" class="form-label">Upload Link (only
                                                                    embed link)</label>
                                                                <input name="contents[{{ $key }}][link]"
                                                                    type="text" class="form-control"
                                                                    value="{{ old("contents.$key.link") }}"
                                                                    placeholder="Enter Video Links">
                                                            </div>
                                                        </div>

                                                        <div class="col-2 {{ old("contents.$key.video_type") == 'link' ? '' : 'hidden' }}"
                                                            id="duration{{ $key }}">
                                                            <div class="mb-3">
                                                                <label for="fileInput" class="form-label">Set
                                                                    Duration</label>
                                                                <input name="contents[{{ $key }}][duration]"
                                                                    type="number" class="form-control"
                                                                    value="{{ old("contents.$key.duration") }}"
                                                                    placeholder="Enter Link Duration">
                                                            </div>
                                                        </div>

                                                        <div class="col-1">
                                                            <div class="form-check">
                                                                <input
                                                                    name="contents[{{ $key }}][is_forwardable]"
                                                                    class="form-check-input" type="checkbox"
                                                                    {{ old("contents.$key.is_forwardable") ? 'checked' : '' }}
                                                                    id="isForwardable{{ $key }}">
                                                                <label class="form-check-label"
                                                                    for="isForwardable{{ $key }}">Forwardable</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-1">
                                                            <div class="form-check">
                                                                <input name="contents[{{ $key }}][is_free]"
                                                                    class="form-check-input" type="checkbox"
                                                                    {{ old("contents.$key.is_free") ? 'checked' : '' }}
                                                                    id="isFree{{ $key }}">
                                                                <label class="form-check-label"
                                                                    for="isFree{{ $key }}">Free Content</label>
                                                            </div>
                                                        </div>

                                                        <div class="col-2">
                                                            <button type="button" class="btn btn-danger mb-4"
                                                                onclick="removeContentItem({{ $key }})">- Remove
                                                                Content</button>
                                                        </div>
                                                    </div>
                                                    @php $contentCounter++; @endphp
                                                @endforeach
                                            @else
                                                @foreach ($chapter->contents as $key => $content)
                                                    <div id="content{{ $key }}" class="row border p-3 mb-3">
                                                        <input name="contents[{{ $key }}][content_id]"
                                                            type="hidden" value="{{ $content->id }}">
                                                        <div class="col-3">
                                                            <div class="mb-3">
                                                                <label for="titleInput" class="form-label">Content
                                                                    Title</label>
                                                                <input type="text" required
                                                                    name="contents[{{ $key }}][title]"
                                                                    class="form-control" id="titleInput"
                                                                    value="{{ $content->title }}">
                                                            </div>
                                                        </div>

                                                        <div class="col-1">
                                                            <div class="mb-3">
                                                                <label for="titleInput"
                                                                    class="form-label">Sequence</label>
                                                                <input type="number" required min="1"
                                                                    value="{{ $content->serial_number }}"
                                                                    name="contents[{{ $key }}][serial_number]"
                                                                    class="form-control" id="titleInput">
                                                            </div>
                                                        </div>

                                                        <div class="col-2">
                                                            <div class="mb-3">
                                                                <label for="fileInput" class="form-label">Select Video
                                                                    Type</label>
                                                                <select class="form-select videoTypeSelect"
                                                                    name="contents[{{ $key }}][video_type]"
                                                                    data-key="{{ $key }}">
                                                                    <option value="0">----Select Option----</option>
                                                                    <option value="upload"
                                                                        {{ $content?->media_id ? 'selected' : '' }}>Upload
                                                                        Files</option>
                                                                    <option value="link"
                                                                        {{ !$content?->media_id == 'link' ? 'selected' : '' }}>
                                                                        Cloud Link</option>
                                                                </select>
                                                            </div>
                                                        </div>

                                                        <div class="col-2 {{ $content?->media_id ? '' : 'hidden' }}"
                                                            id="uploadSection{{ $key }}">
                                                            <div class="mb-3">
                                                                <label for="fileInput" class="form-label">Upload
                                                                    File</label>
                                                                <input name="contents[{{ $key }}][media]"
                                                                    type="file" class="form-control">
                                                                <div class="mt-2">
                                                                    <strong
                                                                        class="text-primary">{{ '...' . substr(str_replace($content->media?->path . '/', '', $content->media?->src), -20) }}</strong>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-2 {{ !$content?->media_id ? '' : 'hidden' }}"
                                                            id="linkSection{{ $key }}">
                                                            <div class="mb-3">
                                                                <label for="fileInput" class="form-label">Upload Link
                                                                    (only embed link)
                                                                </label>
                                                                <input name="contents[{{ $key }}][link]"
                                                                    type="text" class="form-control"
                                                                    value="{{ $content->media_link ? $content->media_link : old("contents'.$key.'link") }}">
                                                            </div>
                                                        </div>

                                                        <div class="col-2 {{ !$content?->media_id ? '' : 'hidden' }}"
                                                            id="duration{{ $key }}">
                                                            <div class="mb-3">
                                                                <label for="fileInput" class="form-label">Set
                                                                    Duration</label>
                                                                <input name="contents[{{ $key }}][duration]"
                                                                    type="number" class="form-control"
                                                                    value="{{ $content?->duration ? $content?->duration : old("contents.$key.duration") }}">
                                                            </div>
                                                        </div>

                                                        <div class="col-1">
                                                            <div class="mb-3">
                                                                <label for="fileInput" class="form-label">&nbsp;</label>
                                                                <div class="form-check">
                                                                    <input id="isForwardable{{ $key }}"
                                                                        class="form-check-input" type="checkbox"
                                                                        @if ($content->is_forwardable) checked @endif>
                                                                    <label class="form-check-label"
                                                                        for="isForwardable{{ $key }}">Forwardable</label>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-1">
                                                            <div class="mb-3">
                                                                <label for="fileInput" class="form-label">&nbsp;</label>
                                                                <div class="form-check">
                                                                    <input id="isFree{{ $key }}"
                                                                        name="contents[{{ $key }}][is_free]"
                                                                        class="form-check-input" type="checkbox"
                                                                        @if ($content->is_free) checked @endif>
                                                                    <label class="form-check-label"
                                                                        for="isFree{{ $key }}">Free
                                                                        Content</label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-2">
                                                            <label class="form-label">&nbsp;</label>
                                                            <div>
                                                                <button type="button" class="btn btn-danger mb-4"
                                                                    onclick="removeContentItem({{ $key }})">-
                                                                    Remove Content</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            @endif
                                        </div>


                                        <button type="button" class="btn bgBlue btn-dipBlue mb-4"
                                            onclick="addContentItem()">+
                                            Add Content
                                            Item</button>
                                    </div>


                                    <div class="col-12">
                                        <button type="submit" class="btn bgBlue btn-dipBlue">Update</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div> --}}

            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-body">
                            <h3 class="m-0 p-0">
                                {{ __('Edit Chapter') }}</h3>
                        </div>
                    </div>
                </div>
            </div>

            <form action="{{ route('chapter.update', $chapter->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')

                @if ($errors->any())
                    <div class="row">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-body">

                                    <div class="alert alert-danger">
                                        <ul class="m-0">
                                            @foreach ($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                @endif

                <div class="row">
                    <div class="col-md-12 my-3">
                        <div class="card">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-4">
                                        <label class="form-label" for="categoryInput">Course Title <span
                                                class="text-danger fw-bold">*</span></label>
                                        <select id="categoryInput" class="form-select form-control " name="course_id"
                                            aria-hidden="true">
                                            @foreach ($courses as $course)
                                                <option value="{{ $course->id }}"
                                                    {{ $course->id === $chapter->course?->id ? 'selected="selected"' : '' }}>
                                                    {{ $course->title }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="chapterTitle" class="form-label">Chapter Title <span
                                                class="text-danger fw-bold">*</span></label>
                                        <input type="text" class="form-control" id="chapterTitle" name="title"
                                            value="{{ $chapter->title }}" />
                                        @error('title')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-md-4">
                                        <label for="chapterSequence" class="form-label">Sequence <span
                                                class="text-danger fw-bold">*</span></label>
                                        <input type="text" class="form-control" id="chapterSequence" name="serial_number"
                                            value="{{ $chapter->serial_number }}" />
                                        @error('serial_number')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="row">
                    <div class="col-md-12 mb-1">
                        <div class="card">
                            <div class="card-body">
                                <h6 class="m-0 p-0">
                                    {{ __('Contents') }}</h6>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="startContentBody">
                                    <div id="contentsWrapper">
                                        @php $contentCounter = 1; @endphp

                                        @if (old('contents'))
                                            @forelse (old('contents', [1 => ['title' => '', 'serial_number' => 1]]) as $key => $content)
                                                <div id="content{{ $key }}"
                                                    class="row d-flex align-items-center border border-primary border-2 p-3 rounded-4 mb-5">
                                                    <div class="col-6 mb-3">
                                                        <div class="d-flex align-items-center gap-3">
                                                            <div class="forwardable">
                                                                <div class="form-check">
                                                                    <input
                                                                        name="contents[{{ $key }}][is_forwardable]"
                                                                        class="form-check-input"
                                                                        id="isForwardable{{ $key }}"
                                                                        type="checkbox"
                                                                        {{ old("contents.$key.is_forwardable") ? 'checked' : '' }}>
                                                                    <label class="form-check-label"
                                                                        for="isForwardable{{ $key }}">Forwardable</label>
                                                                </div>
                                                            </div>
                                                            <div class="isFree">
                                                                <div class="form-check">
                                                                    <input name="contents[{{ $key }}][is_free]"
                                                                        class="form-check-input" type="checkbox"
                                                                        {{ old("contents.$key.is_free") ? 'checked' : '' }}
                                                                        id="isFree{{ $key }}">
                                                                    <label class="form-check-label"
                                                                        for="isFree{{ $key }}">Free
                                                                        Content</label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-6 mb-3 d-flex justify-content-end align-items-center">
                                                        @if (old("contents.$key.title"))
                                                            <button type="button" class="btn btn-outline-danger"
                                                                onclick="removeContentItem({{ $key }})">
                                                                Remove Content -</button>
                                                        @endif
                                                    </div>
                                                    <div class="col-3">
                                                        <div class="">
                                                            <label class="form-label">Content Title</label>
                                                            <input type="text"
                                                                name="contents[{{ $key }}][title]"
                                                                class="form-control" placeholder="Enter content title"
                                                                value="{{ old("contents.$key.title") }}">
                                                        </div>
                                                    </div>

                                                    <div class="col-1">
                                                        <div class="">
                                                            <label class="form-label">Sequence</label>
                                                            <input type="number" min="1"
                                                                name="contents[{{ $key }}][serial_number]"
                                                                class="form-control"
                                                                value="{{ old("contents.$key.serial_number", $key) }}">
                                                        </div>
                                                    </div>

                                                    <div class="col-2">
                                                        <div class="">
                                                            <label for="fileInput" class="form-label">Select File
                                                                Type</label>
                                                            <select class="form-select form-control videoTypeSelect"
                                                                name="contents[{{ $key }}][video_type]"
                                                                data-key="{{ $key }}">
                                                                <option value="0">----Select Option----</option>
                                                                <option value="upload"
                                                                    {{ old("contents.$key.video_type") == 'upload' ? 'selected' : '' }}>
                                                                    Upload Files</option>
                                                                <option value="link"
                                                                    {{ old("contents.$key.video_type") == 'link' ? 'selected' : '' }}>
                                                                    Cloud Link</option>
                                                            </select>
                                                        </div>
                                                    </div>

                                                    <div class="col-6 {{ old("contents.$key.video_type") == 'upload' ? '' : 'hidden' }}"
                                                        id="uploadSection{{ $key }}">
                                                        <div class="">
                                                            <h4 class="form-label">Upload File (Document, Audio, Video,
                                                                Image)
                                                            </h4>
                                                            <label for="formFileUpload"
                                                                class="w-100 border rounded-3 d-flex align-items-center gap-2">
                                                                <div class="d-flex justify-content-center align-items-center gap-2 p-2"
                                                                    style="width: 160px; background-color: #EDEEF1">
                                                                    <span>Choose a file</span>
                                                                    <img src="/assets/images/media/file-plus.svg">
                                                                </div>
                                                                <div>
                                                                    <span id="fileLinkPreview"></span>
                                                                </div>
                                                            </label>
                                                            <input id="formFileUpload"
                                                                class="form-control form-control-lg" type="file"
                                                                accept="video/mp4"
                                                                name="contents[{{ $key }}][media]"
                                                                onchange="document.getElementById('fileLinkPreview').innerHTML = window.URL.createObjectURL(this.files[0])"
                                                                hidden />
                                                        </div>
                                                    </div>

                                                    <div class="col-3 {{ old("contents.$key.video_type") == 'link' ? '' : 'hidden' }}"
                                                        id="linkSection{{ $key }}">
                                                        <div class="">
                                                            <label for="fileInput" class="form-label">Upload Link (only
                                                                embed link)</label>
                                                            <input name="contents[{{ $key }}][link]"
                                                                type="text" class="form-control"
                                                                value="{{ old("contents.$key.link") }}"
                                                                placeholder="Enter Video Links">
                                                        </div>
                                                    </div>

                                                    <div class="col-3 {{ old("contents.$key.video_type") == 'link' ? '' : 'hidden' }}"
                                                        id="duration{{ $key }}">
                                                        <div class="">
                                                            <label for="fileInput" class="form-label">Set Duration</label>
                                                            <input name="contents[{{ $key }}][duration]"
                                                                type="number" class="form-control"
                                                                value="{{ old("contents.$key.duration") }}"
                                                                placeholder="Enter Link Duration">
                                                        </div>
                                                    </div>

                                                </div>
                                                @php $contentCounter++; @endphp
                                            @empty
                                                <div>
                                                    <h5 class="text-danger text-center m-0">no content available</h5>
                                                </div>
                                            @endforelse
                                        @else
                                            @forelse ($chapter->contents as $key => $content)
                                                <div id="content{{ $key }}"
                                                    class="row d-flex align-items-center border border-primary border-2 p-3 rounded-4 mb-5">
                                                    <input name="contents[{{ $key }}][content_id]"
                                                        type="hidden" value="{{ $content->id }}">
                                                    <div class="col-6 mb-3">
                                                        <div class="d-flex align-items-center gap-3">
                                                            <div class="forwardable">
                                                                <div class="form-check">
                                                                    <input
                                                                        name="contents[{{ $key }}][is_forwardable]"
                                                                        class="form-check-input"
                                                                        id="isForwardable{{ $key }}"
                                                                        type="checkbox"
                                                                        @if ($content->is_forwardable) checked @endif>
                                                                    <label class="form-check-label"
                                                                        for="isForwardable{{ $key }}">Forwardable</label>
                                                                </div>
                                                            </div>
                                                            <div class="isFree">
                                                                <div class="form-check">
                                                                    <input name="contents[{{ $key }}][is_free]"
                                                                        class="form-check-input" type="checkbox"
                                                                        @if ($content->is_free) checked @endif
                                                                        id="isFree{{ $key }}">
                                                                    <label class="form-check-label"
                                                                        for="isFree{{ $key }}">Free
                                                                        Content</label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-6 mb-3 d-flex justify-content-end align-items-center">
                                                        <button type="button" class="btn btn-outline-danger"
                                                            onclick="removeContentItem({{ $key }})">
                                                            Remove Content -</button>
                                                    </div>
                                                    <div class="col-3">
                                                        <div class="">
                                                            <label class="form-label">Content Title</label>
                                                            <input type="text"
                                                                name="contents[{{ $key }}][title]"
                                                                class="form-control" placeholder="Enter content title"
                                                                value="{{ $content->title }}">
                                                        </div>
                                                    </div>

                                                    <div class="col-1">
                                                        <div class="">
                                                            <label class="form-label">Sequence</label>
                                                            <input type="number" min="1"
                                                                name="contents[{{ $key }}][serial_number]"
                                                                class="form-control"
                                                                value="{{ $content->serial_number }}">
                                                        </div>
                                                    </div>

                                                    <div class="col-2">
                                                        <div class="">
                                                            <label for="fileInput" class="form-label">Select File
                                                                Type</label>
                                                            <select class="form-select form-control videoTypeSelect"
                                                                name="contents[{{ $key }}][video_type]"
                                                                data-key="{{ $key }}">
                                                                <option value="0">----Select Option----</option>
                                                                <option value="upload"
                                                                    {{ $content?->media_id ? 'selected' : '' }}>
                                                                    Upload Files</option>
                                                                <option value="link"
                                                                    {{ !$content?->media_id ? 'selected' : '' }}>
                                                                    Cloud Link</option>
                                                            </select>
                                                        </div>
                                                    </div>

                                                    <div class="col-6 {{ $content?->media_id ? '' : 'hidden' }}"
                                                        id="uploadSection{{ $key }}">
                                                        <div class="">
                                                            <h4 class="form-label">Upload File (Document, Audio, Video,
                                                                Image)
                                                            </h4>
                                                            <label for="formFileUpload"
                                                                class="w-100 border rounded-3 d-flex align-items-center gap-2">
                                                                <div class="d-flex justify-content-center align-items-center gap-2 p-3"
                                                                    style="width: 160px; background-color: #EDEEF1">
                                                                    <span>Choose a file</span>
                                                                    <img src="/assets/images/media/file-plus.svg">
                                                                </div>
                                                                <div>
                                                                    <span
                                                                        id="fileLinkPreview">{{ '...' . substr(str_replace($content->media?->path . '/', '', $content->media?->src), -20) }}</span>
                                                                </div>
                                                            </label>
                                                            <input id="formFileUpload"
                                                                class="form-control form-control-lg" type="file"
                                                                accept="video/mp4"
                                                                name="contents[{{ $key }}][media]"
                                                                onchange="document.getElementById('fileLinkPreview').innerHTML = window.URL.createObjectURL(this.files[0])"
                                                                hidden />
                                                        </div>
                                                    </div>

                                                    <div class="col-3 {{ !$content?->media_id ? '' : 'hidden' }}"
                                                        id="linkSection{{ $key }}">
                                                        <div class="">
                                                            <label for="fileInput" class="form-label">Upload Link (only
                                                                embed link)</label>
                                                            <input name="contents[{{ $key }}][link]"
                                                                type="text" class="form-control"
                                                                value="{{ $content->media_link ? $content->media_link : old("contents'.$key.'link") }}"
                                                                placeholder="Enter Video Links">
                                                        </div>
                                                    </div>

                                                    <div class="col-3 {{ old("contents.$key.video_type") == 'link' ? '' : 'hidden' }}"
                                                        id="duration{{ $key }}">
                                                        <div class="">
                                                            <label for="fileInput" class="form-label">Set Duration</label>
                                                            <input name="contents[{{ $key }}][duration]"
                                                                type="number" class="form-control"
                                                                value="{{ $content?->duration ? $content?->duration : old("contents.$key.duration") }}"
                                                                placeholder="Enter Link Duration">
                                                        </div>
                                                    </div>

                                                </div>
                                                @php $contentCounter++; @endphp
                                            @empty
                                                <div>
                                                    <h5 class="text-danger text-center m-0">no content available</h5>
                                                </div>
                                            @endforelse
                                        @endif


                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="row">
                    <div class="col-md-12 mt-2">
                        <div class="card">
                            <div class="card-body">
                                <div class="row align-items-center">
                                    <div class="col-md-6">
                                        <button type="submit"
                                            class="btn btn-primary px-5 py-2">{{ __('Create') }}</button>
                                    </div>
                                    <div class="col-md-6 d-flex justify-content-end">
                                        <button type="button" class="btn btn-outline-primary"
                                            onclick="addContentItem(0)">Add New Content Item +</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </form>

            <!-- ****End-Body-Section**** -->
        </div>
    </div>

@endsection
@push('scripts')
    <script>
        var contentCounter = contentsWrapper.childElementCount + 1;

        function addContentItem() {
            var contentRow = `
                <div id="content${contentCounter}" class="row d-flex align-items-center border border-primary border-2 p-3 rounded-4 mb-5">
                            <div class="col-6 my-3">
                                <div class="d-flex align-items-center gap-3">
                                    <div class="forwardable">
                                        <div class="form-check">
                                            <input name="contents[${contentCounter}][is_forwardable]"
                                                class="form-check-input"
                                                id="isForwardable${contentCounter}" type="checkbox">
                                            <label class="form-check-label"
                                                for="isForwardable${contentCounter}">Forwardable</label>
                                        </div>
                                    </div>
                                    <div class="isFree">
                                        <div class="form-check">
                                            <input name="contents[${contentCounter}][is_free]"
                                                class="form-check-input" type="checkbox"
                                                id="isFree${contentCounter}">
                                            <label class="form-check-label"
                                                for="isFree${contentCounter}">Free
                                                Content</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6 my-3 d-flex justify-content-end align-items-center">
                                    <button type="button" class="btn btn-outline-danger"
                                        onclick="removeContentItem(${contentCounter})">
                                        Remove Content -</button>
                            </div>
                            <div class="col-3">
                                <div class="">
                                    <label class="form-label">Content Title</label>
                                    <input type="text"
                                        name="contents[${contentCounter}][title]" class="form-control"
                                        placeholder="Enter content title"
                                        value="{{ old("contents.${contentCounter}.title") }}">
                                </div>
                            </div>

                            <div class="col-1">
                                <div class="">
                                    <label class="form-label">Sequence</label>
                                    <input type="number" min="1" value="${contentCounter}"
                                        name="contents[${contentCounter}][serial_number]"
                                        class="form-control">
                                </div>
                            </div>

                            <div class="col-2">
                                <div class="">
                                    <label for="fileInput" class="form-label">Select File
                                        Type</label>
                                    <select class="form-select form-control videoTypeSelect"
                                        name="contents[${contentCounter}][video_type]"
                                        data-key="${contentCounter}">
                                        <option value="0">----Select Option----</option>
                                        <option value="upload" selected>
                                            Upload Files</option>
                                        <option value="link">
                                            Cloud Link</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-6"
                                id="uploadSection${contentCounter}">
                                <div class="">
                                    <h4 class="form-label">Upload File (Document, Audio, Video, Image)
                                    </h4>
                                    <label for="formFileUpload${contentCounter}"
                                        class="w-100 border rounded-3 d-flex align-items-center gap-2">
                                        <div class="d-flex justify-content-center align-items-center gap-2 p-3"
                                            style="width: 160px; background-color: #EDEEF1">
                                            <span>Choose a file</span>
                                            <img src="/assets/images/media/file-plus.svg">
                                        </div>
                                        <div>
                                            <span id="fileLinkPreview${contentCounter}"></span>
                                        </div>
                                    </label>
                                    <input id="formFileUpload${contentCounter}" class="form-control form-control-lg"
                                        type="file" accept="video/mp4"
                                        name="contents[${contentCounter}][media]"
                                        onchange="document.getElementById('fileLinkPreview${contentCounter}').innerHTML = window.URL.createObjectURL(this.files[0])"
                                        hidden />
                                </div>
                            </div>

                            <div class="col-3 {{ old("contents.${contentCounter}.video_type") == 'link' ? '' : 'hidden' }}"
                                id="linkSection${contentCounter}">
                                <div class="">
                                    <label for="fileInput" class="form-label">Upload Link (only
                                        embed link)</label>
                                    <input name="contents[${contentCounter}][link]" type="text"
                                        class="form-control" value="{{ old("contents.${contentCounter}.link") }}"
                                        placeholder="Enter Video Links">
                                </div>
                            </div>

                            <div class="col-3 {{ old("contents.${contentCounter}.video_type") == 'link' ? '' : 'hidden' }}"
                                id="duration${contentCounter}">
                                <div class="">
                                    <label for="fileInput" class="form-label">Set Duration</label>
                                    <input name="contents[${contentCounter}][duration]" type="number"
                                        class="form-control" value="{{ old("contents.${contentCounter}.duration") }}"
                                        placeholder="Enter Link Duration">
                                </div>
                            </div>

                        </div>
            `;

            $('#contentsWrapper').append(contentRow);

            $(`#content${contentCounter} #videoTypeSelect`).on('change', function() {
                const selectedValue = $(this).val();
                const counter = $(this).data('counter');

                // Hide all sections
                $(`#uploadSection${counter}`).addClass('hidden');
                $(`#linkSection${counter}`).addClass('hidden');
                $(`#duration${counter}`).addClass('hidden');

                // Show the selected section
                if (selectedValue === 'upload') {
                    $(`#uploadSection${counter}`).removeClass('hidden');
                } else if (selectedValue === 'link') {
                    $(`#linkSection${counter}`).removeClass('hidden');
                    $(`#duration${counter}`).removeClass('hidden');
                }
            });

            ++contentCounter;
        }

        function removeContentItem(elementNumber) {
            $(`#content${elementNumber}`).remove();
        }
    </script>

    <script>
        // Event delegation for videoTypeSelect changes
        document.addEventListener('DOMContentLoaded', function() {
            const contentsWrapper = document.getElementById('contentsWrapper');

            contentsWrapper.addEventListener('change', function(event) {
                if (event.target.classList.contains('videoTypeSelect')) {
                    const selectedValue = event.target.value;
                    const key = event.target.getAttribute('data-key');

                    // Hide all sections
                    document.getElementById(`uploadSection${key}`).classList.add('hidden');
                    document.getElementById(`linkSection${key}`).classList.add('hidden');
                    document.getElementById(`duration${key}`).classList.add('hidden');

                    // Show the appropriate section based on the selection
                    if (selectedValue === 'upload') {
                        document.getElementById(`uploadSection${key}`).classList.remove('hidden');
                    } else if (selectedValue === 'link') {
                        document.getElementById(`linkSection${key}`).classList.remove('hidden');
                        document.getElementById(`duration${key}`).classList.remove('hidden');
                    }
                }
            });
        });
    </script>
@endpush
