@extends('layouts.app')

@section('title', $app_setting['name'] . ' | Select Quiz Course')

@section('content')
    <!-- ****Body-Section***** -->
    <div class="app-main-outer">
        <div class="app-main-inner">
            <h3 class="mb-4 px-3 bg-primary-light text-dark p-4 rounded text-uppercase">Select a course to view quizzes</h3>
            <div class="row">
                <div class="row" id="deleteTableItem">
                    <div class="col-md-12">
                        <div class="card mb-5">
                            <div class="card-body">
                                <div class="table-responsive-lg">
                                    <table id="dataTable" class="table">
                                        <thead>
                                            <tr>
                                                <th><strong>Category Name</strong></th>
                                                <th><strong>Category</strong></th>
                                                <th><strong>Price</strong></th>
                                                <th><strong>Action</strong></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($courses as $course)
                                                <tr>
                                                    <td class="tableProduct">
                                                        <div class="listproduct-section">
                                                            <div class="listproducts-image">
                                                                <img src="{{ $course?->mediaPath }}">
                                                            </div>
                                                            <div class="product-pera">
                                                                <a href="{{ route('course.edit', $course->id) }}"
                                                                    class="priceDis">{{ $course?->title }}</a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td class="tableId">{{ $course->category?->title }}</td>
                                                    <td class="tableId">
                                                        @php
                                                            $price =
                                                                $course->price && $course->regular_price
                                                                    ? $course->price
                                                                    : $course->regular_price;
                                                        @endphp
                                                        @if ($app_setting['currency_position'] == 'Left')
                                                            {{ $app_setting['currency_symbol'] }}{{ $price }}
                                                        @else
                                                            {{ $price }}{{ $app_setting['currency_symbol'] }}
                                                        @endif
                                                    </td>
                                                    <td class="tableAction">
                                                        <a class="action-icon btn-outline-primary d-flex justify-content-center border border-primary p-2 rounded-3"
                                                            data-bs-toggle="tooltip" data-bs-placement="top"
                                                            data-bs-custom-class="custom-tooltip"
                                                            data-bs-title="View Quizzes"
                                                            href="{{ route('quiz.index', $course->id) }}">
                                                            View Quizzes
                                                        </a>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- ****End-Body-Section**** -->
    </div>
@endsection
