@extends('layouts.app')

@section('title', $app_setting['name'] . ' | Report')

@section('content')

    <div class="app-main-outer">
        <div class="app-main-inner">
            {{-- top --}}

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-5">

                                    <select name="filter_type"
                                        class="form-select js-states form-control rounded-3 text-uppercase"
                                        id="useSelectric">
                                        <option value="all" class="py-4 text-uppercase"
                                            {{ request('filter_type') == 'all' ? 'selected' : '' }}>all</option>
                                        <option value="sale" class="py-4 text-uppercase"
                                            {{ request('filter_type') == 'sale' ? 'selected' : '' }}>sale</option>
                                        <option value="unpaid" class="py-4 text-uppercase"
                                            {{ request('filter_type') == 'unpaid' ? 'selected' : '' }}>
                                            unpaid
                                        </option>
                                    </select>

                                </div>
                                <div class="col-lg-3">
                                    <div class="date-controller">
                                        <input class="form-control" type="text" name="daterange" autocomplete="off">
                                        <img src="{{ asset('assets/images/menu/calendar.svg') }}" alt="icon"
                                            class="date-icon">
                                    </div>
                                </div>
                                <div class="col-lg-4 d-flex justify-content-end align-items-center gap-3">
                                    <button class="btn btn-outline-primary btn-lg" type="submit" onclick="printTable()"><i
                                            class="bi bi-printer-fill"></i> Print</button>
                                    <div class="dropdown">
                                        <button class="btn btn-outline-primary btn-lg dropdown-toggle" type="submit"
                                            data-bs-toggle="dropdown">Export
                                            As</button>
                                        <ul class="dropdown-menu dropdown-menu-dark">
                                            <li><a class="dropdown-item" id="exportCSV"
                                                    href="{{ route('report.exportCSV') }}">CSV File</a>
                                            </li>
                                            <li><a class="dropdown-item" href="{{ route('report.generate.pdf') }}"
                                                    target="_blank">PDF File</a>
                                            </li>
                                            <form id="filterForm" action="{{ route('report.generate.pdf') }}" method="GET"
                                                target="_blank">
                                                <input type="hidden" name="filter_type" id="filterType" value="">
                                                <input type="hidden" name="daterange" id="filterDate" value="">
                                                <input type="hidden" name="page" value="{{ request('page') ?? 1 }}" />
                                            </form>
                                            <form id="filterFormCSV" action="{{ route('report.exportCSV') }}" method="GET"
                                                target="_blank">
                                                <input type="hidden" name="filter_type" id="filterTypeCSV" value="">
                                                <input type="hidden" name="daterange" id="filterDateCSV" value="">
                                                <input type="hidden" name="page" value="{{ request('page') ?? 1 }}" />
                                            </form>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row" id="deleteTableItem">
                <div class="col-md-12">
                    <div class="card mb-5">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-responsive-xl">
                                    <thead>
                                        <tr>
                                            <th><strong>SL</strong></th>
                                            <th><strong>Date</strong></th>
                                            <th><strong>Course</strong></th>
                                            <th><strong>Category</strong></th>
                                            <th><strong>Price</strong></th>
                                            <th><strong>Total Enroll</strong></th>
                                            <th><strong>Total Transactions</strong></th>
                                            <th><strong>Grand Total</strong></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse ($reports as $report)
                                            <tr>
                                                <td class="tableId">{{ $reports->firstItem() + $loop->index }}</td>
                                                <td class="tableId">{{ $report?->created_at }}</td>
                                                <td class="tableId">{{ $report?->title }}</td>
                                                <td class="tableId">{{ $report?->category?->title }}</td>
                                                <td class="tableId">
                                                    {{ $report?->price && $report?->regular_price ? currency($report?->price) : currency($report?->regular_price) }}
                                                </td>
                                                <td class="tableId">{{ $report->enrollments->count() }}</td>
                                                <td class="tableId">{{ $report->transactions->count() }}</td>
                                                <td class="tableId">
                                                    {{ $report->transactions->pluck('payment_amount')->toArray() ? currency(array_sum($report->transactions->pluck('payment_amount')->toArray())) : 'N/A' }}
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="8" class="text-center text-danger fw-bold">No
                                                    information available.</td>
                                            </tr>
                                        @endforelse

                                    </tbody>
                                </table>
                            </div>
                            <div class="mt-3">
                                {{ $reports->links() }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- bottom --}}
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        function printTable() {
            const table = document.querySelector('#deleteTableItem .table-responsive');
            const printWindow = window.open('', '', 'width=800,height=600');
            printWindow.document.write(`
            <html>
                <head>
                    <title>Print Table</title>
                    <style>
                        /* Custom styles for the printed table */
                        body {
                            font-family: Arial, sans-serif;
                            margin: 20px;
                        }
                        table {
                            width: 100%;
                            border-collapse: collapse;
                        }
                        table, th, td {
                            border: 1px solid black;
                        }
                        th, td {
                            padding: 10px;
                            text-align: left;
                        }
                        th {
                            background-color: #f4f4f4;
                        }
                    </style>
                </head>
                <body>
                    ${table.outerHTML}
                </body>
            </html>
        `);
            printWindow.document.close();
            printWindow.print();
            printWindow.onafterprint = function() {
                printWindow.close();
            };
        }
    </script>


    <script>
        $(function() {
            function cb(start, end) {
                $('#filterDate').val(start.format('YYYY-MM-DD') + ' - ' + end.format('YYYY-MM-DD'));
            }

            var selectedStartedDate = "{{ request()->input('daterange') }}";
            var start, end;

            if (selectedStartedDate) {
                start = moment(selectedStartedDate.split(' - ')[0]);
                end = moment(selectedStartedDate.split(' - ')[1]);
            } else {
                start = moment().subtract(29, 'days');
                end = moment();
            }

            $('input[name="daterange"]').daterangepicker({
                startDate: start,
                endDate: end,
                opens: 'left',
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1,
                        'month').endOf('month')]
                }
            }, cb);

        });
    </script>

    <script>
        $(document).ready(function() {
            // $(".useSelectric").select2();
            $('select[name="filter_type"]').change(function() {
                setUrl();
            });

            $('input[name="daterange"]').change(function() {
                setUrl();
            });

            function setUrl() {
                var filterType = $('select[name="filter_type"]').val();
                var dateRange = $('input[name="daterange"]').val();
                window.location.href = "{{ route('report.filter') }}?filter_type=" + filterType + "&daterange=" +
                    dateRange;
            }
        });
    </script>

    <script>
        document.querySelector('.dropdown-item[href="{{ route('report.generate.pdf') }}"]').addEventListener('click',
            function(e) {
                e.preventDefault();

                // Capture the filter values
                const filterType = document.querySelector('select[name="filter_type"').value;
                const dateRange = document.querySelector('input[name="daterange"]').value;

                document.getElementById('filterType').value = filterType;
                document.getElementById('filterDate').value = dateRange;

                document.getElementById('filterForm').submit();
            });

        document.querySelector('.dropdown-item[href="{{ route('report.exportCSV') }}"]').addEventListener('click',
            function(e) {
                e.preventDefault();

                // Capture the filter values
                const filterType = document.querySelector('select[name="filter_type"]').value;
                const dateRange = document.querySelector('input[name="daterange"]').value;

                document.getElementById('filterTypeCSV').value = filterType;
                document.getElementById('filterDateCSV').value = dateRange;

                document.getElementById('filterFormCSV').submit();
            });
    </script>
@endpush
