@extends('layouts.app')

@section('title', $app_setting['name'] . ' | Settings')

@section('content')
    <!-- ****Body-Section***** -->
    <div class="app-main-outer">
        <div class="app-main-inner">
            <div class="page-title-actions px-3 d-flex">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Settings</li>
                    </ol>
                </nav>
            </div>

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <h3 class="m-0 p-0">
                                {{ __('Settings') }}</h3>
                        </div>
                    </div>
                </div>
            </div>

            <form action="{{ route('setting.update') }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')

                <div class="row my-3">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-4 border-end">
                                        <div class="mb-3">
                                            <img id="logoImagePreview" src="{{ $setting->logoPath }}" class="w-100"
                                                style="max-height: 380px; border-radius:1rem; object-fit: cover">
                                        </div>
                                        <div>
                                            <h4 class="form-label">System Logo (JPG, JPEG, PNG)*</h4>
                                            <label for="formLogoImage" class="w-100 border rounded-3">
                                                <div class="d-flex justify-content-center align-items-center gap-2 p-3"
                                                    style="width: 160px; background-color: #EDEEF1">
                                                    <span>Choose a file</span>
                                                    <img src="/assets/images/media/file-plus.svg">
                                                </div>
                                            </label>
                                            <input name="logo" class="form-control form-control-lg" id="formLogoImage"
                                                type="file" hidden
                                                onchange="document.getElementById('logoImagePreview').src = window.URL.createObjectURL(this.files[0])" />
                                        </div>
                                    </div>
                                    <div class="col-md-4 border-end">
                                        <div class="mb-3">
                                            <img id="footerImagePreview" src="{{ $setting->footerPath }}" class="w-100"
                                                style="max-height: 380px; border-radius:1rem; object-fit: cover">
                                        </div>
                                        <div>
                                            <h4 class="form-label">System Footer Logo (JPG, JPEG, PNG)*</h4>
                                            <label for="formFooterImage" class="w-100 border rounded-3">
                                                <div class="d-flex justify-content-center align-items-center gap-2 p-3"
                                                    style="width: 160px; background-color: #EDEEF1">
                                                    <span>Choose a file</span>
                                                    <img src="/assets/images/media/file-plus.svg">
                                                </div>
                                            </label>
                                            <input name="footerlogo" class="form-control form-control-lg"
                                                id="formFooterImage" type="file" hidden
                                                onchange="document.getElementById('footerImagePreview').src = window.URL.createObjectURL(this.files[0])" />
                                        </div>
                                    </div>
                                    <div class="col-md-4 border-end">
                                        <div class="mb-3">
                                            <img id="faviconImagePreview" src="{{ $setting->faviconPath }}" class="w-100"
                                                style="max-height: 108px; border-radius:1rem; object-fit: contain">
                                        </div>
                                        <div>
                                            <h4 class="form-label">Website Favicon (JPG, JPEG, PNG)*</h4>
                                            <label for="formFaviconImage" class="w-100 border rounded-3">
                                                <div class="d-flex justify-content-center align-items-center gap-2 p-3"
                                                    style="width: 160px; background-color: #EDEEF1">
                                                    <span>Choose a file</span>
                                                    <img src="/assets/images/media/file-plus.svg">
                                                </div>
                                            </label>
                                            <input name="favicon" class="form-control form-control-lg" id="formFaviconImage"
                                                type="file" hidden
                                                onchange="document.getElementById('faviconImagePreview').src = window.URL.createObjectURL(this.files[0])" />
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="row">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="row">

                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-12 mb-3">
                                                <p class="fw-bold border-bottom border-2 pb-3 ">System Information</p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-4 mb-3">
                                        <label for="courseTitle" class="form-label">System Title <span
                                                class="text-danger fw-bold">*</span></label>
                                        <input type="text" class="form-control" id="courseTitle" name="app_name"
                                            value="{{ config('app.name') }}" />
                                        @error('app_name')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label for="courseTitle" class="form-label">Currency <span
                                                class="text-danger fw-bold">*</span></label>
                                        <input type="text" class="form-control" id="courseTitle" name="app_currency"
                                            value="{{ config('app.currency') }}" />
                                        @error('app_currency')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label for="timezoneInput" class="form-label">Timezone</label>
                                        <select id="instructorInput" class="form-select form-control"
                                            style="width: 100%;" name="app_timezone" aria-hidden="true">
                                            @foreach ($timezones as $timezone)
                                                <option value="{{ $timezone['zone'] }}"
                                                    {{ $timezone['zone'] === config('app.timezone') ? 'selected="selected"' : '' }}>
                                                    {{ $timezone['diff_from_GMT'] }} - {{ $timezone['zone'] }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('Timezone')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="col-md-4 mb-3">
                                        <label for="courseTitle" class="form-label">Currency Symbol<span
                                                class="text-danger fw-bold">*</span></label>
                                        <input type="text" class="form-control" id="courseTitle"
                                            name="app_currency_symbol" value="{{ config('app.currency_symbol') }}" />
                                        @error('app_currency_symbol')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label class="form-label" for="currencypositionInput">Currency
                                            Position</label>
                                        <select id="currencypositionInput" class="form-select form-control"
                                            style="width: 100%;" name="currency_position" aria-hidden="true">
                                            <option value="Left"
                                                {{ $setting->currency_position === 'Left' ? 'selected' : '' }}>
                                                Left
                                            </option>
                                            <option value="Right"
                                                {{ $setting->currency_position === 'Right' ? 'selected' : '' }}>
                                                Right
                                            </option>
                                        </select>
                                        @error('currency_position')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-12 my-3">
                                                <p class="fw-bold border-bottom border-2 pb-3 ">Footer Information</p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-4 mb-3">
                                        <label for="courseTitle" class="form-label">Footer text <span
                                                class="text-danger fw-bold">*</span></label>
                                        <input type="text" class="form-control" id="courseTitle" name="footer_text"
                                            value="{{ $setting->footer_text }}" />
                                        @error('footer_text')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="col-md-4">
                                        <div class="row">
                                            <div class="col-md-12 mb-3">
                                                <label for="footer_contact_number" class="form-label">Footer Contact
                                                    Number(+tel)<span class="text-danger fw-bold">*</span></label>
                                                <input type="tel" class="form-control" placeholder="+8801XXXXXXXXX"
                                                    id="footer_contact_number" name="footer_contact_number"
                                                    value="{{ $setting->footer_contact_number }}">
                                                @error('footer_contact_number')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="row">
                                            <div class="col-md-12 mb-3">
                                                <label for="footer_support_mail" class="form-label">Footer Support
                                                    Mail<span class="text-danger fw-bold">*</span></label>
                                                <input type="email" class="form-control" id="footer_support_mail"
                                                    placeholder="support@example.com" name="footer_support_mail"
                                                    value="{{ $setting->footer_support_mail }}">
                                                @error('footer_support_mail')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-12 mb-3">
                                                <label for="footer_description" class="form-label">Footer Description<span
                                                        class="text-danger fw-bold">*</span></label>
                                                <textarea class="form-control" name="footer_description" id="footer_description" rows="3"
                                                    placeholder="Footer Description">{{ $setting->footer_description ?? '' }}</textarea>
                                                @error('app_currency_symbol')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-12 my-3">
                                                <p class="fw-bold border-bottom border-2 pb-3 ">Social Media Link</p>
                                            </div>
                                        </div>
                                    </div>

                                    @foreach ($socialMedias as $media)
                                        <div class="col-md-4 mb-3">
                                            <label for="facebook_link" class="form-label"> <i
                                                    class="{{ $media->icon }} fs-6"></i>
                                                {{ $media->title }} Link</label>
                                            <input type="text" class="form-control" id="facebook_link"
                                                name="social_links[{{ $media->id }}]"
                                                placeholder="{{ $media->title }} Link"
                                                value="{{ old('social_links.' . $media->id, $media->url ?? '') }}" />
                                            @error('social_links.' . $media->id)
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    @endforeach

                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-12 my-3">
                                                <p class="fw-bold border-bottom border-2 pb-3 ">Downloadable Link</p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="row">

                                            <div class="col-md-4 mt-auto">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <label for="play_store" class="form-label"> <i
                                                                class="bi bi-google-play fs-6"></i> Play Store<span
                                                                class="text-danger fw-bold">*</span></label>
                                                        <input type="email" class="form-control" id="play_store"
                                                            placeholder="Play Store Link" name="play_store_url"
                                                            value="{{ $setting->play_store_url }}">
                                                        @error('play_store_url')
                                                            <span class="text-danger">{{ $message }}</span>
                                                        @enderror
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-4 mt-auto">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <label for="app_store" class="form-label"><i
                                                                class="bi bi-apple fs-6"></i> App Store<span
                                                                class="text-danger fw-bold">*</span></label>
                                                        <input type="email" class="form-control" id="app_store"
                                                            placeholder="App Store Link" name="app_store_url"
                                                            value="{{ $setting->app_store_url }}">
                                                        @error('app_store_url')
                                                            <span class="text-danger">{{ $message }}</span>
                                                        @enderror
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-4 my-auto">
                                                <div class="mb-3 d-flex justify-content-center">
                                                    <img id="scanerImagePreview" src="{{ $setting->scanerPath }}"
                                                        style="width:100px; height:100px; border-radius:1rem; object-fit: contain">
                                                </div>
                                                <div>
                                                    <h4 class="form-label">Website QR Scaner(JPG, JPEG, PNG)*</h4>
                                                    <label for="formScanerImage" class="w-100 border rounded-3">
                                                        <div class="d-flex justify-content-center align-items-center gap-2 p-3"
                                                            style="width: 160px; background-color: #EDEEF1">
                                                            <span>Choose a file</span>
                                                            <img src="/assets/images/media/file-plus.svg">
                                                        </div>
                                                    </label>
                                                    <input name="scaner" class="form-control form-control-lg"
                                                        id="formScanerImage" type="file" hidden
                                                        onchange="document.getElementById('scanerImagePreview').src = window.URL.createObjectURL(this.files[0])" />
                                                </div>
                                            </div>
                                        </div>
                                    </div>


                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-body">
                                <button type="submit" class="btn btn-primary px-5 py-2">{{ __('Update') }}</button>
                            </div>
                        </div>
                    </div>
                </div>

            </form>


        </div>


        <!-- ****End-Body-Section**** -->
    </div>
    </div>
@endsection
