<?php $__env->startSection('style'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/backend/css/bootstrap-tagsinput.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/backend/css/summernote-bs4.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/backend/css/dropzone.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/backend/css/media-uploader.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('site-title'); ?>
    <?php echo e(__('New Blog Post')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="col-lg-12 col-ml-12 padding-bottom-30">
        <div class="row">
            <!-- basic form start -->
            <div class="col-lg-12">
                <div class="margin-top-40"></div>
                <?php echo $__env->make('backend/partials/message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <ul>
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>
            </div>
            <div class="col-lg-12 mt-5">
              <div class="card">
                  <div class="card-body">
                      <h4 class="header-title"><?php echo e(__('Add New Blog Post')); ?>

                         <a href="<?php echo e(route('admin.blog')); ?>" class="btn btn-info btn-xs pull-right"><i class="fas fa-angle-double-left"></i><?php echo e(__('All Blogs')); ?></a>
                      </h4>

                      <form action="<?php echo e(route('admin.blog.new')); ?>" method="post" enctype="multipart/form-data">
                          <?php echo csrf_field(); ?>
                          <div class="row">
                              <div class="col-lg-8">
                                  <div class="form-group">
                                      <label for="language"><strong><?php echo e(__('Language')); ?></strong></label>
                                      <select name="lang" id="language" class="form-control"style="height:42px;">
                                          <?php $__currentLoopData = $all_languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                          <option value="<?php echo e($lang->slug); ?>"><?php echo e($lang->name); ?></option>
                                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                      </select>
                                  </div>
                                  <div class="form-group">
                                      <label for="title"><?php echo e(__('Title')); ?></label>
                                      <input type="text" class="form-control"  id="title" name="title" placeholder="<?php echo e(__('Title')); ?>">
                                  </div>
                                  <div class="form-group">
                                      <label><?php echo e(__('Content')); ?></label>
                                      <input type="hidden" name="blog_content" >
                                      <div class="summernote"></div>
                                  </div>
                                  <div class="form-group">
                                      <label for="meta_title"><?php echo e(__('Meta Title')); ?></label>
                                      <input type="text" name="meta_title"  class="form-control">
                                  </div>
                                  <div class="form-group">
                                      <label for="meta_tags"><?php echo e(__('Meta Tags')); ?></label>
                                      <input type="text" name="meta_tags"  class="form-control" data-role="tagsinput" id="meta_tags">
                                  </div>
                                  <div class="form-group">
                                      <label for="meta_description"><?php echo e(__('Meta Description')); ?></label>
                                      <textarea name="meta_description"  class="form-control" rows="5" id="meta_description"></textarea>
                                  </div>
                              </div>
                              <div class="col-lg-4">
                                  <div class="form-group">
                                      <label for="title"><?php echo e(__('Slug')); ?></label>
                                      <input type="text" class="form-control"  id="slug"  name="slug" placeholder="<?php echo e(__('Slug')); ?>">
                                  </div>
                                  <div class="form-group">
                                      <label for="title"><?php echo e(__('Excerpt')); ?></label>
                                      <textarea name="excerpt" id="excerpt" class="form-control max-height-150" cols="30" rows="10"></textarea>
                                  </div>
                                  <div class="form-group">
                                      <label for="category"><?php echo e(__('Category')); ?></label>
                                      <select name="category" class="form-control" id="category"style="height:42px;">
                                          <option value=""><?php echo e(__("Select Category")); ?></option>
                                          <?php $__currentLoopData = $all_category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                              <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                      </select>
                                  </div>
                                  <div class="form-group">
                                      <label for="title"><?php echo e(__('Tags')); ?></label>
                                      <input type="text" class="form-control" name="tags" data-role="tagsinput">
                                  </div>
                                  <div class="form-group">
                                      <label for="author"><?php echo e(__('Author Name')); ?></label>
                                      <input type="text" class="form-control" name="author" id="author">
                                  </div>
                                  <div class="form-group">
                                      <label for="status"><?php echo e(__('Status')); ?></label>
                                      <select name="status" id="status" class="form-control">
                                          <option value="publish"><?php echo e(__('Publish')); ?></option>
                                          <option value="draft"><?php echo e(__('Draft')); ?></option>
                                      </select>
                                  </div>
                                  <div class="form-group">
                                      <label for="image"><?php echo e(__('Image')); ?></label>
                                      <div class="media-upload-btn-wrapper">
                                          <div class="img-wrap"></div>
                                          <input type="hidden" name="image">
                                          <button type="button" class="btn btn-info media_upload_form_btn" data-btntitle="Select Blog Image" data-modaltitle="Upload Blog Image" data-toggle="modal" data-target="#media_upload_modal">
                                              <?php echo e(__('Upload Image')); ?>

                                          </button>
                                      </div>
                                      <small><?php echo e(__('Recommended image size 1920x1280')); ?></small>
                                  </div>
                                  <button type="submit" class="btn btn-primary mt-4 pr-4 pl-4"><?php echo e(__('Add New Post')); ?></button>
                              </div>
                          </div>
                      </form>
                  </div>
              </div>
          </div>
        </div>
    </div>
  <?php echo $__env->make('backend.partials.media-upload.media-upload-markup', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('assets/backend/js/summernote-bs4.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/backend/js/bootstrap-tagsinput.js')); ?>"></script>
    <script>
    $(document).ready(function () {
        $(document).on('click','.category_edit_btn',function(){
            var el = $(this);
            var id = el.data('id');
            var name = el.data('name');
            var status = el.data('status');
            var modal = $('#category_edit_modal');
            modal.find('#category_id').val(id);
            modal.find('#edit_status option[value="'+status+'"]').attr('selected',true);
            modal.find('#edit_name').val(name);
        });
        $('.summernote').summernote({
            height: 400,   //set editable area's height
            codemirror: { // codemirror options
                theme: 'monokai'
            },
            callbacks: {
                onChange: function(contents, $editable) {
                    $(this).prev('input').val(contents);
                }
            }
        });
        if($('.summernote').length > 1){
            $('.summernote').each(function(index,value){
                $(this).summernote('code', $(this).data('content'));
            });
        }

        $(document).on('change','#language',function(e){
           e.preventDefault();
           var selectedLang = $(this).val();
           $.ajax({
              url: "<?php echo e(route('admin.blog.lang.cat')); ?>",
              type: "POST",
              data: {
                  _token : "<?php echo e(csrf_token()); ?>",
                  lang : selectedLang
              },
              success:function (data) {
                  $('#category').html('<option value="">Select Category</option>');
                  $.each(data,function(index,value){
                      $('#category').append('<option value="'+value.id+'">'+value.name+'</option>')
                  });
              }
           });
        });
    });
</script>
    <script src="<?php echo e(asset('assets/backend/js/dropzone.js')); ?>"></script>
    <?php echo $__env->make('backend.partials.media-upload.media-js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.admin-master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/xgenxchi/public_html/laravel/zixer/@core/resources/views/backend/pages/blog/new.blade.php ENDPATH**/ ?>